/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.playerprops;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class FavoriteDestinationsProperties {
    private Set<GlobalCoordinate> favoriteDestinations = new HashSet<GlobalCoordinate>();

    public void copyFrom(FavoriteDestinationsProperties source) {
        this.favoriteDestinations = new HashSet<GlobalCoordinate>(source.favoriteDestinations);
    }

    public boolean isDestinationFavorite(GlobalCoordinate coordinate) {
        return this.favoriteDestinations.contains(coordinate);
    }

    public void setDestinationFavorite(GlobalCoordinate coordinate, boolean favorite) {
        if (favorite) {
            this.favoriteDestinations.add(coordinate);
        } else {
            this.favoriteDestinations.remove(coordinate);
        }
    }

    public void saveNBTData(CompoundNBT compound) {
        FavoriteDestinationsProperties.writeFavoritesToNBT(compound, this.favoriteDestinations);
    }

    private static void writeFavoritesToNBT(CompoundNBT tagCompound, Collection<GlobalCoordinate> destinations) {
        ListNBT lst = new ListNBT();
        for (GlobalCoordinate destination : destinations) {
            CompoundNBT tc = new CompoundNBT();
            BlockPos c = destination.getCoordinate();
            tc.func_74768_a("x", c.func_177958_n());
            tc.func_74768_a("y", c.func_177956_o());
            tc.func_74768_a("z", c.func_177952_p());
            tc.func_74778_a("dim", destination.getDimension().getRegistryName().toString());
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("destinations", (INBT)lst);
    }

    public void loadNBTData(CompoundNBT compound) {
        this.favoriteDestinations.clear();
        FavoriteDestinationsProperties.readCoordinatesFromNBT(compound, this.favoriteDestinations);
    }

    private static void readCoordinatesFromNBT(CompoundNBT tagCompound, Set<GlobalCoordinate> destinations) {
        ListNBT lst = tagCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            BlockPos c = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            String dim = tc.func_74779_i("dim");
            destinations.add(new GlobalCoordinate(c, DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dim))));
        }
    }
}

