/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.basics;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.ConfigServer;

public class ReplacementRegistry {
    private static final HashSet<HashSet<Item>> replacements = new HashSet();

    public static void init() {
        for (Object key : (List)ConfigServer.SIMILAR_BLOCKS.get()) {
            if (!(key instanceof String)) continue;
            HashSet<Item> set = new HashSet<Item>();
            for (String id : ((String)key).split(";")) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
                if (item == null) {
                    ConstructionWand.LOGGER.warn("Replacement Registry: Could not find item " + id);
                    continue;
                }
                set.add(item);
            }
            if (set.isEmpty()) continue;
            replacements.add(set);
        }
    }

    public static Set<Item> getMatchingSet(Item item) {
        HashSet<Item> res = new HashSet<Item>();
        for (HashSet<Item> set : replacements) {
            if (!set.contains(item)) continue;
            res.addAll(set);
        }
        res.remove(item);
        return res;
    }

    public static boolean matchBlocks(Block b1, Block b2) {
        if (b1 == b2) {
            return true;
        }
        for (HashSet<Item> set : replacements) {
            if (!set.contains(b1.func_199767_j()) || !set.contains(b2.func_199767_j())) continue;
            return true;
        }
        return false;
    }
}

