/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Set;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.client.ClientEvents;
import thetadev.constructionwand.client.RenderTypes;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.wand.WandJob;

public class RenderBlockPreview {
    public WandJob wandJob;
    public Set<BlockPos> undoBlocks;

    @SubscribeEvent
    public void renderBlockHighlight(DrawHighlightEvent event) {
        Set<BlockPos> blocks;
        if (event.getTarget().func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult rtr = (BlockRayTraceResult)event.getTarget();
        Entity entity = event.getInfo().func_216773_g();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        float colorR = 0.0f;
        float colorG = 0.0f;
        float colorB = 0.0f;
        ItemStack wand = WandUtil.holdingWand(player);
        if (wand == null) {
            return;
        }
        if (!player.func_225608_bj_() || !ClientEvents.isOptKeyDown()) {
            if (this.wandJob == null || !RenderBlockPreview.compareRTR(this.wandJob.rayTraceResult, rtr) || !this.wandJob.wand.equals(wand)) {
                this.wandJob = ItemWand.getWandJob(player, player.func_130014_f_(), rtr, wand);
            }
            blocks = this.wandJob.getBlockPositions();
        } else {
            blocks = this.undoBlocks;
            colorG = 1.0f;
        }
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        MatrixStack ms = event.getMatrix();
        IRenderTypeBuffer buffer = event.getBuffers();
        IVertexBuilder lineBuilder = buffer.getBuffer(RenderTypes.TRANSLUCENT_LINES);
        double partialTicks = event.getPartialTicks();
        double d0 = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * partialTicks;
        double d1 = player.field_70137_T + (double)player.func_70047_e() + (player.func_226278_cu_() - player.field_70137_T) * partialTicks;
        double d2 = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * partialTicks;
        ms.func_227860_a_();
        for (BlockPos block : blocks) {
            AxisAlignedBB aabb = new AxisAlignedBB(block).func_72317_d(-d0, -d1, -d2);
            WorldRenderer.func_228430_a_((MatrixStack)ms, (IVertexBuilder)lineBuilder, (AxisAlignedBB)aabb, (float)colorR, (float)colorG, (float)colorB, (float)0.4f);
        }
        ms.func_227865_b_();
        event.setCanceled(true);
    }

    private static boolean compareRTR(BlockRayTraceResult rtr1, BlockRayTraceResult rtr2) {
        return rtr1.func_216350_a().equals((Object)rtr2.func_216350_a()) && rtr1.func_216354_b().equals((Object)rtr2.func_216354_b());
    }
}

