/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.basics.WandUtil;

public class HandlerShulkerbox
implements IContainerHandler {
    private final int SLOTS = 27;

    @Override
    public boolean matches(PlayerEntity player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.func_190916_E() == 1 && Block.func_149634_a((Item)inventoryStack.func_77973_b()) instanceof ShulkerBoxBlock;
    }

    @Override
    public int countItems(PlayerEntity player, ItemStack itemStack, ItemStack inventoryStack) {
        int count = 0;
        for (ItemStack stack : this.getItemList(inventoryStack)) {
            if (!WandUtil.stackEquals(stack, itemStack)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    @Override
    public int useItems(PlayerEntity player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        NonNullList<ItemStack> itemList = this.getItemList(inventoryStack);
        boolean changed = false;
        for (ItemStack stack : itemList) {
            if (!WandUtil.stackEquals(stack, itemStack)) continue;
            int toTake = Math.min(count, stack.func_190916_E());
            stack.func_190918_g(toTake);
            changed = true;
            if ((count -= toTake) != 0) continue;
            break;
        }
        if (changed) {
            this.setItemList(inventoryStack, itemList);
            player.field_71071_by.func_70296_d();
        }
        return count;
    }

    private NonNullList<ItemStack> getItemList(ItemStack itemStack) {
        CompoundNBT entityTag;
        NonNullList itemStacks = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        CompoundNBT rootTag = itemStack.func_77978_p();
        if (rootTag != null && rootTag.func_150297_b("BlockEntityTag", 10) && (entityTag = rootTag.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)entityTag, (NonNullList)itemStacks);
        }
        return itemStacks;
    }

    private void setItemList(ItemStack itemStack, NonNullList<ItemStack> itemStacks) {
        CompoundNBT rootTag = itemStack.func_196082_o();
        if (!rootTag.func_150297_b("BlockEntityTag", 10)) {
            rootTag.func_218657_a("BlockEntityTag", (INBT)new CompoundNBT());
        }
        ItemStackHelper.func_191282_a((CompoundNBT)rootTag.func_74775_l("BlockEntityTag"), itemStacks);
    }
}

