/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.undo;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.network.PacketUndoBlocks;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class UndoHistory {
    private final HashMap<UUID, PlayerEntry> history = new HashMap();

    private PlayerEntry getEntryFromPlayer(PlayerEntity player) {
        return this.history.computeIfAbsent(player.func_110124_au(), k -> new PlayerEntry());
    }

    public void add(PlayerEntity player, World world, List<ISnapshot> placeSnapshots) {
        LinkedList<HistoryEntry> list = this.getEntryFromPlayer((PlayerEntity)player).entries;
        list.add(new HistoryEntry(placeSnapshots, world));
        while (list.size() > (Integer)ConfigServer.UNDO_HISTORY.get()) {
            list.removeFirst();
        }
    }

    public void removePlayer(PlayerEntity player) {
        this.history.remove(player.func_110124_au());
    }

    public void updateClient(PlayerEntity player, boolean ctrlDown) {
        HistoryEntry entry;
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        PlayerEntry playerEntry = this.getEntryFromPlayer(player);
        playerEntry.undoActive = ctrlDown;
        LinkedList<HistoryEntry> historyEntries = playerEntry.entries;
        Set<Object> positions = historyEntries.isEmpty() ? Collections.emptySet() : ((entry = historyEntries.getLast()) == null || !entry.world.equals(world) ? Collections.emptySet() : entry.getBlockPositions());
        PacketUndoBlocks packet = new PacketUndoBlocks(positions);
        ConstructionWand.instance.HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)packet);
    }

    public boolean isUndoActive(PlayerEntity player) {
        return this.getEntryFromPlayer((PlayerEntity)player).undoActive;
    }

    public boolean undo(PlayerEntity player, World world, BlockPos pos) {
        PlayerEntry playerEntry = this.getEntryFromPlayer(player);
        if (!playerEntry.undoActive) {
            return false;
        }
        LinkedList<HistoryEntry> historyEntries = playerEntry.entries;
        if (historyEntries.isEmpty()) {
            return false;
        }
        HistoryEntry entry = historyEntries.getLast();
        if (!entry.world.equals(world) || !entry.withinRange(pos)) {
            return false;
        }
        if (entry.undo(player)) {
            historyEntries.remove(entry);
            this.updateClient(player, true);
            return true;
        }
        return false;
    }

    private static class HistoryEntry {
        public final List<ISnapshot> placeSnapshots;
        public final World world;

        public HistoryEntry(List<ISnapshot> placeSnapshots, World world) {
            this.placeSnapshots = placeSnapshots;
            this.world = world;
        }

        public Set<BlockPos> getBlockPositions() {
            return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
        }

        public boolean withinRange(BlockPos pos) {
            Set<BlockPos> positions = this.getBlockPositions();
            if (positions.contains(pos)) {
                return true;
            }
            for (BlockPos p : positions) {
                if (!pos.func_218141_a((Vector3i)p, 3.0)) continue;
                return true;
            }
            return false;
        }

        public boolean undo(PlayerEntity player) {
            for (ISnapshot snapshot : this.placeSnapshots) {
                if (snapshot.canRestore(this.world, player)) continue;
                return false;
            }
            for (ISnapshot snapshot : this.placeSnapshots) {
                ItemStack stack;
                if (!snapshot.restore(this.world, player) || player.func_184812_l_() || player.field_71071_by.func_70441_a(stack = snapshot.getRequiredItems())) continue;
                player.func_71019_a(stack, false);
            }
            player.field_71071_by.func_70296_d();
            SoundEvent sound = SoundEvents.field_187544_ad;
            this.world.func_184133_a(null, WandUtil.playerPos(player), sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
    }

    private static class PlayerEntry {
        public final LinkedList<HistoryEntry> entries = new LinkedList();
        public boolean undoActive = false;
    }
}

