/*
 * Decompiled with CFR 0.152.
 */
package li.cil.ceres;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.ceres.Ceres;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import org.jetbrains.annotations.Contract;

public final class BinarySerialization {
    private static final int OBJECT_ARRAY_NULL_VALUE = -1;
    private static final Map<Class<?>, ArraySerializer> ARRAY_SERIALIZERS = new HashMap();

    public static <T> void serialize(DataOutputStream stream, T value, Class<T> type) throws SerializationException {
        Ceres.getSerializer(type).serialize(new Serializer(stream), type, value);
    }

    public static <T> ByteBuffer serialize(T value, Class<T> type) throws SerializationException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        BinarySerialization.serialize(new DataOutputStream(data), value, type);
        return ByteBuffer.wrap(data.toByteArray());
    }

    public static <T> void serialize(DataOutputStream stream, T value) throws SerializationException {
        Class<?> type = value.getClass();
        BinarySerialization.serialize(stream, value, type);
    }

    public static <T> ByteBuffer serialize(T value) throws SerializationException {
        Class<?> type = value.getClass();
        return BinarySerialization.serialize(value, type);
    }

    public static <T> T deserialize(DataInputStream stream, Class<T> type, @Nullable T into) throws SerializationException {
        return Ceres.getSerializer(type).deserialize(new Deserializer(stream), type, into);
    }

    public static <T> T deserialize(DataInputStream stream, Class<T> type) throws SerializationException {
        return BinarySerialization.deserialize(stream, type, null);
    }

    public static <T> T deserialize(DataInputStream stream, T into) throws SerializationException {
        Class<?> type = into.getClass();
        return (T)BinarySerialization.deserialize(stream, type, into);
    }

    public static <T> T deserialize(ByteBuffer data, Class<T> type, @Nullable T into) throws SerializationException {
        return BinarySerialization.deserialize(new DataInputStream(new ByteArrayInputStream(data.array())), type, into);
    }

    public static <T> T deserialize(ByteBuffer data, Class<T> type) throws SerializationException {
        return BinarySerialization.deserialize(new DataInputStream(new ByteArrayInputStream(data.array())), type, null);
    }

    public static <T> T deserialize(ByteBuffer data, T into) throws SerializationException {
        return BinarySerialization.deserialize(new DataInputStream(new ByteArrayInputStream(data.array())), into);
    }

    static {
        ARRAY_SERIALIZERS.put(Boolean.TYPE, new BooleanArraySerializer());
        ARRAY_SERIALIZERS.put(Byte.TYPE, new ByteArraySerializer());
        ARRAY_SERIALIZERS.put(Character.TYPE, new CharArraySerializer());
        ARRAY_SERIALIZERS.put(Short.TYPE, new ShortArraySerializer());
        ARRAY_SERIALIZERS.put(Integer.TYPE, new IntArraySerializer());
        ARRAY_SERIALIZERS.put(Long.TYPE, new LongArraySerializer());
        ARRAY_SERIALIZERS.put(Float.TYPE, new FloatArraySerializer());
        ARRAY_SERIALIZERS.put(Double.TYPE, new DoubleArraySerializer());
        ARRAY_SERIALIZERS.put(Enum.class, new EnumArraySerializer());
        ARRAY_SERIALIZERS.put(String.class, new StringArraySerializer());
    }

    private static final class StringArraySerializer
    implements ArraySerializer {
        private StringArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            String[] data = (String[])value;
            try {
                stream.writeInt(data.length);
                for (String datum : data) {
                    stream.writeUTF(datum);
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                String[] data = (String[])into;
                if (data == null || data.length != length) {
                    data = new String[length];
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = stream.readUTF();
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class EnumArraySerializer
    implements ArraySerializer {
        private EnumArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            Enum[] data = (Enum[])value;
            try {
                stream.writeInt(data.length);
                for (Enum datum : data) {
                    stream.writeInt(datum.ordinal());
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            Class<?> componentType = type.getComponentType();
            ?[] enumConstants = componentType.getEnumConstants();
            try {
                int length = stream.readInt();
                Enum[] data = (Enum[])into;
                if (data == null || data.length != length) {
                    data = (Enum[])Array.newInstance(componentType, length);
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = (Enum)enumConstants[stream.readInt()];
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class DoubleArraySerializer
    implements ArraySerializer {
        private DoubleArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            double[] data = (double[])value;
            try {
                stream.writeInt(data.length);
                for (double datum : data) {
                    stream.writeDouble(datum);
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                double[] data = (double[])into;
                if (data == null || data.length != length) {
                    data = new double[length];
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = stream.readDouble();
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class FloatArraySerializer
    implements ArraySerializer {
        private FloatArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            float[] data = (float[])value;
            try {
                stream.writeInt(data.length);
                for (float datum : data) {
                    stream.writeFloat(datum);
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                float[] data = (float[])into;
                if (data == null || data.length != length) {
                    data = new float[length];
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = stream.readFloat();
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class LongArraySerializer
    implements ArraySerializer {
        private LongArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            long[] data = (long[])value;
            try {
                stream.writeInt(data.length);
                for (long datum : data) {
                    stream.writeLong(datum);
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                long[] data = (long[])into;
                if (data == null || data.length != length) {
                    data = new long[length];
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = stream.readLong();
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class IntArraySerializer
    implements ArraySerializer {
        private IntArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            int[] data = (int[])value;
            try {
                stream.writeInt(data.length);
                for (int datum : data) {
                    stream.writeInt(datum);
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                int[] data = (int[])into;
                if (data == null || data.length != length) {
                    data = new int[length];
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = stream.readInt();
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class ShortArraySerializer
    implements ArraySerializer {
        private ShortArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            short[] data = (short[])value;
            try {
                stream.writeInt(data.length);
                for (short datum : data) {
                    stream.writeShort(datum);
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                short[] data = (short[])into;
                if (data == null || data.length != length) {
                    data = new short[length];
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = stream.readShort();
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class CharArraySerializer
    implements ArraySerializer {
        private CharArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            char[] data = (char[])value;
            try {
                stream.writeInt(data.length);
                for (char datum : data) {
                    stream.writeChar(datum);
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                char[] data = (char[])into;
                if (data == null || data.length != length) {
                    data = new char[length];
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = stream.readChar();
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class ByteArraySerializer
    implements ArraySerializer {
        private ByteArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            byte[] data = (byte[])value;
            try {
                stream.writeInt(data.length);
                stream.write(data);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                byte[] data = (byte[])into;
                if (data == null || data.length != length) {
                    data = new byte[length];
                }
                stream.readFully(data);
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static final class BooleanArraySerializer
    implements ArraySerializer {
        private BooleanArraySerializer() {
        }

        @Override
        public void serialize(DataOutputStream stream, Object value) {
            boolean[] data = (boolean[])value;
            try {
                stream.writeInt(data.length);
                for (boolean datum : data) {
                    stream.writeBoolean(datum);
                }
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public Object deserialize(DataInputStream stream, Class<?> type, Object into) {
            try {
                int length = stream.readInt();
                boolean[] data = (boolean[])into;
                if (data == null || data.length != length) {
                    data = new boolean[length];
                }
                for (int i = 0; i < length; ++i) {
                    data[i] = stream.readBoolean();
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }
    }

    private static interface ArraySerializer {
        public void serialize(DataOutputStream var1, Object var2);

        public Object deserialize(DataInputStream var1, Class<?> var2, @Nullable Object var3);
    }

    private static final class Deserializer
    implements DeserializationVisitor {
        private final DataInputStream stream;

        private Deserializer(DataInputStream stream) {
            this.stream = stream;
        }

        @Override
        public boolean getBoolean(String name) throws SerializationException {
            try {
                return this.stream.readBoolean();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public byte getByte(String name) throws SerializationException {
            try {
                return this.stream.readByte();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public char getChar(String name) throws SerializationException {
            try {
                return this.stream.readChar();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public short getShort(String name) throws SerializationException {
            try {
                return this.stream.readShort();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public int getInt(String name) throws SerializationException {
            try {
                return this.stream.readInt();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public long getLong(String name) throws SerializationException {
            try {
                return this.stream.readLong();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public float getFloat(String name) throws SerializationException {
            try {
                return this.stream.readFloat();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public double getDouble(String name) throws SerializationException {
            try {
                return this.stream.readDouble();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        @Nullable
        public Object getObject(String name, Class<?> type, @Nullable Object into) throws SerializationException {
            if (this.isNull()) {
                return null;
            }
            if (type.isArray()) {
                return Deserializer.getArray(this.stream, type, into);
            }
            if (type.isEnum()) {
                return type.getEnumConstants()[this.getInt(name)];
            }
            if (type == String.class) {
                try {
                    return this.stream.readUTF();
                }
                catch (IOException e) {
                    throw new SerializationException(e);
                }
            }
            return Ceres.getSerializer(type).deserialize(this, type, into);
        }

        private static Object getArray(DataInputStream stream, Class<?> type, @Nullable Object into) {
            ArrayComponentDeserializer componentDeserializer;
            Class<?> componentType = type.getComponentType();
            ArraySerializer arraySerializer = (ArraySerializer)ARRAY_SERIALIZERS.get(componentType);
            if (arraySerializer != null) {
                return arraySerializer.deserialize(stream, type, into);
            }
            if (componentType.isArray()) {
                componentDeserializer = Deserializer::getArray;
            } else {
                li.cil.ceres.api.Serializer<?> serializer = Ceres.getSerializer(componentType);
                componentDeserializer = (s, t, i) -> serializer.deserialize(new Deserializer(s), t, i);
            }
            try {
                int length = stream.readInt();
                Object[] data = (Object[])into;
                if (data == null || data.length != length) {
                    data = (Object[])Array.newInstance(componentType, length);
                }
                for (int i2 = 0; i2 < length; ++i2) {
                    int componentLength = stream.readInt();
                    if (componentLength <= 0) continue;
                    byte[] bytes = new byte[componentLength];
                    stream.readFully(bytes);
                    data[i2] = componentDeserializer.deserialize(new DataInputStream(new ByteArrayInputStream(bytes)), componentType, data[i2]);
                }
                return data;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        private boolean isNull() throws SerializationException {
            try {
                return this.stream.readBoolean();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @FunctionalInterface
        private static interface ArrayComponentDeserializer {
            public Object deserialize(DataInputStream var1, Class<?> var2, @Nullable Object var3);
        }
    }

    private static final class Serializer
    implements SerializationVisitor {
        private final DataOutputStream stream;

        private Serializer(DataOutputStream stream) {
            this.stream = stream;
        }

        @Override
        public void putBoolean(String name, boolean value) throws SerializationException {
            try {
                this.stream.writeBoolean(value);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public void putByte(String name, byte value) throws SerializationException {
            try {
                this.stream.writeByte(value);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public void putChar(String name, char value) throws SerializationException {
            try {
                this.stream.writeChar(value);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public void putShort(String name, short value) throws SerializationException {
            try {
                this.stream.writeShort(value);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public void putInt(String name, int value) throws SerializationException {
            try {
                this.stream.writeInt(value);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public void putLong(String name, long value) throws SerializationException {
            try {
                this.stream.writeLong(value);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public void putFloat(String name, float value) throws SerializationException {
            try {
                this.stream.writeFloat(value);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public void putDouble(String name, double value) throws SerializationException {
            try {
                this.stream.writeDouble(value);
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        @Override
        public void putObject(String name, Class<?> type, @Nullable Object value) throws SerializationException {
            if (this.putIsNull(value)) {
                return;
            }
            if (type.isArray()) {
                Serializer.putArray(this.stream, name, type, value);
            } else if (type.isEnum()) {
                this.putInt(name, ((Enum)value).ordinal());
            } else if (type == String.class) {
                String data = (String)value;
                try {
                    this.stream.writeUTF(data);
                }
                catch (IOException e) {
                    throw new SerializationException(e);
                }
            } else {
                Ceres.getSerializer(type).serialize(this, type, value);
            }
        }

        @Contract(value="null -> true")
        private boolean putIsNull(@Nullable Object value) {
            try {
                boolean isNull = value == null;
                this.stream.writeBoolean(isNull);
                return isNull;
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
        }

        private static void putArray(DataOutputStream stream, String name, Class<?> type, Object value) {
            Class<?> componentType = type.getComponentType();
            ArraySerializer arraySerializer = (ArraySerializer)ARRAY_SERIALIZERS.get(componentType);
            if (arraySerializer != null) {
                arraySerializer.serialize(stream, value);
            } else {
                ArrayComponentSerializer componentSerializer;
                if (componentType.isArray()) {
                    componentSerializer = (s, t, v) -> Serializer.putArray(s, name, t, v);
                } else {
                    li.cil.ceres.api.Serializer<?> serializer = Ceres.getSerializer(componentType);
                    componentSerializer = (s, t, v) -> serializer.serialize(new Serializer(s), t, v);
                }
                ByteArrayOutputStream componentData = new ByteArrayOutputStream();
                DataOutputStream componentStream = new DataOutputStream(componentData);
                Object[] data = (Object[])value;
                try {
                    stream.writeInt(data.length);
                    for (Object datum : data) {
                        if (datum == null) {
                            stream.writeInt(-1);
                            continue;
                        }
                        if (datum.getClass() != componentType) {
                            throw new SerializationException(String.format("Polymorphism detected in array [%s]. This is not supported.", name));
                        }
                        componentSerializer.serialize(componentStream, componentType, datum);
                        stream.writeInt(componentData.size());
                        stream.write(componentData.toByteArray());
                        componentData.reset();
                    }
                }
                catch (IOException e) {
                    throw new SerializationException(e);
                }
            }
        }

        @FunctionalInterface
        private static interface ArrayComponentSerializer {
            public void serialize(DataOutputStream var1, Class<?> var2, Object var3);
        }
    }
}

