/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.api.memory;

import java.util.Objects;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.memory.MemoryRange;

public final class MappedMemoryRange
extends MemoryRange {
    public final MemoryMappedDevice device;

    public MappedMemoryRange(MemoryMappedDevice device, long start, long end) {
        super(start, end);
        this.device = device;
    }

    public MappedMemoryRange(MemoryMappedDevice device, long address) {
        this(device, address, address + (long)device.getLength() - 1L);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MappedMemoryRange that = (MappedMemoryRange)o;
        return this.device.equals(that.device);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.device);
    }

    @Override
    public String toString() {
        return String.format("%s@%s", this.device, super.toString());
    }
}

