/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.api.memory;

import java.util.Objects;

public class MemoryRange {
    public final long start;
    public final long end;

    public static MemoryRange of(long start, long end) {
        return new MemoryRange(start, end);
    }

    public static MemoryRange at(long address, int length) {
        return new MemoryRange(address, address + (long)length - 1L);
    }

    protected MemoryRange(long start, long end) {
        if (Long.compareUnsigned(start, end) > 0) {
            throw new IllegalArgumentException();
        }
        if (Long.compareUnsigned(end - start + 1L, 0xFFFFFFFFL) > 0) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.end = end;
    }

    public long address() {
        return this.start;
    }

    public final int size() {
        return (int)(this.end - this.start + 1L);
    }

    public boolean contains(long address) {
        return Long.compareUnsigned(address, this.start) >= 0 && Long.compareUnsigned(address, this.end) <= 0;
    }

    public boolean intersects(MemoryRange other) {
        return Long.compareUnsigned(this.start, other.end) <= 0 && Long.compareUnsigned(this.end, other.start) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryRange that = (MemoryRange)o;
        return this.start == that.start && this.end == that.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return String.format("[%x-%x]", this.start, this.end);
    }
}

