/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.flash;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import li.cil.sedna.api.device.MemoryMappedDevice;

public final class FlashMemoryDevice
implements MemoryMappedDevice {
    private final ByteBuffer data;
    private final boolean readonly;

    public FlashMemoryDevice(ByteBuffer data, boolean readonly) {
        this.data = data;
        this.readonly = readonly;
    }

    public FlashMemoryDevice(ByteBuffer data) {
        this(data, true);
    }

    public FlashMemoryDevice(int size) {
        this(ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN));
    }

    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public boolean supportsFetch() {
        return true;
    }

    @Override
    public int getLength() {
        return this.data.capacity();
    }

    @Override
    public long load(int offset, int sizeLog2) {
        if (offset < 0 || offset > this.data.limit() - (1 << sizeLog2)) {
            return 0L;
        }
        switch (sizeLog2) {
            case 0: {
                return this.data.get(offset);
            }
            case 1: {
                return this.data.getShort(offset);
            }
            case 2: {
                return this.data.getInt(offset);
            }
            case 3: {
                return this.data.getLong(offset);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void store(int offset, long value, int sizeLog2) {
        if (this.readonly) {
            return;
        }
        if (offset < 0 || offset > this.data.limit() - (1 << sizeLog2)) {
            return;
        }
        switch (sizeLog2) {
            case 0: {
                this.data.put(offset, (byte)value);
                break;
            }
            case 1: {
                this.data.putShort(offset, (short)value);
                break;
            }
            case 2: {
                this.data.putInt(offset, (int)value);
                break;
            }
            case 3: {
                this.data.putLong(offset, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

