/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.rtc;

import java.util.Collections;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.Interrupt;
import li.cil.sedna.api.device.InterruptSource;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.rtc.RealTimeCounter;

public final class GoldfishRTC
implements InterruptSource,
MemoryMappedDevice {
    private static final int TIME_LOW = 0;
    private static final int TIME_HIGH = 4;
    private static final int ALARM_LOW = 8;
    private static final int ALARM_HIGH = 12;
    private static final int CLEAR_INTERRUPT = 16;
    private final RealTimeCounter rtc;
    private final Interrupt interrupt = new Interrupt();
    @Serialized
    private long time;

    public GoldfishRTC(RealTimeCounter rtc) {
        this.rtc = rtc;
    }

    public Interrupt getInterrupt() {
        return this.interrupt;
    }

    @Override
    public Iterable<Interrupt> getInterrupts() {
        return Collections.singleton(this.interrupt);
    }

    @Override
    public int getLength() {
        return 32;
    }

    @Override
    public int getSupportedSizes() {
        return 12;
    }

    @Override
    public long load(int offset, int sizeLog2) {
        switch (offset) {
            case 0: {
                this.time = this.rtc.getTime() / (long)this.rtc.getFrequency() * 1000000000L;
                return this.time;
            }
            case 4: {
                return (int)(this.time >>> 32);
            }
        }
        return 0L;
    }

    @Override
    public void store(int offset, long value, int sizeLog2) {
    }
}

