/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.virtio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.virtio.AbstractVirtIODevice;
import li.cil.sedna.device.virtio.DescriptorChain;
import li.cil.sedna.device.virtio.VirtIODeviceException;
import li.cil.sedna.device.virtio.VirtIODeviceSpec;
import li.cil.sedna.device.virtio.VirtqueueIterator;

public abstract class AbstractVirtIOInputDevice
extends AbstractVirtIODevice {
    protected static final int VIRTIO_INPUT_CFG_SELECT_UNSET = 0;
    protected static final int VIRTIO_INPUT_CFG_SELECT_ID_NAME = 1;
    protected static final int VIRTIO_INPUT_CFG_SELECT_ID_SERIAL = 2;
    protected static final int VIRTIO_INPUT_CFG_SELECT_ID_DEVIDS = 3;
    protected static final int VIRTIO_INPUT_CFG_SELECT_PROP_BITS = 16;
    protected static final int VIRTIO_INPUT_CFG_SELECT_EV_BITS = 17;
    protected static final int VIRTIO_INPUT_CFG_SELECT_ABS_INFO = 18;
    private static final int VIRTIO_INPUT_CFG_SELECT_OFFSET = 0;
    private static final int VIRTIO_INPUT_CFG_SUBSEL_OFFSET = 1;
    private static final int VIRTIO_INPUT_CFG_SIZE_OFFSET = 2;
    private static final int VIRTIO_INPUT_CFG_UNION_OFFSET = 8;
    private static final int VIRTIO_INPUT_CFG_UNION_SIZE = 128;
    private static final int VIRTQ_EVENT = 0;
    private static final int VIRTQ_STATUS = 1;
    private static final ThreadLocal<ByteBuffer> eventBuffer = new ThreadLocal();
    private DescriptorChain event;

    protected AbstractVirtIOInputDevice(MemoryMap memoryMap) {
        super(memoryMap, VirtIODeviceSpec.builder(18).configSpaceSize(256).queueCount(2).build());
    }

    protected int generateConfigUnion(int select, int subsel, ByteBuffer config) {
        return 0;
    }

    protected void handleStatus(int type, int code, int value) {
    }

    protected final void putEvent(int type, int code, int value) {
        if ((this.getStatus() & 0x80) != 0) {
            return;
        }
        try {
            this.event = this.validateWriteOnlyDescriptorChain(0, this.event);
            if (this.event != null) {
                if (this.event.writableBytes() < 8) {
                    this.error();
                    return;
                }
                ByteBuffer buffer = AbstractVirtIOInputDevice.getTempBuffer();
                buffer.putShort((short)type);
                buffer.putShort((short)code);
                buffer.putInt(value);
                buffer.flip();
                this.event.put(buffer);
                this.event.use();
            }
        }
        catch (MemoryAccessException | VirtIODeviceException e) {
            this.error();
        }
    }

    protected final void putSyn() {
        this.putEvent(0, 0, 0);
    }

    @Override
    protected final void storeConfig(int offset, long value, int sizeLog2) {
        if (offset > 1) {
            return;
        }
        super.storeConfig(offset, value, sizeLog2);
        this.generateConfig();
    }

    @Override
    protected final void handleFeaturesNegotiated() {
        this.setQueueNotifications(0, false);
    }

    @Override
    protected final void handleQueueNotification(int queueIndex) throws VirtIODeviceException, MemoryAccessException {
        VirtqueueIterator queue;
        if (queueIndex == 1 && (queue = this.getQueueIterator(queueIndex)) != null && queue.hasNext()) {
            while (queue.hasNext()) {
                DescriptorChain chain = queue.next();
                while (chain.readableBytes() >= 8) {
                    ByteBuffer buffer = AbstractVirtIOInputDevice.getTempBuffer();
                    chain.get(buffer);
                    buffer.flip();
                    short type = buffer.getShort();
                    short code = buffer.getShort();
                    int value = buffer.getInt();
                    this.handleStatus(type, code, value);
                }
                chain.use();
            }
        }
    }

    private void generateConfig() {
        ByteBuffer config = this.getConfiguration();
        int select = config.get(0) & 0xFF;
        int subsel = config.get(1) & 0xFF;
        if (select == 0) {
            config.put(2, (byte)0);
        } else {
            config.limit(136);
            config.position(8);
            ByteBuffer union = config.slice();
            config.clear();
            int size = this.generateConfigUnion(select, subsel, union);
            config.put(2, (byte)size);
        }
    }

    private static ByteBuffer getTempBuffer() {
        ByteBuffer buffer = eventBuffer.get();
        if (buffer == null) {
            buffer = ByteBuffer.allocate(8);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            eventBuffer.set(buffer);
        }
        buffer.clear();
        return buffer;
    }
}

