/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.device.virtio;

import java.nio.ByteBuffer;
import java.util.BitSet;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.device.virtio.AbstractVirtIOInputDevice;
import li.cil.sedna.evdev.EvdevKeys;

public final class VirtIOKeyboardDevice
extends AbstractVirtIOInputDevice {
    private static final String NAME = "virtio_keyboard";

    public VirtIOKeyboardDevice(MemoryMap memoryMap) {
        super(memoryMap);
    }

    public void sendKeyEvent(int keycode, boolean isDown) {
        this.putEvent(1, keycode, isDown ? 1 : 0);
        this.putSyn();
    }

    @Override
    protected int generateConfigUnion(int select, int subsel, ByteBuffer config) {
        block0 : switch (select) {
            case 1: {
                char[] chars;
                for (char ch : chars = NAME.toCharArray()) {
                    config.put((byte)ch);
                }
                break;
            }
            case 17: {
                switch (subsel) {
                    case 1: {
                        BitSet bitmap = new BitSet();
                        for (int keycode : EvdevKeys.ALL_KEYS) {
                            bitmap.set(keycode);
                        }
                        byte[] maskBytes = bitmap.toByteArray();
                        config.put(maskBytes);
                        break block0;
                    }
                    case 20: {
                        config.put((byte)0);
                    }
                }
            }
        }
        return config.position();
    }
}

