/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.devicetree.provider;

import java.util.Optional;
import li.cil.sedna.api.device.Device;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.devicetree.DeviceTree;
import li.cil.sedna.api.devicetree.DeviceTreeProvider;
import li.cil.sedna.api.memory.MappedMemoryRange;
import li.cil.sedna.api.memory.MemoryMap;

public final class SystemControllerProvider
implements DeviceTreeProvider {
    @Override
    public Optional<String> getName(Device device) {
        return Optional.of("syscon");
    }

    @Override
    public Optional<DeviceTree> createNode(DeviceTree root, MemoryMap memoryMap, Device device, String deviceName) {
        Optional<MappedMemoryRange> range = memoryMap.getMemoryRange((MemoryMappedDevice)device);
        return range.map(r -> root.find("/soc").getChild(deviceName, r.address()));
    }

    @Override
    public void visit(DeviceTree node, MemoryMap memoryMap, Device device) {
        int handle = node.getPHandle(device);
        node.addProp("compatible", "syscon").addProp("phandle", handle);
        DeviceTree soc = node.find("/soc");
        soc.putChild("reboot", reboot -> reboot.addProp("compatible", "syscon-reboot").addProp("regmap", handle).addProp("offset", 0).addProp("value", 4096));
        soc.putChild("poweroff", poweroff -> poweroff.addProp("compatible", "syscon-poweroff").addProp("regmap", handle).addProp("offset", 0).addProp("value", 8192));
    }
}

