/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.elf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import li.cil.sedna.elf.ELF;
import li.cil.sedna.elf.Endianness;
import li.cil.sedna.elf.Format;
import li.cil.sedna.elf.ProgramHeader;
import li.cil.sedna.elf.SectionHeader;
import li.cil.sedna.elf.SectionHeaderType;
import org.apache.commons.io.IOUtils;

public final class ELFParser {
    private static final byte[] EI_MAG = new byte[]{127, 69, 76, 70};

    public static ELF parse(String path) throws IOException {
        return ELFParser.parse(new File(path));
    }

    public static ELF parse(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            ELF eLF = ELFParser.parse(new BufferedInputStream(fis));
            return eLF;
        }
    }

    public static ELF parse(InputStream stream) throws IOException {
        return ELFParser.parse(IOUtils.toByteArray((InputStream)stream));
    }

    public static ELF parse(byte[] data) {
        ELF elf = new ELF();
        elf.data = ByteBuffer.wrap(data);
        ELFParser.readHeader(elf);
        ELFParser.readTables(elf);
        SectionHeader nameSection = elf.sectionHeaderTable.get(elf.sectionNameEntryIndex);
        if (!nameSection.is(SectionHeaderType.SHT_STRTAB)) {
            throw new IllegalArgumentException("name section is not of type SHT_STRTAB");
        }
        long nameListBase = nameSection.offset;
        for (SectionHeader sectionHeader : elf.sectionHeaderTable) {
            char ch;
            long nameStart = nameListBase + (long)sectionHeader.nameOffset;
            elf.data.position((int)nameStart);
            StringBuilder sb = new StringBuilder();
            while ((ch = (char)elf.data.get()) != '\u0000') {
                sb.append(ch);
            }
            sectionHeader.name = sb.toString();
        }
        return elf;
    }

    private static byte read(ELF elf) {
        return elf.data.get();
    }

    private static int readi(ELF elf) {
        return ELFParser.read(elf) & 0xFF;
    }

    private static short read16(ELF elf) {
        switch (elf.endianness) {
            case LITTLE_ENDIAN: {
                return (short)(ELFParser.readi(elf) | ELFParser.readi(elf) << 8);
            }
            case BIG_ENDIAN: {
                return (short)(ELFParser.readi(elf) << 8 | ELFParser.readi(elf));
            }
        }
        throw new IllegalArgumentException();
    }

    private static int read16i(ELF elf) {
        return ELFParser.read16(elf) & 0xFFFF;
    }

    private static int read32(ELF elf) {
        switch (elf.endianness) {
            case LITTLE_ENDIAN: {
                return ELFParser.read16i(elf) | ELFParser.read16i(elf) << 16;
            }
            case BIG_ENDIAN: {
                return ELFParser.read16i(elf) << 16 | ELFParser.read16i(elf);
            }
        }
        throw new IllegalArgumentException();
    }

    private static long read32l(ELF elf) {
        return (long)ELFParser.read32(elf) & 0xFFFFFFFFL;
    }

    private static long read64(ELF elf) {
        switch (elf.endianness) {
            case LITTLE_ENDIAN: {
                return ELFParser.read32l(elf) | ELFParser.read32l(elf) << 32;
            }
            case BIG_ENDIAN: {
                return ELFParser.read32l(elf) << 32 | ELFParser.read32l(elf);
            }
        }
        throw new IllegalArgumentException();
    }

    private static long readWord(ELF elf) {
        switch (elf.format) {
            case x32: {
                return ELFParser.read32l(elf);
            }
            case x64: {
                return ELFParser.read64(elf);
            }
        }
        throw new IllegalArgumentException();
    }

    private static void skip(ELF elf, long count) {
        int i = 0;
        while ((long)i < count) {
            ELFParser.read(elf);
            ++i;
        }
    }

    private static void readHeader(ELF elf) {
        int minHeaderSize;
        for (int i = 0; i < EI_MAG.length; ++i) {
            if (ELFParser.read(elf) == EI_MAG[i]) continue;
            throw new IllegalArgumentException("invalid ELF header");
        }
        switch (ELFParser.read(elf)) {
            case 1: {
                elf.format = Format.x32;
                break;
            }
            case 2: {
                elf.format = Format.x64;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid bit format");
            }
        }
        switch (ELFParser.read(elf)) {
            case 1: {
                elf.endianness = Endianness.LITTLE_ENDIAN;
                break;
            }
            case 2: {
                elf.endianness = Endianness.BIG_ENDIAN;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid endianness");
            }
        }
        byte headerVersion = ELFParser.read(elf);
        if (headerVersion != 1) {
            throw new IllegalArgumentException("invalid ELF header version");
        }
        elf.abi = ELFParser.readi(elf);
        elf.abiVersion = ELFParser.readi(elf);
        ELFParser.skip(elf, 7L);
        elf.type = ELFParser.read16i(elf);
        elf.isa = ELFParser.read16i(elf);
        elf.version = ELFParser.read32(elf);
        if (elf.version != 1) {
            throw new IllegalArgumentException("invalid ELF version");
        }
        elf.entryPoint = ELFParser.readWord(elf);
        elf.programHeaderTableOffset = ELFParser.readWord(elf);
        elf.sectionHeaderTableOffset = ELFParser.readWord(elf);
        elf.flags = ELFParser.read32(elf);
        elf.headerSize = ELFParser.read16i(elf);
        switch (elf.format) {
            case x32: {
                minHeaderSize = 52;
                break;
            }
            case x64: {
                minHeaderSize = 64;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (elf.headerSize < minHeaderSize) {
            throw new IllegalArgumentException("invalid header size");
        }
        if (elf.programHeaderTableOffset < (long)elf.headerSize) {
            throw new IllegalArgumentException("program header table intersects header");
        }
        if (elf.sectionHeaderTableOffset < (long)elf.headerSize) {
            throw new IllegalArgumentException("section header table intersects header");
        }
        if (elf.programHeaderTableOffset == elf.sectionHeaderTableOffset) {
            throw new IllegalArgumentException("program header table and section header table start at same offset");
        }
        elf.programHeaderTableEntrySize = ELFParser.read16i(elf);
        elf.programHeaderTableEntryCount = ELFParser.read16i(elf);
        elf.sectionHeaderTableEntrySize = ELFParser.read16i(elf);
        elf.sectionHeaderTableEntryCount = ELFParser.read16i(elf);
        if (elf.programHeaderTableOffset < elf.sectionHeaderTableOffset && elf.programHeaderTableOffset + (long)(elf.programHeaderTableEntrySize * elf.programHeaderTableEntryCount) > elf.sectionHeaderTableOffset) {
            throw new IllegalArgumentException("program header table intersects section header table");
        }
        if (elf.sectionHeaderTableOffset < elf.programHeaderTableOffset && elf.sectionHeaderTableOffset + (long)(elf.sectionHeaderTableEntrySize * elf.sectionHeaderTableEntryCount) > elf.programHeaderTableOffset) {
            throw new IllegalArgumentException("section header table intersects program header table");
        }
        elf.sectionNameEntryIndex = ELFParser.read16i(elf);
        if (elf.sectionNameEntryIndex >= elf.sectionHeaderTableEntryCount) {
            throw new IllegalArgumentException("invalid section name entry index");
        }
        ELFParser.skip(elf, elf.headerSize - minHeaderSize);
    }

    private static void readTables(ELF elf) {
        elf.programHeaderTable = ELFParser.readProgramHeaderTable(elf);
        elf.sectionHeaderTable = ELFParser.readSectionHeaderTable(elf);
    }

    private static List<ProgramHeader> readProgramHeaderTable(ELF elf) {
        int minEntrySize;
        elf.data.position((int)elf.programHeaderTableOffset);
        switch (elf.format) {
            case x32: {
                minEntrySize = 32;
                break;
            }
            case x64: {
                minEntrySize = 56;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (elf.programHeaderTableEntrySize < minEntrySize) {
            throw new IllegalArgumentException("invalid program header size");
        }
        ArrayList<ProgramHeader> result = new ArrayList<ProgramHeader>();
        for (int i = 0; i < elf.programHeaderTableEntryCount; ++i) {
            ProgramHeader header = new ProgramHeader(elf);
            header.type = ELFParser.read32(elf);
            if (elf.format == Format.x64) {
                header.flags = ELFParser.read32(elf);
            }
            header.offset = ELFParser.readWord(elf);
            header.virtualAddress = ELFParser.readWord(elf);
            header.physicalAddress = ELFParser.readWord(elf);
            header.sizeInFile = ELFParser.readWord(elf);
            header.sizeInMemory = ELFParser.readWord(elf);
            if (elf.format == Format.x32) {
                header.flags = ELFParser.read32(elf);
            }
            header.alignment = ELFParser.readWord(elf);
            if (Long.compareUnsigned(header.alignment, 1L) > 0) {
                if (Long.bitCount(header.alignment) != 1) {
                    throw new IllegalArgumentException("invalid alignment of program: not a power of two");
                }
                if ((header.virtualAddress & header.alignment - 1L) != (header.offset & header.alignment - 1L)) {
                    throw new IllegalArgumentException("invalid alignment of program: p_vaddr and p_offset misaligned");
                }
            }
            ELFParser.skip(elf, elf.programHeaderTableEntrySize - minEntrySize);
            result.add(header);
        }
        return result;
    }

    private static List<SectionHeader> readSectionHeaderTable(ELF elf) {
        int minEntrySize;
        elf.data.position((int)elf.sectionHeaderTableOffset);
        switch (elf.format) {
            case x32: {
                minEntrySize = 40;
                break;
            }
            case x64: {
                minEntrySize = 64;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (elf.sectionHeaderTableEntrySize < minEntrySize) {
            throw new IllegalArgumentException("invalid section header size");
        }
        ArrayList<SectionHeader> result = new ArrayList<SectionHeader>();
        for (int i = 0; i < elf.sectionHeaderTableEntryCount; ++i) {
            SectionHeader header = new SectionHeader(elf);
            header.nameOffset = ELFParser.read32(elf);
            header.type = ELFParser.read32(elf);
            header.flags = ELFParser.readWord(elf);
            header.virtualAddress = ELFParser.readWord(elf);
            header.offset = ELFParser.readWord(elf);
            header.size = ELFParser.readWord(elf);
            header.link = ELFParser.read32(elf);
            header.info = ELFParser.read32(elf);
            header.alignment = ELFParser.readWord(elf);
            if (Long.compareUnsigned(header.alignment, 1L) > 0 && Long.bitCount(header.alignment) != 1) {
                throw new IllegalArgumentException("invalid alignment of section: not a power of two");
            }
            header.entrySize = ELFParser.readWord(elf);
            ELFParser.skip(elf, elf.sectionHeaderTableEntrySize - minEntrySize);
            result.add(header);
        }
        return result;
    }
}

