/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.elf;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import li.cil.sedna.elf.ELF;
import li.cil.sedna.elf.ProgramHeaderType;

public final class ProgramHeader {
    public final ELF elf;
    public int type;
    public int flags;
    public long offset;
    public long sizeInFile;
    public long virtualAddress;
    public long physicalAddress;
    public long sizeInMemory;
    public long alignment;

    public ProgramHeader(ELF elf) {
        this.elf = elf;
    }

    public ByteBuffer getView() {
        int position = this.elf.data.position();
        int limit = this.elf.data.limit();
        this.elf.data.limit((int)(this.offset + this.sizeInFile));
        this.elf.data.position((int)this.offset);
        ByteBuffer result = this.elf.data.slice();
        this.elf.data.limit(limit);
        this.elf.data.position(position);
        return result;
    }

    public boolean is(ProgramHeaderType type) {
        return this.type == type.value;
    }

    @Nullable
    public ProgramHeaderType getType() {
        for (ProgramHeaderType type : ProgramHeaderType.values()) {
            if (!this.is(type)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        ProgramHeaderType type = this.getType();
        return "ProgramHeader{type = " + (type != null ? type : "0x" + Integer.toHexString(this.type)) + (type != ProgramHeaderType.PT_NULL ? ", offset=0x" + Long.toHexString(this.offset) + ", virtualAddress=0x" + Long.toHexString(this.virtualAddress) + ", physicalAddress=0x" + Long.toHexString(this.physicalAddress) + ", sizeInFile=0x" + Long.toHexString(this.sizeInFile) + ", sizeInMemory=0x" + Long.toHexString(this.sizeInMemory) + (this.alignment > 1L ? ", alignment=0x" + Long.toHexString(this.alignment) : "") : "") + '}';
    }
}

