/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.elf;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import li.cil.sedna.elf.ELF;
import li.cil.sedna.elf.SectionHeaderFlags;
import li.cil.sedna.elf.SectionHeaderType;

public final class SectionHeader {
    public final ELF elf;
    public String name;
    public int nameOffset;
    public int type;
    public long flags;
    public long offset;
    public long size;
    public long virtualAddress;
    public long alignment;
    public int link;
    public int info;
    public long entrySize;

    SectionHeader(ELF elf) {
        this.elf = elf;
    }

    public ByteBuffer getView() {
        int position = this.elf.data.position();
        int limit = this.elf.data.limit();
        this.elf.data.limit((int)(this.offset + this.size));
        this.elf.data.position((int)this.offset);
        ByteBuffer result = this.elf.data.slice();
        this.elf.data.limit(limit);
        this.elf.data.position(position);
        return result;
    }

    public boolean is(SectionHeaderType type) {
        return this.type == type.value;
    }

    @Nullable
    public SectionHeaderType getType() {
        for (SectionHeaderType type : SectionHeaderType.values()) {
            if (!this.is(type)) continue;
            return type;
        }
        return null;
    }

    public boolean has(SectionHeaderFlags flag) {
        return (this.flags & (long)flag.value) != 0L;
    }

    public Collection<SectionHeaderFlags> getFlags() {
        ArrayList<SectionHeaderFlags> result = new ArrayList<SectionHeaderFlags>();
        for (SectionHeaderFlags flag : SectionHeaderFlags.values()) {
            if (!this.has(flag)) continue;
            result.add(flag);
        }
        return result;
    }

    public String toString() {
        SectionHeaderType type = this.getType();
        Collection<SectionHeaderFlags> flags = this.getFlags();
        return "SectionHeader{name=" + (this.name != null ? this.name : Integer.valueOf(this.nameOffset)) + ", type=" + (type != null ? type : "0x" + Integer.toHexString(this.type)) + (type != SectionHeaderType.SHT_NULL ? (!flags.isEmpty() ? ", flags =" + flags.stream().map(Enum::toString).collect(Collectors.joining(" | ")) : "") + ", virtualAddress=0x" + Long.toHexString(this.virtualAddress) + ", offset=0x" + Long.toHexString(this.offset) + ", size=0x" + Long.toHexString(this.size) + (this.link > 0 ? ", link=" + this.link : "") + (this.info > 0 ? ", info=" + this.info : "") + (this.alignment > 1L ? ", alignment=0x" + Long.toHexString(this.alignment) : "") + (this.entrySize > 0L ? ", entrySize=0x" + Long.toHexString(this.entrySize) : "") : "") + '}';
    }
}

