/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import li.cil.sedna.fs.DirectoryEntry;
import li.cil.sedna.fs.FileHandle;
import li.cil.sedna.fs.FileSystem;
import li.cil.sedna.fs.FileSystemStats;
import li.cil.sedna.fs.Path;

public final class HostFileSystem
implements FileSystem {
    private final File root;

    public HostFileSystem() {
        this(new File("."));
    }

    public HostFileSystem(File root) {
        this.root = root.getAbsoluteFile();
    }

    @Override
    public FileSystemStats statfs() {
        FileSystemStats result = new FileSystemStats();
        result.blockCount = this.root.getTotalSpace() / (long)result.blockSize + 1L;
        result.freeBlockCount = this.root.getFreeSpace() / (long)result.blockSize;
        result.availableBlockCount = this.root.getUsableSpace() / (long)result.blockSize;
        return result;
    }

    @Override
    public long getUniqueId(Path path) {
        return this.toHost(path).hashCode();
    }

    @Override
    public boolean exists(Path path) {
        return Files.exists(this.toHost(path), new LinkOption[0]);
    }

    @Override
    public boolean isDirectory(Path path) {
        return Files.isDirectory(this.toHost(path), new LinkOption[0]);
    }

    @Override
    public boolean isWritable(Path path) {
        return Files.isWritable(this.toHost(path));
    }

    @Override
    public boolean isReadable(Path path) {
        return Files.isReadable(this.toHost(path));
    }

    @Override
    public boolean isExecutable(Path path) {
        return Files.isExecutable(this.toHost(path));
    }

    @Override
    public BasicFileAttributes getAttributes(Path path) throws IOException {
        return Files.readAttributes(this.toHost(path), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Override
    public void mkdir(Path path) throws IOException {
        Files.createDirectory(this.toHost(path), new FileAttribute[0]);
    }

    @Override
    public FileHandle open(Path path, int flags) throws IOException {
        String mode;
        if ((flags & 2) != 0) {
            mode = "rw";
        } else if ((flags & 1) != 0) {
            mode = "r";
        } else {
            throw new IOException();
        }
        java.nio.file.Path hostPath = this.toHost(path);
        if (Files.isDirectory(hostPath, new LinkOption[0])) {
            final List entries = Files.list(hostPath).map(java.nio.file.Path::toFile).map(DirectoryEntry::create).collect(Collectors.toList());
            return new FileHandle(){

                @Override
                public int read(long offset, ByteBuffer buffer) throws IOException {
                    throw new IOException();
                }

                @Override
                public int write(long offset, ByteBuffer buffer) throws IOException {
                    throw new IOException();
                }

                @Override
                public List<DirectoryEntry> readdir() {
                    return entries;
                }

                @Override
                public void close() {
                }
            };
        }
        final RandomAccessFile openedFile = new RandomAccessFile(hostPath.toFile(), mode);
        if ((flags & 4) != 0) {
            openedFile.setLength(0L);
        }
        return new FileHandle(){

            @Override
            public int read(long offset, ByteBuffer buffer) throws IOException {
                openedFile.seek(offset);
                return openedFile.getChannel().read(buffer, offset);
            }

            @Override
            public int write(long offset, ByteBuffer buffer) throws IOException {
                openedFile.seek(offset);
                return openedFile.getChannel().write(buffer, offset);
            }

            @Override
            public List<DirectoryEntry> readdir() throws IOException {
                throw new IOException();
            }

            @Override
            public void close() throws IOException {
                openedFile.close();
            }
        };
    }

    @Override
    public FileHandle create(Path path, int flags) throws IOException {
        Files.createFile(this.toHost(path), new FileAttribute[0]);
        return this.open(path, flags);
    }

    @Override
    public void unlink(Path path) throws IOException {
        Files.delete(this.toHost(path));
    }

    @Override
    public void rename(Path oldPath, Path newPath) throws IOException {
        Files.move(this.toHost(oldPath), this.toHost(newPath), new CopyOption[0]);
    }

    private java.nio.file.Path toHost(Path path) {
        java.nio.file.Path result = this.root.toPath();
        for (String part : path.getParts()) {
            result = result.resolve(part);
        }
        return result;
    }
}

