/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import li.cil.sedna.instruction.FieldPostprocessor;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.InstructionFieldMapping;
import li.cil.sedna.instruction.InstructionType;
import li.cil.sedna.instruction.argument.ConstantInstructionArgument;
import li.cil.sedna.instruction.argument.FieldInstructionArgument;
import li.cil.sedna.instruction.argument.InstructionArgument;

public final class InstructionDeclarationLoader {
    private static final String FIELD_KEYWORD = "field";

    public static ArrayList<InstructionDeclaration> load(InputStream stream) throws IOException {
        ParserContext context = new ParserContext();
        InstructionDeclarationLoader.parseFile(new BufferedReader(new InputStreamReader(stream)), context);
        InstructionDeclarationLoader.validateDeclarations(context.instructions);
        return context.instructions;
    }

    private static void validateDeclarations(ArrayList<InstructionDeclaration> declarations) {
        for (int i = 0; i < declarations.size(); ++i) {
            InstructionDeclaration i1 = declarations.get(i);
            for (int j = i + 1; j < declarations.size(); ++j) {
                InstructionDeclaration i2 = declarations.get(j);
                int intersectMask = i1.patternMask & i2.patternMask;
                if (intersectMask == 0) {
                    throw new IllegalStateException(String.format("Instruction declarations [%s] (line %d) and [%s] (line %d) have distinct pattern masks, making them ambiguous.", i1.displayName, i1.lineNumber, i2.displayName, i2.lineNumber));
                }
                if ((i1.patternMask & intersectMask) != i1.patternMask || (i2.patternMask & intersectMask) != i2.patternMask || (i1.pattern & intersectMask) != (i2.pattern & intersectMask)) continue;
                throw new IllegalStateException(String.format("Instruction declarations [%s] (line %d) and [%s] (line %d) have ambiguous patterns.", i1.displayName, i1.lineNumber, i2.displayName, i2.lineNumber));
            }
        }
    }

    private static void parseFile(BufferedReader reader, ParserContext context) throws IOException {
        while ((context.line = reader.readLine()) != null) {
            try {
                InstructionDeclarationLoader.parseComments(context);
                InstructionDeclarationLoader.parseTokens(context);
                InstructionDeclarationLoader.parseLine(context);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(String.format("Failed parsing line [%d].", context.lineNumber), e);
            }
            ++context.lineNumber;
        }
    }

    private static void parseComments(ParserContext context) {
        context.line = context.line.split("#", 2)[0].trim();
    }

    private static void parseTokens(ParserContext context) {
        context.tokens.clear();
        if (!context.line.isEmpty()) {
            context.tokens.addAll(Arrays.asList(context.line.split("\\s+")));
        }
    }

    private static void parseLine(ParserContext context) {
        if (context.tokens.isEmpty()) {
            return;
        }
        String keyword = context.tokens.remove(0);
        if (FIELD_KEYWORD.equals(keyword)) {
            Field field = InstructionDeclarationLoader.parseField(context);
            context.fields.put(field.name, field);
        } else if (InstructionType.BY_KEYWORD.containsKey(keyword)) {
            InstructionType type = InstructionType.BY_KEYWORD.get(keyword);
            InstructionDeclaration declaration = InstructionDeclarationLoader.parseInstruction(context, type);
            context.instructions.add(declaration);
        } else {
            throw new IllegalArgumentException(String.format("Invalid keyword [%s].", keyword));
        }
    }

    private static InstructionDeclaration parseInstruction(ParserContext context, InstructionType type) {
        boolean isCompressedInstruction;
        String name;
        switch (type) {
            case REGULAR: {
                name = context.tokens.remove(0);
                break;
            }
            case NOP: {
                name = "NOP";
                break;
            }
            case ILLEGAL: {
                name = "ILLEGAL";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String displayName = "|".equals(context.tokens.get(0)) ? name : context.tokens.remove(0);
        if (!"|".equals(context.tokens.get(0))) {
            throw new IllegalArgumentException(String.format("Unexpected token [%s].", context.tokens.get(0)));
        }
        context.tokens.remove(0);
        int pattern = 0;
        int patternMask = 0;
        int unusedBits = 0;
        int bitIndex = 31;
        while (!context.tokens.isEmpty() && !"|".equals(context.tokens.get(0))) {
            String token = context.tokens.remove(0);
            for (int j = 0; j < token.length(); ++j) {
                if (bitIndex < 0) {
                    throw new IllegalArgumentException("Instruction bit pattern too long (>32 bits).");
                }
                switch (token.charAt(j)) {
                    case '0': {
                        patternMask |= 1 << bitIndex;
                        break;
                    }
                    case '1': {
                        patternMask |= 1 << bitIndex;
                        pattern |= 1 << bitIndex;
                        break;
                    }
                    case '*': {
                        unusedBits |= 1 << bitIndex;
                        break;
                    }
                    case '.': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Unexpected character [%s] in instruction bit pattern.", Character.valueOf(token.charAt(j))));
                    }
                }
                --bitIndex;
            }
        }
        boolean bl = isCompressedInstruction = bitIndex == 15;
        if (isCompressedInstruction) {
            pattern >>>= 16;
            patternMask >>>= 16;
            unusedBits >>>= 16;
        }
        LinkedHashMap<String, InstructionArgument> arguments = new LinkedHashMap<String, InstructionArgument>();
        int argumentBits = 0;
        if (!context.tokens.isEmpty()) {
            if (!"|".equals(context.tokens.get(0))) {
                throw new IllegalArgumentException(String.format("Unexpected token [%s].", context.tokens.get(0)));
            }
            context.tokens.remove(0);
            while (!context.tokens.isEmpty()) {
                if (type == InstructionType.NOP || type == InstructionType.ILLEGAL) {
                    throw new IllegalArgumentException(String.format("Unexpected token [%s].", context.tokens.get(0)));
                }
                ParsedArgument argument = InstructionDeclarationLoader.parseArgument(context);
                argumentBits |= argument.bitmask;
                for (String argName : argument.names) {
                    arguments.put(argName, argument.value);
                }
            }
        }
        if ((argumentBits & patternMask) != 0) {
            throw new IllegalArgumentException("Argument bits intersect pattern bits.");
        }
        int usedBits = patternMask | unusedBits | argumentBits;
        if (isCompressedInstruction ? usedBits != 65535 : usedBits != -1) {
            throw new IllegalArgumentException("Not all instruction bits have a defined use.");
        }
        return new InstructionDeclaration(type, isCompressedInstruction ? 2 : 4, name, displayName, context.lineNumber, pattern, patternMask, unusedBits, arguments);
    }

    private static ParsedArgument parseArgument(ParserContext context) {
        Field field;
        String token = context.tokens.remove(0);
        String[] argsAndFieldNameOrConst = token.split("=");
        ParsedArgument result = new ParsedArgument();
        result.names = new String[Math.max(1, argsAndFieldNameOrConst.length - 1)];
        System.arraycopy(argsAndFieldNameOrConst, 0, result.names, 0, Math.max(1, argsAndFieldNameOrConst.length - 1));
        String fieldNameOrConst = argsAndFieldNameOrConst[argsAndFieldNameOrConst.length - 1];
        if (argsAndFieldNameOrConst.length > 1) {
            try {
                int constValue = Integer.parseInt(fieldNameOrConst);
                result.value = new ConstantInstructionArgument(constValue);
                return result;
            }
            catch (NumberFormatException constValue) {
                // empty catch block
            }
        }
        if ((field = context.fields.get(fieldNameOrConst)) == null) {
            throw new IllegalArgumentException(String.format("Reference to unknown field [%s].", fieldNameOrConst));
        }
        FieldInstructionArgument argument = new FieldInstructionArgument(field.mappings, field.postprocessor);
        boolean isNewArgument = true;
        for (FieldInstructionArgument existingArgument : context.distinctFieldArguments) {
            if (!existingArgument.equals(argument)) continue;
            argument = existingArgument;
            isNewArgument = false;
            break;
        }
        if (isNewArgument) {
            context.distinctFieldArguments.add(argument);
        }
        result.value = argument;
        int mappingsBits = 0;
        for (InstructionFieldMapping mapping : field.mappings) {
            mappingsBits |= (2 << mapping.srcMSB) - 1 & ~((1 << mapping.srcLSB) - 1);
        }
        result.bitmask = mappingsBits;
        return result;
    }

    private static Field parseField(ParserContext context) {
        FieldPostprocessor postprocessor;
        String name = context.tokens.remove(0);
        ArrayList<InstructionFieldMapping> mappings = new ArrayList<InstructionFieldMapping>(context.tokens.size());
        while (!context.tokens.isEmpty() && !"|".equals(context.tokens.get(0))) {
            InstructionFieldMapping mapping = InstructionDeclarationLoader.parseFieldMapping(context);
            boolean isNewMapping = true;
            for (InstructionFieldMapping existingMapping : context.distinctFieldMappings) {
                if (!existingMapping.equals(mapping)) continue;
                mapping = existingMapping;
                isNewMapping = false;
                break;
            }
            if (isNewMapping) {
                context.distinctFieldMappings.add(mapping);
            }
            mappings.add(mapping);
        }
        if (!context.tokens.isEmpty()) {
            if (!"|".equals(context.tokens.get(0))) {
                throw new IllegalArgumentException(String.format("Unexpected token [%s].", context.tokens.get(0)));
            }
            context.tokens.remove(0);
            String postprocessorName = context.tokens.remove(0).toUpperCase(Locale.ENGLISH);
            postprocessor = FieldPostprocessor.valueOf(postprocessorName);
            if (!context.tokens.isEmpty()) {
                throw new IllegalArgumentException(String.format("Unexpected token [%s].", context.tokens.get(0)));
            }
        } else {
            postprocessor = FieldPostprocessor.NONE;
        }
        return new Field(name, mappings, postprocessor);
    }

    private static InstructionFieldMapping parseFieldMapping(ParserContext context) {
        int srcLSB;
        boolean signExtend;
        int srcMSB;
        int dstLSB;
        String spec = context.tokens.remove(0);
        String[] srcRangeAndDstLSB = spec.split("@", 2);
        try {
            dstLSB = srcRangeAndDstLSB.length > 1 ? Integer.parseInt(srcRangeAndDstLSB[1]) : 0;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Failed parsing destination least significant bit in field spec [%s].", spec));
        }
        String[] srcMSBAndLSB = srcRangeAndDstLSB[0].split(":", 2);
        if (srcMSBAndLSB[0].charAt(0) == 's') {
            try {
                srcMSB = Integer.parseInt(srcMSBAndLSB[0].substring(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Failed parsing source most significant bit in field spec [%s].", spec));
            }
            signExtend = true;
        } else {
            try {
                srcMSB = Integer.parseInt(srcMSBAndLSB[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Failed parsing source most significant bit in field spec [%s].", spec));
            }
            signExtend = false;
        }
        if (srcMSBAndLSB.length > 1) {
            try {
                srcLSB = Integer.parseInt(srcMSBAndLSB[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Failed parsing source least significant bit in field spec [%s].", spec));
            }
        } else {
            srcLSB = srcMSB;
        }
        return new InstructionFieldMapping(srcMSB, srcLSB, dstLSB, signExtend);
    }

    private static final class ParserContext {
        public int lineNumber = 1;
        public String line;
        public ArrayList<String> tokens = new ArrayList();
        public final ArrayList<InstructionFieldMapping> distinctFieldMappings = new ArrayList();
        public final ArrayList<FieldInstructionArgument> distinctFieldArguments = new ArrayList();
        public final HashMap<String, Field> fields = new HashMap();
        public final ArrayList<InstructionDeclaration> instructions = new ArrayList();

        private ParserContext() {
        }
    }

    private static final class Field {
        public final String name;
        public final ArrayList<InstructionFieldMapping> mappings;
        private final FieldPostprocessor postprocessor;

        private Field(String name, ArrayList<InstructionFieldMapping> mappings, FieldPostprocessor postprocessor) {
            this.name = name;
            this.mappings = mappings;
            this.postprocessor = postprocessor;
        }
    }

    private static final class ParsedArgument {
        public String[] names;
        public InstructionArgument value;
        public int bitmask;

        private ParsedArgument() {
        }
    }
}

