/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction.decoder.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Stream;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.argument.FieldInstructionArgument;
import li.cil.sedna.instruction.decoder.DecoderTreeNodeArguments;
import li.cil.sedna.instruction.decoder.tree.AbstractDecoderTreeNode;

public abstract class AbstractDecoderTreeInnerNode
extends AbstractDecoderTreeNode {
    public final AbstractDecoderTreeNode[] children;
    private final int maxDepth;
    private final int mask;
    private final int pattern;

    AbstractDecoderTreeInnerNode(AbstractDecoderTreeNode[] children) {
        this.children = children;
        int maxDepth = 0;
        for (AbstractDecoderTreeNode child : children) {
            maxDepth = Math.max(maxDepth, child.getMaxDepth());
        }
        this.maxDepth = 1 + maxDepth;
        int mask = children[0].getMask();
        for (int i = 1; i < children.length; ++i) {
            AbstractDecoderTreeNode child = children[i];
            mask &= child.getMask();
        }
        this.mask = mask;
        this.pattern = children[0].getPattern() & mask;
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public int getPattern() {
        return this.pattern;
    }

    @Override
    public DecoderTreeNodeArguments getArguments() {
        int totalLeafCount = 0;
        HashMap<FieldInstructionArgument, ArrayList> childEntries = new HashMap<FieldInstructionArgument, ArrayList>();
        for (AbstractDecoderTreeNode child : this.children) {
            DecoderTreeNodeArguments childArguments = child.getArguments();
            totalLeafCount += childArguments.totalLeafCount;
            childArguments.arguments.forEach((argument, entry) -> childEntries.computeIfAbsent((FieldInstructionArgument)argument, arg -> new ArrayList()).add(entry));
        }
        HashMap<FieldInstructionArgument, DecoderTreeNodeArguments.Entry> entries = new HashMap<FieldInstructionArgument, DecoderTreeNodeArguments.Entry>();
        childEntries.forEach((argument, childEntriesForArgument) -> {
            int count = 0;
            HashSet<String> names = new HashSet<String>();
            for (DecoderTreeNodeArguments.Entry entry : childEntriesForArgument) {
                count += entry.count;
                names.addAll(entry.names);
            }
            entries.put((FieldInstructionArgument)argument, new DecoderTreeNodeArguments.Entry(count, new ArrayList<String>(names)));
        });
        return new DecoderTreeNodeArguments(totalLeafCount, entries);
    }

    @Override
    public Stream<InstructionDeclaration> getInstructions() {
        return Arrays.stream(this.children).flatMap(AbstractDecoderTreeNode::getInstructions).distinct();
    }
}

