/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.instruction.decoder.tree;

import javax.annotation.Nullable;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.decoder.DecoderTreeSwitchVisitor;
import li.cil.sedna.instruction.decoder.DecoderTreeVisitor;
import li.cil.sedna.instruction.decoder.tree.AbstractDecoderTreeInnerNode;
import li.cil.sedna.instruction.decoder.tree.AbstractDecoderTreeNode;

public final class DecoderTreeSwitchNode
extends AbstractDecoderTreeInnerNode {
    public DecoderTreeSwitchNode(AbstractDecoderTreeNode[] children) {
        super(children);
    }

    @Override
    public void accept(DecoderTreeVisitor visitor) {
        DecoderTreeSwitchVisitor switchVisitor = visitor.visitSwitch(this);
        if (switchVisitor != null) {
            int i;
            int[] patterns = new int[this.children.length];
            for (i = 0; i < this.children.length; ++i) {
                patterns[i] = this.children[i].getPattern();
            }
            switchVisitor.visit(this.getMask(), patterns, this.getArguments());
            for (i = 0; i < this.children.length; ++i) {
                DecoderTreeVisitor switchCaseVisitor = switchVisitor.visitSwitchCase(i, this.children[i].getPattern() & this.getMask());
                if (switchCaseVisitor == null) continue;
                this.children[i].accept(switchCaseVisitor);
            }
            switchVisitor.visitEnd();
        }
        visitor.visitEnd();
    }

    @Override
    @Nullable
    public InstructionDeclaration query(int instruction) {
        for (AbstractDecoderTreeNode child : this.children) {
            if ((instruction & this.getMask()) != (child.getPattern() & this.getMask())) continue;
            return child.query(instruction);
        }
        return null;
    }

    public String toString() {
        return "[SWITCH]";
    }
}

