/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.memory;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import li.cil.sedna.api.device.PhysicalMemory;

public final class PhysicalMemoryInputStream
extends InputStream {
    private final PhysicalMemory memory;
    private int offset;

    public PhysicalMemoryInputStream(PhysicalMemory memory) {
        this.memory = memory;
    }

    @Override
    public int read() throws IOException {
        if (this.offset >= this.memory.getLength()) {
            return -1;
        }
        return (byte)this.memory.load(this.offset++, 0) & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int count = Math.min(len, this.memory.getLength() - this.offset);
        if (count <= 0) {
            return -1;
        }
        this.memory.load(this.offset, ByteBuffer.wrap(b, off, count));
        this.offset += count;
        return count;
    }
}

