/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.memory;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import li.cil.sedna.api.device.PhysicalMemory;

public final class PhysicalMemoryOutputStream
extends OutputStream {
    private final PhysicalMemory memory;
    private int offset;

    public PhysicalMemoryOutputStream(PhysicalMemory memory) {
        this.memory = memory;
    }

    @Override
    public void write(int b) throws IOException {
        this.memory.store(this.offset++, b, 0);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int count = Math.min(len, this.memory.getLength() - this.offset);
        if (count <= 0) {
            return;
        }
        this.memory.store(this.offset, ByteBuffer.wrap(b, off, count));
        this.offset += count;
    }
}

