/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import li.cil.sedna.api.device.rtc.RealTimeCounter;
import li.cil.sedna.api.memory.MemoryMap;
import li.cil.sedna.instruction.decoder.DecoderGenerator;
import li.cil.sedna.riscv.R5CPU;
import li.cil.sedna.riscv.R5CPUTemplate;
import li.cil.sedna.riscv.R5Instructions;
import li.cil.sedna.riscv.exception.R5IllegalInstructionException;
import org.apache.logging.log4j.core.util.Throwables;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public final class R5CPUGenerator {
    private static final String TEMPLATE_NAME = Type.getInternalName(R5CPUTemplate.class);
    private static final String GENERATED_NAME = TEMPLATE_NAME + "$Generated";
    private static final Class<R5CPU> GENERATED_CLASS = R5CPUGenerator.generateClass();
    private static final Constructor<R5CPU> GENERATED_CLASS_CTOR;

    public static Class<R5CPU> getGeneratedClass() {
        return GENERATED_CLASS;
    }

    public static R5CPU create(MemoryMap physicalMemory, @Nullable RealTimeCounter rtc) {
        try {
            return GENERATED_CLASS_CTOR.newInstance(physicalMemory, rtc);
        }
        catch (InvocationTargetException e) {
            Throwables.rethrow((Throwable)e.getCause());
            throw new AssertionError();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> generateClass() {
        try {
            ClassWriter writer = new ClassWriter(2){

                protected String getCommonSuperClass(String type1, String type2) {
                    String commonSuperClass;
                    if (type1.equals(GENERATED_NAME)) {
                        commonSuperClass = super.getCommonSuperClass(Type.getInternalName(R5CPUTemplate.class), type2);
                    } else if (type2.equals(GENERATED_NAME)) {
                        commonSuperClass = super.getCommonSuperClass(type1, Type.getInternalName(R5CPUTemplate.class));
                    } else {
                        return super.getCommonSuperClass(type1, type2);
                    }
                    if (commonSuperClass.equals(TEMPLATE_NAME)) {
                        return GENERATED_NAME;
                    }
                    return commonSuperClass;
                }

                protected ClassLoader getClassLoader() {
                    return R5CPUGenerator.class.getClassLoader();
                }
            };
            ClassRemapper remapper = new ClassRemapper((ClassVisitor)writer, new Remapper(){

                public String map(String internalName) {
                    if (internalName.equals(TEMPLATE_NAME)) {
                        return GENERATED_NAME;
                    }
                    return super.map(internalName);
                }
            });
            DecoderGenerator generator = new DecoderGenerator((ClassVisitor)remapper, R5Instructions.getDecoderTree(), R5Instructions::getDefinition, R5IllegalInstructionException.class, "interpretTrace", "decode");
            try (InputStream stream = R5CPUTemplate.class.getClassLoader().getResourceAsStream(R5CPUTemplate.class.getName().replace('.', '/') + ".class");){
                if (stream == null) {
                    throw new IOException("Could not load class file for class [" + R5CPUTemplate.class + "].");
                }
                ClassReader reader = new ClassReader(stream);
                reader.accept((ClassVisitor)generator, 8);
                byte[] bytes = writer.toByteArray();
                Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClass.setAccessible(true);
                Class clazz = (Class)defineClass.invoke((Object)R5CPUTemplate.class.getClassLoader(), null, bytes, 0, bytes.length);
                return clazz;
            }
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try {
            GENERATED_CLASS_CTOR = GENERATED_CLASS.getConstructor(MemoryMap.class, RealTimeCounter.class);
            GENERATED_CLASS_CTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

