/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import li.cil.sedna.instruction.InstructionDeclaration;
import li.cil.sedna.instruction.InstructionDeclarationLoader;
import li.cil.sedna.instruction.InstructionDefinition;
import li.cil.sedna.instruction.InstructionDefinitionLoader;
import li.cil.sedna.instruction.decoder.DecoderTree;
import li.cil.sedna.instruction.decoder.PrintStreamDecoderTreeVisitor;
import li.cil.sedna.instruction.decoder.tree.AbstractDecoderTreeNode;
import li.cil.sedna.riscv.R5CPUTemplate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class R5Instructions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String RISCV_INSTRUCTIONS_FILE = "/riscv/instructions.txt";
    private static final ArrayList<InstructionDeclaration> DECLARATIONS = new ArrayList();
    private static final HashMap<InstructionDeclaration, InstructionDefinition> DEFINITIONS = new HashMap();
    private static final AbstractDecoderTreeNode DECODER_TREE;

    public static ArrayList<InstructionDeclaration> getDeclarations() {
        return DECLARATIONS;
    }

    @Nullable
    public static InstructionDefinition getDefinition(InstructionDeclaration declaration) {
        return DEFINITIONS.get(declaration);
    }

    public static AbstractDecoderTreeNode getDecoderTree() {
        return DECODER_TREE;
    }

    public static void main(String[] args) {
        AbstractDecoderTreeNode tree = R5Instructions.getDecoderTree();
        tree.accept(new PrintStreamDecoderTreeVisitor(tree.getMaxDepth()));
    }

    static {
        try (InputStream stream = R5Instructions.class.getResourceAsStream(RISCV_INSTRUCTIONS_FILE);){
            if (stream == null) {
                throw new IOException("File not found.");
            }
            DECLARATIONS.addAll(InstructionDeclarationLoader.load(stream));
        }
        catch (Throwable e) {
            LOGGER.error("Failed loading RISC-V instruction declarations.", e);
        }
        try {
            DEFINITIONS.putAll(InstructionDefinitionLoader.load(R5CPUTemplate.class, DECLARATIONS));
        }
        catch (Throwable e) {
            LOGGER.error("Failed loading RISC-V instruction definitions.", e);
        }
        DECODER_TREE = DecoderTree.create(DECLARATIONS);
    }
}

