/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.riscv.device;

import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import li.cil.ceres.api.Serialized;
import li.cil.sedna.api.Interrupt;
import li.cil.sedna.api.device.InterruptController;
import li.cil.sedna.api.device.InterruptSource;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.Steppable;
import li.cil.sedna.api.device.rtc.RealTimeCounter;

public final class R5CoreLocalInterrupter
implements Steppable,
InterruptSource,
MemoryMappedDevice {
    private static final int CLINT_SIP_BASE = 0;
    private static final int CLINT_TIMECMP_BASE = 16384;
    private static final int CLINT_TIME_BASE = 49144;
    private final RealTimeCounter rtc;
    private final Int2ObjectMap<Interrupt> msips = new Int2ObjectArrayMap();
    private final Int2ObjectMap<Interrupt> mtips = new Int2ObjectArrayMap();
    @Serialized
    private final Int2LongArrayMap mtimecmps = new Int2LongArrayMap();

    public R5CoreLocalInterrupter(RealTimeCounter rtc) {
        this.rtc = rtc;
    }

    public void putHart(int id, InterruptController interruptController) {
        Interrupt msip = new Interrupt(3);
        msip.controller = interruptController;
        this.msips.put(id, (Object)msip);
        Interrupt mtip = new Interrupt(7);
        mtip.controller = interruptController;
        this.mtips.put(id, (Object)mtip);
        if (!this.mtimecmps.containsKey(id)) {
            this.mtimecmps.put(id, -1L);
        }
    }

    @Override
    public void step(int cycles) {
        this.checkTimeComparators();
    }

    @Override
    public Iterable<Interrupt> getInterrupts() {
        return Stream.concat(this.msips.values().stream(), this.mtips.values().stream()).collect(Collectors.toList());
    }

    @Override
    public int getLength() {
        return 786432;
    }

    @Override
    public int getSupportedSizes() {
        return 12;
    }

    @Override
    public long load(int offset, int sizeLog2) {
        if (offset >= 0 && offset < 16384) {
            int hartId = offset - 0 >>> 2;
            if (this.msips.containsKey(hartId) && (offset & 3) == 0) {
                return ((Interrupt)this.msips.get(hartId)).isRaised() ? 1L : 0L;
            }
            return 0L;
        }
        if (offset >= 16384 && offset < 49144) {
            int hartId = offset - 16384 >>> 3;
            if (this.mtimecmps.containsKey(hartId)) {
                if ((offset & 7) == 0) {
                    return this.mtimecmps.get(hartId);
                }
                if ((offset & 7) == 4) {
                    return (int)(this.mtimecmps.get(hartId) >>> 32);
                }
            }
            return 0L;
        }
        if (offset == 49144) {
            return this.rtc.getTime();
        }
        if (offset == 49148) {
            return (int)(this.rtc.getTime() >>> 32);
        }
        return 0L;
    }

    @Override
    public void store(int offset, long value, int sizeLog2) {
        int hartId;
        if (offset >= 0 && offset < 16384) {
            int hartId2 = offset - 0 >>> 2;
            if (this.msips.containsKey(hartId2) && (offset & 3) == 0) {
                if (value == 0L) {
                    ((Interrupt)this.msips.get(hartId2)).lowerInterrupt();
                } else {
                    ((Interrupt)this.msips.get(hartId2)).raiseInterrupt();
                }
            }
        } else if (offset >= 16384 && offset < 49144 && this.mtimecmps.containsKey(hartId = offset - 16384 >>> 3)) {
            if ((offset & 7) == 0) {
                long mtimecmp = this.mtimecmps.get(hartId);
                if (sizeLog2 == 2) {
                    mtimecmp = mtimecmp & 0xFFFFFFFF00000000L | value & 0xFFFFFFFFL;
                } else {
                    assert (sizeLog2 == 3);
                    mtimecmp = value;
                }
                this.mtimecmps.put(hartId, mtimecmp);
                if (Long.compareUnsigned(mtimecmp, this.rtc.getTime()) < 0) {
                    ((Interrupt)this.mtips.get(hartId)).raiseInterrupt();
                } else {
                    ((Interrupt)this.mtips.get(hartId)).lowerInterrupt();
                }
            } else if ((offset & 7) == 4) {
                long mtimecmp = this.mtimecmps.get(hartId);
                mtimecmp = mtimecmp & 0xFFFFFFFFL | value << 32;
                this.mtimecmps.put(hartId, mtimecmp);
                if (Long.compareUnsigned(mtimecmp, this.rtc.getTime()) < 0) {
                    ((Interrupt)this.mtips.get(hartId)).raiseInterrupt();
                } else {
                    ((Interrupt)this.mtips.get(hartId)).lowerInterrupt();
                }
            }
        }
    }

    private void checkTimeComparators() {
        this.mtimecmps.forEach((hartId, mtimecmp) -> {
            if (Long.compareUnsigned(mtimecmp, this.rtc.getTime()) <= 0) {
                ((Interrupt)this.mtips.get(hartId.intValue())).raiseInterrupt();
            }
        });
    }
}

