/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer.slice();
    }

    @Override
    public int read() {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if ((len = Math.min(len, this.buffer.remaining())) == 0) {
            return -1;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        int newPosition = (int)Math.min((long)this.buffer.position() + n, (long)this.buffer.limit());
        int skipped = newPosition - this.buffer.position();
        this.buffer.position(newPosition);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }
}

