/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public final class ByteBufferOutputStream
extends OutputStream {
    private final ByteBuffer buffer;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer.slice();
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.buffer.put((byte)b);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.buffer.put(b, off, len);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }
}

