/*
 * Decompiled with CFR 0.152.
 */
package li.cil.sedna.utils;

import java.math.BigInteger;
import li.cil.sedna.utils.SoftFloat;

public final class SoftDouble {
    public static final int FLAG_INEXACT = 1;
    public static final int FLAG_UNDERFLOW = 2;
    public static final int FLAG_OVERFLOW = 4;
    public static final int FLAG_DIV_ZERO = 8;
    public static final int FLAG_INVALID = 16;
    public static final byte RM_RNE = 0;
    public static final byte RM_RTZ = 1;
    public static final byte RM_RDN = 2;
    public static final byte RM_RUP = 3;
    public static final byte RM_RMM = 4;
    public static final int FCLASS_NEGINF = 1;
    public static final int FCLASS_NEGNORM = 2;
    public static final int FCLASS_NEGSUBN = 4;
    public static final int FCLASS_NEGZERO = 8;
    public static final int FCLASS_POSZERO = 16;
    public static final int FCLASS_POSSUBN = 32;
    public static final int FCLASS_POSNORM = 64;
    public static final int FCLASS_POSINF = 128;
    public static final int FCLASS_SNAN = 256;
    public static final int FCLASS_QNAN = 512;
    public static final int SIZE = 64;
    public static final int EXPONENT_SIZE = 11;
    public static final int MANTISSA_SIZE = 52;
    public static final long SIGN_MASK = Long.MIN_VALUE;
    public static final int EXPONENT_MASK = 2047;
    public static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    public static final int BIAS = 1023;
    private static final int INTERNAL_MANTISSA_SIZE = 62;
    private static final int RND_SIZE = 10;
    private static final long MANTISSA_IMPLICIT_BIT = 0x10000000000000L;
    private static final long QUIET_NAN_MASK = 0x8000000000000L;
    private static final long QUIET_NAN = Integer.toUnsignedLong(2047) << 52 | 0x8000000000000L;
    public final SoftFloat.Flags flags;

    public SoftDouble() {
        this.flags = new SoftFloat.Flags();
    }

    public SoftDouble(SoftFloat.Flags flags) {
        this.flags = flags;
    }

    public static long nan() {
        return QUIET_NAN;
    }

    public static boolean isNaN(long a) {
        return (a >>> 52 & 0x7FFL) == 2047L && (a & 0xFFFFFFFFFFFFFL) != 0L;
    }

    public static boolean isInfinity(long a) {
        return (a >>> 52 & 0x7FFL) == 2047L && (a & 0xFFFFFFFFFFFFFL) == 0L;
    }

    public int sign(long a) {
        if (SoftDouble.isNaN(a)) {
            if (SoftDouble.isSignalingNaN(a)) {
                this.flags.raise(16);
            }
            return 0;
        }
        return (a & Long.MIN_VALUE) == 0L ? 1 : -1;
    }

    public long neg(long a) {
        if (SoftDouble.isNaN(a)) {
            if (SoftDouble.isSignalingNaN(a)) {
                this.flags.raise(16);
            }
            return SoftDouble.nan();
        }
        return a ^ Long.MIN_VALUE;
    }

    public long add(long a, long b, int rm) {
        int sign;
        long mantissa;
        if ((a & Long.MAX_VALUE) < (b & Long.MAX_VALUE)) {
            long tmp = a;
            a = b;
            b = tmp;
        }
        int signA = SoftDouble.getSign(a);
        int signB = SoftDouble.getSign(b);
        int exponentA = SoftDouble.getExponent(a);
        int exponentB = SoftDouble.getExponent(b);
        long mantissaA = SoftDouble.getMantissa(a) << 3;
        long mantissaB = SoftDouble.getMantissa(b) << 3;
        if (exponentA == 2047) {
            if (mantissaA != 0L) {
                if (SoftDouble.isSignalingNaN(a) || SoftDouble.isSignalingNaN(b)) {
                    this.flags.raise(16);
                }
                return SoftDouble.nan();
            }
            if (exponentB == 2047 && signA != signB) {
                this.flags.raise(16);
                return SoftDouble.nan();
            }
            return a;
        }
        if (exponentA == 0) {
            exponentA = 1;
        } else {
            mantissaA |= 0x80000000000000L;
        }
        if (exponentB == 0) {
            exponentB = 1;
        } else {
            mantissaB |= 0x80000000000000L;
        }
        mantissaB = SoftDouble.shiftRightAndJam(mantissaB, exponentA - exponentB);
        if (signA == signB) {
            mantissa = mantissaA + mantissaB;
            sign = signA;
        } else {
            mantissa = mantissaA - mantissaB;
            sign = mantissa == 0L ? (rm == 2 ? 1 : 0) : signA;
        }
        int exponent = exponentA + 7;
        return SoftDouble.normalize(sign, exponent, mantissa, rm, this.flags);
    }

    public long sub(long a, long b, int rm) {
        return this.add(a, this.neg(b), rm);
    }

    public long mul(long a, long b, int rm) {
        int_long exponentAndMantissa;
        int signA = SoftDouble.getSign(a);
        int signB = SoftDouble.getSign(b);
        int exponentA = SoftDouble.getExponent(a);
        int exponentB = SoftDouble.getExponent(b);
        long mantissaA = SoftDouble.getMantissa(a);
        long mantissaB = SoftDouble.getMantissa(b);
        int sign = signA ^ signB;
        if (exponentA == 2047 || exponentB == 2047) {
            if (SoftDouble.isNaN(a) || SoftDouble.isNaN(b)) {
                if (SoftDouble.isSignalingNaN(a) || SoftDouble.isSignalingNaN(b)) {
                    this.flags.raise(16);
                }
                return SoftDouble.nan();
            }
            if (exponentA == 2047 && exponentB == 0 && mantissaB == 0L || exponentB == 2047 && exponentA == 0 && mantissaA == 0L) {
                this.flags.raise(16);
                return SoftDouble.nan();
            }
            return SoftDouble.pack(sign, 2047, 0L);
        }
        if (exponentA == 0) {
            if (mantissaA == 0L) {
                return SoftDouble.pack(sign, 0, 0L);
            }
            exponentAndMantissa = SoftDouble.normalizeSubnormal(mantissaA);
            exponentA = exponentAndMantissa.a;
            mantissaA = exponentAndMantissa.b;
        } else {
            mantissaA |= 0x10000000000000L;
        }
        if (exponentB == 0) {
            if (mantissaB == 0L) {
                return SoftDouble.pack(sign, 0, 0L);
            }
            exponentAndMantissa = SoftDouble.normalizeSubnormal(mantissaB);
            exponentB = exponentAndMantissa.a;
            mantissaB = exponentAndMantissa.b;
        } else {
            mantissaB |= 0x10000000000000L;
        }
        int exponent = exponentA + exponentB - 1024 + 2;
        long2 mantissaHighAndLow = SoftDouble.multiply(mantissaA << 10, mantissaB << 11);
        long mantissa = mantissaHighAndLow.a | (long)(mantissaHighAndLow.b != 0L ? 1 : 0);
        return SoftDouble.normalize(sign, exponent, mantissa, rm, this.flags);
    }

    public long muladd(long a, long b, long c, int rm) {
        long tmp;
        int shift;
        int_long exponentAndMantissa;
        int signA = SoftDouble.getSign(a);
        int signB = SoftDouble.getSign(b);
        int signC = SoftDouble.getSign(c);
        int exponentA = SoftDouble.getExponent(a);
        int exponentB = SoftDouble.getExponent(b);
        int exponentC = SoftDouble.getExponent(c);
        long mantissaA = SoftDouble.getMantissa(a);
        long mantissaB = SoftDouble.getMantissa(b);
        long mantissaC = SoftDouble.getMantissa(c);
        int sign = signA ^ signB;
        if (exponentA == 2047 || exponentB == 2047 || exponentC == 2047) {
            if (SoftDouble.isNaN(a) || SoftDouble.isNaN(b) || SoftDouble.isNaN(c)) {
                if (SoftDouble.isSignalingNaN(a) || SoftDouble.isSignalingNaN(b) || SoftDouble.isSignalingNaN(c)) {
                    this.flags.raise(16);
                }
                return SoftDouble.nan();
            }
            if (exponentA == 2047 && exponentB == 0 && mantissaB == 0L || exponentB == 2047 && exponentA == 0 && mantissaA == 0L || (exponentA == 2047 || exponentB == 2047) && exponentC == 2047 && sign != signC) {
                this.flags.raise(16);
                return SoftDouble.nan();
            }
            if (exponentC == 2047) {
                return SoftDouble.pack(signC, 2047, 0L);
            }
            return SoftDouble.pack(sign, 2047, 0L);
        }
        if (exponentA == 0) {
            if (mantissaA == 0L) {
                if (exponentC == 0 && mantissaC == 0L) {
                    if (signC != sign) {
                        return SoftDouble.pack(rm == 2 ? 1 : 0, 0, 0L);
                    }
                    return SoftDouble.pack(sign, 0, 0L);
                }
                return c;
            }
            exponentAndMantissa = SoftDouble.normalizeSubnormal(mantissaA);
            exponentA = exponentAndMantissa.a;
            mantissaA = exponentAndMantissa.b;
        } else {
            mantissaA |= 0x10000000000000L;
        }
        if (exponentB == 0) {
            if (mantissaB == 0L) {
                if (exponentC == 0 && mantissaC == 0L) {
                    if (signC != sign) {
                        return SoftDouble.pack(rm == 2 ? 1 : 0, 0, 0L);
                    }
                    return SoftDouble.pack(sign, 0, 0L);
                }
                return c;
            }
            exponentAndMantissa = SoftDouble.normalizeSubnormal(mantissaB);
            exponentB = exponentAndMantissa.a;
            mantissaB = exponentAndMantissa.b;
        } else {
            mantissaB |= 0x10000000000000L;
        }
        int exponent = exponentA + exponentB - 1024 + 3;
        long2 mantissaHighAndLow = SoftDouble.multiply(mantissaA << 10, mantissaB << 10);
        long mantissa0 = mantissaHighAndLow.b;
        long mantissa1 = mantissaHighAndLow.a;
        if (mantissa1 < 0x2000000000000000L) {
            mantissa1 = mantissa1 << 1 | mantissa0 >>> 63;
            mantissa0 <<= 1;
            --exponent;
        }
        if (exponentC == 0) {
            if (mantissaC == 0L) {
                return SoftDouble.normalize(sign, exponent, mantissa1, rm, this.flags);
            }
            int_long exponentAndMantissa2 = SoftDouble.normalizeSubnormal(mantissaC);
            exponentC = exponentAndMantissa2.a;
            mantissaC = exponentAndMantissa2.b;
        } else {
            mantissaC |= 0x10000000000000L;
        }
        long mantissaC0 = 0L;
        long mantissaC1 = mantissaC << 9;
        if (exponent <= ++exponentC && (exponent != exponentC || mantissa1 < mantissaC1)) {
            long tmp2 = mantissa0;
            mantissa0 = mantissaC0;
            mantissaC0 = tmp2;
            tmp2 = mantissa1;
            mantissa1 = mantissaC1;
            mantissaC1 = tmp2;
            int tmpi = exponent;
            exponent = exponentC;
            exponentC = tmpi;
            tmpi = sign;
            sign = signC;
            signC = tmpi;
        }
        if ((shift = exponent - exponentC) >= 128) {
            mantissaC0 = (mantissaC0 | mantissaC1) != 0L ? 1L : 0L;
            mantissaC1 = 0L;
        } else if (shift >= 65) {
            mantissaC0 = SoftDouble.shiftRightAndJam(mantissaC1, shift - 64);
            mantissaC1 = 0L;
        } else if (shift == 64) {
            mantissaC0 = mantissaC1 | (long)(mantissaC0 != 0L ? 1 : 0);
            mantissaC1 = 0L;
        } else if (shift != 0) {
            mantissaC0 = mantissaC1 << 64 - shift | mantissaC0 >> shift | (long)((mantissaC0 & (1L << shift) - 1L) != 0L ? 1 : 0);
            mantissaC1 >>>= shift;
        }
        if (sign == signC) {
            mantissa1 += mantissaC1 + (long)((mantissa0 += mantissaC0) < mantissaC0 ? 1 : 0);
        } else if ((mantissa0 | (mantissa1 = mantissa1 - mantissaC1 - (long)((mantissa0 -= mantissaC0) > (tmp = mantissa0) ? 1 : 0))) == 0L) {
            sign = rm == 2 ? 1 : 0;
        }
        return SoftDouble.normalize(sign, exponent, mantissa0, mantissa1, rm, this.flags);
    }

    public long mulsub(long a, long b, long c, int rm) {
        return this.muladd(a, b, this.neg(c), rm);
    }

    public long div(long a, long b, int rm) {
        int_long exponentAndMantissa;
        int signA = SoftDouble.getSign(a);
        int signB = SoftDouble.getSign(b);
        int exponentA = SoftDouble.getExponent(a);
        int exponentB = SoftDouble.getExponent(b);
        long mantissaA = SoftDouble.getMantissa(a);
        long mantissaB = SoftDouble.getMantissa(b);
        int sign = signA ^ signB;
        if (exponentA == 2047 || exponentB == 2047) {
            if (SoftDouble.isNaN(a) || SoftDouble.isNaN(b)) {
                if (SoftDouble.isSignalingNaN(a) || SoftDouble.isSignalingNaN(b)) {
                    this.flags.raise(16);
                }
                return SoftDouble.nan();
            }
            if (exponentA == 2047 && exponentB == 2047) {
                this.flags.raise(16);
                return SoftDouble.nan();
            }
            if (exponentA == 2047) {
                return SoftDouble.pack(sign, 2047, 0L);
            }
            return SoftDouble.pack(sign, 0, 0L);
        }
        if (exponentB == 0) {
            if (mantissaB == 0L) {
                if (exponentA == 0 && mantissaA == 0L) {
                    this.flags.raise(16);
                    return SoftDouble.nan();
                }
                this.flags.raise(8);
                return SoftDouble.pack(sign, 2047, 0L);
            }
            exponentAndMantissa = SoftDouble.normalizeSubnormal(mantissaB);
            exponentB = exponentAndMantissa.a;
            mantissaB = exponentAndMantissa.b;
        } else {
            mantissaB |= 0x10000000000000L;
        }
        if (exponentA == 0) {
            if (mantissaA == 0L) {
                return SoftDouble.pack(sign, 0, 0L);
            }
            exponentAndMantissa = SoftDouble.normalizeSubnormal(mantissaA);
            exponentA = exponentAndMantissa.a;
            mantissaA = exponentAndMantissa.b;
        } else {
            mantissaA |= 0x10000000000000L;
        }
        int exponent = exponentA - exponentB + 1024 - 1;
        long2 mantissaAndRemainder = SoftDouble.divideAndRemainder(mantissaA, mantissaB << 2);
        long mantissa = mantissaAndRemainder.a | (long)(mantissaAndRemainder.b != 0L ? 1 : 0);
        return SoftDouble.normalize(sign, exponent, mantissa, rm, this.flags);
    }

    public long sqrt(long a, int rm) {
        int signA = SoftDouble.getSign(a);
        int exponentA = SoftDouble.getExponent(a);
        long mantissaA = SoftDouble.getMantissa(a);
        if (exponentA == 2047) {
            if (SoftDouble.isNaN(a)) {
                if (SoftDouble.isSignalingNaN(a)) {
                    this.flags.raise(16);
                }
                return SoftDouble.nan();
            }
            if (signA == 1) {
                this.flags.raise(16);
                return SoftDouble.nan();
            }
            return a;
        }
        if (signA == 1) {
            if (exponentA == 0 && mantissaA == 0L) {
                return a;
            }
            this.flags.raise(16);
            return SoftDouble.nan();
        }
        if (exponentA == 0) {
            if (mantissaA == 0L) {
                return SoftDouble.pack(0, 0, 0L);
            }
            int_long exponentAndMantissa = SoftDouble.normalizeSubnormal(mantissaA);
            exponentA = exponentAndMantissa.a;
            mantissaA = exponentAndMantissa.b;
        } else {
            mantissaA |= 0x10000000000000L;
        }
        if (((exponentA -= 1023) & 1) != 0) {
            --exponentA;
            mantissaA <<= 1;
        }
        exponentA = (exponentA >> 1) + 1023;
        long2 sqrtAndInexact = SoftDouble.sqrtAndRemainder(mantissaA <<= 8);
        mantissaA = sqrtAndInexact.a;
        if (sqrtAndInexact.b != 0L) {
            mantissaA |= 1L;
        }
        return SoftDouble.normalize(signA, exponentA, mantissaA, rm, this.flags);
    }

    public long min(long a, long b) {
        int signB;
        if (SoftDouble.isNaN(a) || SoftDouble.isNaN(b)) {
            return this.handleMinMaxNaN(a, b);
        }
        int signA = SoftDouble.getSign(a);
        if (signA != (signB = SoftDouble.getSign(b))) {
            if (signA != 0) {
                return a;
            }
            return b;
        }
        if (Long.compareUnsigned(a, b) < 0 ^ signA != 0) {
            return a;
        }
        return b;
    }

    public long max(long a, long b) {
        int signB;
        if (SoftDouble.isNaN(a) || SoftDouble.isNaN(b)) {
            return this.handleMinMaxNaN(a, b);
        }
        int signA = SoftDouble.getSign(a);
        if (signA != (signB = SoftDouble.getSign(b))) {
            if (signA != 0) {
                return b;
            }
            return a;
        }
        if (Long.compareUnsigned(a, b) < 0 ^ signA != 0) {
            return b;
        }
        return a;
    }

    public boolean equals(long a, long b) {
        if (SoftDouble.isNaN(a) || SoftDouble.isNaN(b)) {
            if (SoftDouble.isSignalingNaN(a) || SoftDouble.isSignalingNaN(b)) {
                this.flags.raise(16);
            }
            return false;
        }
        if ((a | b) << 1 == 0L) {
            return true;
        }
        return a == b;
    }

    public boolean lessOrEqual(long a, long b) {
        int signB;
        if (SoftDouble.isNaN(a) || SoftDouble.isNaN(b)) {
            this.flags.raise(16);
            return false;
        }
        int signA = SoftDouble.getSign(a);
        if (signA != (signB = SoftDouble.getSign(b))) {
            return signA != 0 || (a | b) << 1 == 0L;
        }
        if (signA != 0) {
            return a >= b;
        }
        return a <= b;
    }

    public boolean lessThan(long a, long b) {
        int signB;
        if (SoftDouble.isNaN(a) || SoftDouble.isNaN(b)) {
            this.flags.raise(16);
            return false;
        }
        int signA = SoftDouble.getSign(a);
        if (signA != (signB = SoftDouble.getSign(b))) {
            return signA != 0 && (a | b) << 1 != 0L;
        }
        if (signA != 0) {
            return a > b;
        }
        return a < b;
    }

    public int classify(long a) {
        int signA = SoftDouble.getSign(a);
        int exponentA = SoftDouble.getExponent(a);
        long mantissaA = SoftDouble.getMantissa(a);
        if (exponentA == 2047) {
            if (mantissaA == 0L) {
                if (signA != 0) {
                    return 1;
                }
                return 128;
            }
            if ((mantissaA & 0x8000000000000L) != 0L) {
                return 512;
            }
            return 256;
        }
        if (exponentA == 0) {
            if (mantissaA == 0L) {
                if (signA != 0) {
                    return 8;
                }
                return 16;
            }
            if (signA != 0) {
                return 4;
            }
            return 32;
        }
        if (signA != 0) {
            return 2;
        }
        return 64;
    }

    public long intToDouble(int a, int rm) {
        return this.longToDouble(a, rm, false);
    }

    public long unsignedIntToDouble(int a, int rm) {
        return this.longToDouble(Integer.toUnsignedLong(a), rm, true);
    }

    public int doubleToInt(long a, int rm) {
        return (int)this.doubleToLong(a, rm, 32, false);
    }

    public int doubleToUnsignedInt(long a, int rm) {
        return (int)this.doubleToLong(a, rm, 32, true);
    }

    public long longToDouble(long a, int rm) {
        return this.longToDouble(a, rm, false);
    }

    public long unsignedLongToDouble(long a, int rm) {
        return this.longToDouble(a, rm, true);
    }

    public long doubleToLong(long a, int rm) {
        return this.doubleToLong(a, rm, 64, false);
    }

    public long doubleToUnsignedLong(long a, int rm) {
        return this.doubleToLong(a, rm, 64, true);
    }

    public int doubleToFloat(long a, int rm) {
        int sign = SoftDouble.getSign(a);
        int exponent = SoftDouble.getExponent(a);
        long mantissa = SoftDouble.getMantissa(a);
        if (exponent == 2047) {
            if (mantissa != 0L) {
                if (SoftDouble.isSignalingNaN(a)) {
                    this.flags.raise(16);
                }
                return SoftFloat.nan();
            }
            return SoftFloat.pack(sign, 255, 0);
        }
        if (exponent == 0) {
            if (mantissa == 0L) {
                return SoftFloat.pack(sign, 0, 0);
            }
            int_long exponentAndMantissa = SoftDouble.normalizeSubnormal(mantissa);
            exponent = exponentAndMantissa.a;
            mantissa = exponentAndMantissa.b;
        } else {
            mantissa |= 0x10000000000000L;
        }
        return SoftFloat.normalize(sign, exponent + -896, (int)SoftDouble.shiftRightAndJam(mantissa, 22), rm, this.flags);
    }

    public long floatToDouble(int a, int rm) {
        int sign = SoftFloat.getSign(a);
        int exponent = SoftFloat.getExponent(a);
        int mantissa = SoftFloat.getMantissa(a);
        if (exponent == 255) {
            if (mantissa != 0) {
                if (SoftFloat.isSignalingNaN(a)) {
                    this.flags.raise(16);
                }
                return SoftDouble.nan();
            }
            return SoftDouble.pack(sign, 2047, 0L);
        }
        if (exponent == 0) {
            if (mantissa == 0) {
                return SoftDouble.pack(sign, 0, 0L);
            }
            SoftFloat.int2 exponentAndMantissa = SoftFloat.normalizeSubnormal(mantissa);
            exponent = exponentAndMantissa.a;
            mantissa = exponentAndMantissa.b;
        }
        return SoftDouble.pack(sign, exponent + 896, (long)mantissa << 29);
    }

    private long longToDouble(long a, int rm, boolean isUnsigned) {
        long mantissa;
        int sign;
        if (!isUnsigned && a < 0L) {
            sign = 1;
            mantissa = -a;
        } else {
            sign = 0;
            mantissa = a;
        }
        int exponent = 1085;
        int l = 64 - Long.numberOfLeadingZeros(mantissa) - 63;
        if (l > 0) {
            long mask = (1L << l) - 1L;
            mantissa = mantissa >>> l | (long)((mantissa & mask) != 0L ? 1 : 0);
            exponent += l;
        }
        return SoftDouble.normalize(sign, exponent, mantissa, rm, this.flags);
    }

    /*
     * Enabled aggressive block sorting
     */
    private long doubleToLong(long a, int rm, int intSize, boolean isUnsigned) {
        long result;
        int sign = SoftDouble.getSign(a);
        int exponent = SoftDouble.getExponent(a);
        long mantissa = SoftDouble.getMantissa(a);
        if (exponent == 2047 && mantissa != 0L) {
            sign = 0;
        }
        if (exponent == 0) {
            exponent = 1;
        } else {
            mantissa |= 0x10000000000000L;
        }
        mantissa <<= 10;
        exponent = exponent - 1023 - 52;
        long max = isUnsigned ? (long)sign - 1L >>> 64 - intSize : (1L << intSize - 1) - (long)(sign ^ 1);
        if (exponent >= 0) {
            if (exponent > intSize - 1 - 52) {
                this.flags.raise(16);
                return max;
            }
            result = mantissa >>> 10 << exponent;
            if (Long.compareUnsigned(result, max) > 0) {
                this.flags.raise(16);
                return max;
            }
        } else {
            int addend;
            mantissa = SoftDouble.shiftRightAndJam(mantissa, -exponent);
            switch (rm) {
                case 0: 
                case 4: {
                    addend = 512;
                    break;
                }
                case 1: {
                    addend = 0;
                    break;
                }
                case 2: 
                case 3: {
                    if (sign == 0 ? rm == 2 : rm == 3) {
                        addend = 1023;
                        break;
                    }
                    addend = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            long rnd_bits = mantissa & 0x3FFL;
            mantissa = mantissa + (long)addend >>> 10;
            if (rm == 0 && rnd_bits == 512L) {
                mantissa &= 0xFFFFFFFFFFFFFFFEL;
            }
            if (Long.compareUnsigned(mantissa, max) > 0) {
                this.flags.raise(16);
                return max;
            }
            result = mantissa;
            if (rnd_bits != 0L) {
                this.flags.raise(1);
            }
        }
        if (sign == 0) return result;
        return -result;
    }

    private static long2 multiply(long a, long b) {
        BigInteger result = SoftDouble.unsignedLongTo128(a).multiply(SoftDouble.unsignedLongTo128(b));
        return long2.of(result.shiftRight(64).longValue(), result.longValue());
    }

    private static long2 divideAndRemainder(long ah, long b) {
        BigInteger[] result = BigInteger.valueOf(ah).shiftLeft(64).divideAndRemainder(BigInteger.valueOf(b));
        return long2.of(result[0].longValueExact(), result[1].longValueExact());
    }

    private static long2 sqrtAndRemainder(long ah) {
        BigInteger s;
        if (ah == 0L) {
            return long2.of(0L, 0L);
        }
        int l = 128 - Long.numberOfLeadingZeros(ah - 1L);
        BigInteger a = BigInteger.valueOf(ah).shiftLeft(64);
        BigInteger u = BigInteger.valueOf(1L).shiftLeft((l + 1) / 2);
        while ((u = a.divide(s = u).add(s).shiftRight(1)).compareTo(s) < 0) {
        }
        return long2.of(s.longValueExact(), a.subtract(s.multiply(s)).getLowestSetBit() != -1 ? 1L : 0L);
    }

    private long handleMinMaxNaN(long a, long b) {
        if (SoftDouble.isSignalingNaN(a) || SoftDouble.isSignalingNaN(b)) {
            this.flags.raise(16);
        }
        if (SoftDouble.isNaN(a)) {
            if (SoftDouble.isNaN(b)) {
                return SoftDouble.nan();
            }
            return b;
        }
        return a;
    }

    private static boolean isSignalingNaN(long a) {
        return SoftDouble.isNaN(a) && (a & 0x8000000000000L) == 0L;
    }

    private static int_long normalizeSubnormal(long mantissa) {
        int shift = 52 - (63 - Long.numberOfLeadingZeros(mantissa));
        return int_long.of(1 - shift, mantissa << shift);
    }

    private static long normalize(int sign, int exponent, long mantissa, int rm, SoftFloat.Flags flags) {
        int shift = Long.numberOfLeadingZeros(mantissa) - 1;
        assert (shift >= 0);
        return SoftDouble.round(sign, exponent - shift, mantissa << shift, rm, flags);
    }

    private static long normalize(int sign, int exponent, long mantissa0, long mantissa1, int rm, SoftFloat.Flags flags) {
        int l = mantissa1 == 0L ? 64 + Long.numberOfLeadingZeros(mantissa0) : Long.numberOfLeadingZeros(mantissa1);
        int shift = l - 1;
        assert (shift >= 0);
        long mantissa = shift == 0 ? mantissa1 | (long)(mantissa0 != 0L ? 1 : 0) : (shift < 64 ? mantissa1 << shift | mantissa0 >>> 64 - shift | (long)(mantissa0 << shift != 0L ? 1 : 0) : mantissa0 << shift - 64);
        return SoftDouble.round(sign, exponent - shift, mantissa, rm, flags);
    }

    private static long round(int sign, int exponent, long mantissa, int rm, SoftFloat.Flags flags) {
        int rnd_bits;
        int addend;
        switch (rm) {
            case 0: 
            case 4: {
                addend = 512;
                break;
            }
            case 1: {
                addend = 0;
                break;
            }
            case 2: 
            case 3: {
                if (sign == 0 ? rm == 2 : rm == 3) {
                    addend = 1023;
                    break;
                }
                addend = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (exponent <= 0) {
            long min = Long.MIN_VALUE;
            boolean isSubnormal = exponent < 0 || Long.compareUnsigned(mantissa + (long)addend, Long.MIN_VALUE) < 0;
            int diff = 1 - exponent;
            mantissa = SoftDouble.shiftRightAndJam(mantissa, diff);
            rnd_bits = (int)(mantissa & 0x3FFL);
            if (isSubnormal && rnd_bits != 0) {
                flags.raise(2);
            }
            exponent = 1;
        } else {
            rnd_bits = (int)(mantissa & 0x3FFL);
        }
        if (rnd_bits != 0) {
            flags.raise(1);
        }
        mantissa = mantissa + (long)addend >>> 10;
        if (rm == 0 && rnd_bits == 512) {
            mantissa &= 0xFFFFFFFFFFFFFFFEL;
        }
        exponent = (int)((long)exponent + (mantissa >>> 53));
        if (mantissa <= 0xFFFFFFFFFFFFFL) {
            exponent = 0;
        } else if (exponent >= 2047) {
            if (addend == 0) {
                exponent = 2046;
                mantissa = 0xFFFFFFFFFFFFFL;
            } else {
                exponent = 2047;
                mantissa = 0L;
            }
            flags.raise(5);
        }
        return SoftDouble.pack(sign, exponent, mantissa);
    }

    private static long shiftRightAndJam(long a, int d) {
        if (d == 0) {
            return a;
        }
        if (d >= 64) {
            return a != 0L ? 1L : 0L;
        }
        return a >>> d | (long)((a & (1L << d) - 1L) != 0L ? 1 : 0);
    }

    private static long pack(int sign, int exponent, long mantissa) {
        return (long)sign << 63 | Integer.toUnsignedLong(exponent) << 52 | mantissa & 0xFFFFFFFFFFFFFL;
    }

    private static int getSign(long a) {
        return (int)(a >>> 63);
    }

    private static int getExponent(long a) {
        return (int)(a >>> 52 & 0x7FFL);
    }

    private static long getMantissa(long a) {
        return a & 0xFFFFFFFFFFFFFL;
    }

    private static BigInteger unsignedLongTo128(long value) {
        if (value >= 0L) {
            return BigInteger.valueOf(value);
        }
        return BigInteger.valueOf(Integer.toUnsignedLong((int)(value >>> 32))).shiftLeft(32).or(BigInteger.valueOf(Integer.toUnsignedLong((int)value)));
    }

    private static final class long2 {
        private static final ThreadLocal<long2> INSTANCE = ThreadLocal.withInitial(long2::new);
        public long a;
        public long b;

        private long2() {
        }

        public static long2 of(long a, long b) {
            long2 instance = INSTANCE.get();
            instance.a = a;
            instance.b = b;
            return instance;
        }
    }

    private static final class int_long {
        private static final ThreadLocal<int_long> INSTANCE = ThreadLocal.withInitial(int_long::new);
        public int a;
        public long b;

        private int_long() {
        }

        public static int_long of(int a, long b) {
            int_long instance = INSTANCE.get();
            instance.a = a;
            instance.b = b;
            return instance;
        }
    }
}

