/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.gui.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.configmenusforge.client.gui.components.CustomBackgroundObjectSelectionList;
import fuzs.configmenusforge.client.gui.screens.ConfigScreen;
import fuzs.configmenusforge.client.gui.screens.SelectConfigScreen;
import fuzs.configmenusforge.config.data.IEntryData;
import java.io.File;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;

public class ConfigSelectionList
extends CustomBackgroundObjectSelectionList<ConfigListEntry> {
    private static final ResourceLocation ICON_LOCATION = new ResourceLocation("configmenusforge", "textures/misc/config.png");
    private static final ResourceLocation ICON_DISABLED_LOCATION = new ResourceLocation("configmenusforge", "textures/misc/disabled_config.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/world_selection.png");
    private static final ITextComponent NO_DATA_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.select.no_data").func_240699_a_(TextFormatting.RED);
    private static final ITextComponent NO_PERMISSIONS_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.select.no_permissions").func_240699_a_(TextFormatting.GOLD);
    private static final ITextComponent MULTIPLAYER_SERVER_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.select.multiplayer_server").func_240699_a_(TextFormatting.GOLD);
    private final SelectConfigScreen screen;

    public ConfigSelectionList(SelectConfigScreen selectConfigScreen, Minecraft minecraft, int i, int j, int k, int l, int m, String query) {
        super(minecraft, selectConfigScreen.getBackground(), i, j, k, l, m);
        this.screen = selectConfigScreen;
        this.refreshList(query);
    }

    public void refreshList(String query) {
        this.func_230963_j_();
        this.setSelected(null);
        String lowerCaseQuery = query.toLowerCase(Locale.ROOT).trim();
        this.screen.getConfigs().stream().filter(config -> ConfigSelectionList.matchesConfigSearch(config, lowerCaseQuery)).sorted(Comparator.comparing(config -> config.getType().extension()).thenComparing(ConfigSelectionList::getName)).forEach(config -> this.func_230513_b_((AbstractList.AbstractListEntry)new ConfigListEntry(this.screen, this.field_230668_b_, (ModConfig)config)));
    }

    private static boolean matchesConfigSearch(ModConfig config, String query) {
        if (config.getFileName().toLowerCase(Locale.ROOT).contains(query)) {
            return true;
        }
        return config.getType().extension().contains(query);
    }

    protected int func_230952_d_() {
        return this.field_230670_d_ / 2 + 144;
    }

    public int func_230949_c_() {
        return 260;
    }

    protected boolean func_230971_aw__() {
        return this.screen.func_241217_q_() == this;
    }

    public void setSelected(@Nullable ConfigListEntry configListEntry) {
        super.func_241215_a_((AbstractList.AbstractListEntry)configListEntry);
        this.screen.updateButtonStatus(configListEntry != null && !configListEntry.isDisabled());
    }

    protected void func_241219_a_(AbstractList.Ordering selectionDirection) {
        this.func_241572_a_(selectionDirection, configListEntry -> !configListEntry.isDisabled());
    }

    static String getName(ModConfig config) {
        String fullName = config.getFileName();
        int start = fullName.lastIndexOf(File.separator) + 1;
        int end = fullName.lastIndexOf(".");
        return fullName.substring(start, end < start ? fullName.length() : end);
    }

    public class ConfigListEntry
    extends ExtendedList.AbstractListEntry<ConfigListEntry> {
        private final SelectConfigScreen screen;
        private final Minecraft minecraft;
        private final ModConfig config;
        private final boolean mayResetValue;
        private final ITextComponent nameComponent;
        private final ITextComponent fileNameComponent;
        private final ITextComponent typeComponent;
        private long lastClickTime;

        public ConfigListEntry(SelectConfigScreen selectConfigScreen, Minecraft minecraft, ModConfig config) {
            this.screen = selectConfigScreen;
            this.minecraft = minecraft;
            this.config = config;
            this.mayResetValue = selectConfigScreen.getValueToDataMap(config).values().stream().anyMatch(IEntryData::mayResetValue);
            this.nameComponent = this.mayResetValue ? new StringTextComponent(ConfigSelectionList.getName(config)).func_240699_a_(TextFormatting.ITALIC) : new StringTextComponent(ConfigSelectionList.getName(config));
            this.fileNameComponent = new StringTextComponent(config.getFileName());
            String extension = config.getType().extension();
            this.typeComponent = new TranslationTextComponent("configmenusforge.gui.type.title", new Object[]{StringUtils.capitalize((String)extension)});
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            FontRenderer font = this.minecraft.field_71466_p;
            font.func_243248_b(poseStack, this.nameComponent, (float)(entryLeft + 32 + 3), (float)(entryTop + 1), 0xFFFFFF);
            font.func_243248_b(poseStack, this.fileNameComponent, (float)(entryLeft + 32 + 3), (float)(entryTop + 9 + 3), 0x808080);
            font.func_243248_b(poseStack, this.typeComponent, (float)(entryLeft + 32 + 3), (float)(entryTop + 9 + 9 + 3), 0x808080);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(this.isDisabled() ? ICON_DISABLED_LOCATION : ICON_LOCATION);
            RenderSystem.enableBlend();
            AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)entryLeft, (int)entryTop, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.disableBlend();
            if (this.minecraft.field_71474_y.field_85185_A || hovered) {
                int textureY;
                this.minecraft.func_110434_K().func_110577_a(ICON_OVERLAY_LOCATION);
                AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)entryLeft, (int)entryTop, (int)(entryLeft + 32), (int)(entryTop + 32), (int)-1601138544);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean leftHovered = mouseX - entryLeft < 32;
                int n = textureY = leftHovered ? 32 : 0;
                if (this.invalidData()) {
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)entryLeft, (int)entryTop, (float)96.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_71466_p.func_238425_b_((ITextProperties)NO_DATA_TOOLTIP, 200));
                    }
                } else if (this.noPermissions()) {
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)entryLeft, (int)entryTop, (float)64.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_71466_p.func_238425_b_((ITextProperties)NO_PERMISSIONS_TOOLTIP, 200));
                    }
                } else if (this.onMultiplayerServer()) {
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)entryLeft, (int)entryTop, (float)32.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)entryLeft, (int)entryTop, (float)64.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_71466_p.func_238425_b_((ITextProperties)MULTIPLAYER_SERVER_TOOLTIP, 200));
                    }
                } else {
                    AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)entryLeft, (int)entryTop, (float)0.0f, (float)textureY, (int)32, (int)32, (int)256, (int)256);
                }
            }
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.isDisabled()) {
                return true;
            }
            ConfigSelectionList.this.setSelected(this);
            this.screen.updateButtonStatus(ConfigSelectionList.this.func_230958_g_() != null);
            if (mouseX - (double)ConfigSelectionList.this.func_230968_n_() <= 32.0) {
                this.openConfig();
                return true;
            }
            if (Util.func_211177_b() - this.lastClickTime < 250L) {
                this.openConfig();
                return true;
            }
            this.lastClickTime = Util.func_211177_b();
            return false;
        }

        public void openConfig() {
            ConfigScreen configScreen = ConfigScreen.create(this.screen, this.screen.getDisplayName(), this.screen.getBackground(), this.config, this.screen.getValueToDataMap(this.config));
            this.minecraft.func_147108_a((Screen)configScreen);
        }

        public boolean invalidData() {
            return this.config.getType() == ModConfig.Type.SERVER && this.minecraft.func_147114_u() == null || this.screen.getValueToDataMap(this.config).isEmpty();
        }

        private boolean noPermissions() {
            return this.config.getType() == ModConfig.Type.SERVER && !this.screen.getServerPermissions();
        }

        public boolean onMultiplayerServer() {
            return this.config.getType() == ModConfig.Type.SERVER && !this.minecraft.func_71387_A();
        }

        boolean isDisabled() {
            return this.invalidData() || this.noPermissions();
        }

        public ModConfig getConfig() {
            return this.config;
        }

        public boolean mayResetValue() {
            return this.mayResetValue;
        }
    }
}

