/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.gui.data;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.Iterators;
import fuzs.configmenusforge.client.gui.screens.ConfigScreen;
import fuzs.configmenusforge.client.gui.util.ScreenUtil;
import fuzs.configmenusforge.config.data.IEntryData;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class EntryData
implements IEntryData {
    private final String path;
    private final String comment;
    private final ITextComponent title;

    EntryData(String path, String comment, ITextComponent title) {
        this.path = path;
        this.comment = comment;
        this.title = title;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    public ITextComponent getTitle() {
        return this.title;
    }

    @Override
    public boolean mayResetValue() {
        return false;
    }

    @Override
    public boolean mayDiscardChanges() {
        return true;
    }

    @Override
    public void resetCurrentValue() {
    }

    @Override
    public void discardCurrentValue() {
    }

    @Override
    public void saveConfigValue() {
    }

    @Override
    public boolean category() {
        return false;
    }

    public static class ConfigEntryData<T>
    extends EntryData {
        private final ForgeConfigSpec.ConfigValue<T> configValue;
        private final ForgeConfigSpec.ValueSpec valueSpec;
        private T currentValue;

        public ConfigEntryData(String path, ForgeConfigSpec.ConfigValue<T> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(path, valueSpec.getComment(), ConfigEntryData.createLabel(path, configValue, valueSpec));
            this.configValue = configValue;
            this.valueSpec = valueSpec;
            this.currentValue = configValue.get();
        }

        @Override
        public boolean mayResetValue() {
            return !ConfigEntryData.listSafeEquals(this.currentValue, this.getDefaultValue());
        }

        @Override
        public boolean mayDiscardChanges() {
            return ConfigEntryData.listSafeEquals(this.configValue.get(), this.currentValue);
        }

        private static <T> boolean listSafeEquals(T o1, T o2) {
            if (o1 instanceof List && o2 instanceof List) {
                Stream<String> stream1 = ((List)o1).stream().map(o -> o instanceof Enum ? ((Enum)o).name() : o.toString());
                Stream<String> stream2 = ((List)o2).stream().map(o -> o instanceof Enum ? ((Enum)o).name() : o.toString());
                return Iterators.elementsEqual(stream1.iterator(), stream2.iterator());
            }
            return o1.equals(o2);
        }

        @Override
        public void resetCurrentValue() {
            this.currentValue = this.getDefaultValue();
        }

        @Override
        public void discardCurrentValue() {
            this.currentValue = this.configValue.get();
        }

        @Override
        public void saveConfigValue() {
            this.configValue.set(this.currentValue);
        }

        public T getDefaultValue() {
            return (T)this.valueSpec.getDefault();
        }

        public T getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(T currentValue) {
            this.currentValue = currentValue;
        }

        public ForgeConfigSpec.ValueSpec getValueSpec() {
            return this.valueSpec;
        }

        public List<String> getFullPath() {
            return this.configValue.getPath();
        }

        private static ITextComponent createLabel(String path, ForgeConfigSpec.ConfigValue<?> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            if (valueSpec.getTranslationKey() != null && I18n.func_188566_a((String)valueSpec.getTranslationKey())) {
                return new TranslationTextComponent(valueSpec.getTranslationKey());
            }
            return ScreenUtil.formatLabel(path);
        }
    }

    public static class CategoryEntryData
    extends EntryData {
        private final UnmodifiableConfig config;
        private ConfigScreen screen;

        public CategoryEntryData(String path, UnmodifiableConfig config, String comment) {
            super(path, comment, ScreenUtil.formatLabel(path));
            this.config = config;
        }

        public UnmodifiableConfig getConfig() {
            return this.config;
        }

        public ConfigScreen getScreen() {
            return this.screen;
        }

        public void setScreen(ConfigScreen screen) {
            this.screen = screen;
        }

        @Override
        public boolean category() {
            return true;
        }
    }
}

