/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import fuzs.configmenusforge.ConfigMenusForge;
import fuzs.configmenusforge.client.gui.components.CustomBackgroundContainerObjectSelectionList;
import fuzs.configmenusforge.client.gui.data.EntryData;
import fuzs.configmenusforge.client.gui.screens.EditEnumScreen;
import fuzs.configmenusforge.client.gui.screens.EditListScreen;
import fuzs.configmenusforge.client.gui.screens.EditStringScreen;
import fuzs.configmenusforge.client.gui.util.ScreenUtil;
import fuzs.configmenusforge.client.gui.widget.ConfigEditBox;
import fuzs.configmenusforge.client.gui.widget.IconButton;
import fuzs.configmenusforge.client.util.ServerConfigUploader;
import fuzs.configmenusforge.config.data.IEntryData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public abstract class ConfigScreen
extends Screen {
    public static final ResourceLocation ICONS_LOCATION = new ResourceLocation("configmenusforge", "textures/gui/icons.png");
    public static final ITextComponent SORTING_AZ_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.tooltip.sorting", new Object[]{new TranslationTextComponent("configmenusforge.gui.tooltip.sorting.az")});
    public static final ITextComponent SORTING_ZA_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.tooltip.sorting", new Object[]{new TranslationTextComponent("configmenusforge.gui.tooltip.sorting.za")});
    private static final ITextComponent RESET_TOOLTIP = new TranslationTextComponent("configmenusforge.gui.tooltip.reset");
    final Screen lastScreen;
    final ResourceLocation background;
    private final List<IEntryData> searchEntries;
    private final List<IEntryData> screenEntries;
    final Map<Object, IEntryData> valueToData;
    private ConfigList list;
    TextFieldWidget searchTextField;
    private Button reverseButton;
    private Button filterButton;
    private Button searchFilterButton;
    private final int[] buttonData;
    @Nullable
    private ConfigEditBox activeTextField;
    @Nullable
    private List<? extends IReorderingProcessor> activeTooltip;
    private int tooltipTicks;

    private ConfigScreen(Screen lastScreen, ITextComponent title, ResourceLocation background, UnmodifiableConfig config, Map<Object, IEntryData> valueToData, int[] buttonData) {
        super(title);
        this.lastScreen = lastScreen;
        this.background = background;
        this.valueToData = valueToData;
        this.buttonData = buttonData;
        this.searchEntries = this.gatherEntriesRecursive(config, valueToData);
        this.screenEntries = config.valueMap().values().stream().map(valueToData::get).collect(Collectors.toList());
        this.buildSubScreens(this.screenEntries);
    }

    private List<IEntryData> gatherEntriesRecursive(UnmodifiableConfig mainConfig, Map<Object, IEntryData> allEntries) {
        ArrayList entries = Lists.newArrayList();
        this.gatherEntriesRecursive(mainConfig, entries, allEntries);
        return ImmutableList.copyOf((Collection)entries);
    }

    private void gatherEntriesRecursive(UnmodifiableConfig mainConfig, List<IEntryData> entries, Map<Object, IEntryData> allEntries) {
        mainConfig.valueMap().values().forEach(value -> {
            entries.add((IEntryData)allEntries.get(value));
            if (value instanceof UnmodifiableConfig) {
                this.gatherEntriesRecursive((UnmodifiableConfig)value, entries, allEntries);
            }
        });
    }

    private void buildSubScreens(List<IEntryData> screenEntries) {
        for (IEntryData unit : screenEntries) {
            if (!(unit instanceof EntryData.CategoryEntryData)) continue;
            EntryData.CategoryEntryData categoryEntryData = (EntryData.CategoryEntryData)unit;
            categoryEntryData.setScreen(new Sub(this, categoryEntryData.getTitle(), categoryEntryData.getConfig()));
        }
    }

    public static ConfigScreen create(Screen lastScreen, ITextComponent title, ResourceLocation background, ModConfig config, Map<Object, IEntryData> valueToData) {
        return new Main(lastScreen, title, background, config.getSpec().getValues(), valueToData, () -> ServerConfigUploader.saveAndUpload(config));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        boolean focus = this.searchTextField != null && this.searchTextField.func_230999_j_();
        this.searchTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 121, 22, 242, 20, this.searchTextField, StringTextComponent.field_240750_d_){

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (this.func_146176_q() && button == 1) {
                    this.func_146180_a("");
                }
                return super.func_231044_a_(mouseX, mouseY, button);
            }
        };
        this.searchTextField.func_212954_a(query -> this.updateList((String)query, true));
        this.searchTextField.func_146195_b(focus);
        this.list = new ConfigList(this.getConfigListEntries(this.searchTextField.func_146179_b()));
        this.func_230481_d_((IGuiEventListener)this.list);
        this.func_230481_d_((IGuiEventListener)this.searchTextField);
        this.reverseButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_230708_k_ / 2 - 126 - 20, 22, 20, 20, this.buttonData[0] == 1 ? 20 : 0, 0, ICONS_LOCATION, button -> {
            this.buttonData[0] = (this.buttonData[0] + 1) % 2;
            this.updateList(true);
            ((IconButton)button).setTexture(this.buttonData[0] == 1 ? 20 : 0, 0);
        }, (button, poseStack, mouseX, mouseY) -> {
            if (button.field_230693_o_) {
                this.func_238652_a_(poseStack, this.buttonData[0] == 1 ? SORTING_ZA_TOOLTIP : SORTING_AZ_TOOLTIP, mouseX, mouseY);
            }
        }));
        this.filterButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_230708_k_ / 2 + 126, 22, 20, 20, EntryFilter.values()[this.buttonData[1]].getTextureX(), 0, ICONS_LOCATION, button -> {
            this.buttonData[1] = EntryFilter.cycle(this.buttonData[1], false, Screen.func_231173_s_());
            this.updateList(true);
            ((IconButton)button).setTexture(EntryFilter.values()[this.buttonData[1]].getTextureX(), 0);
        }, (button, poseStack, mouseX, mouseY) -> {
            if (button.field_230693_o_) {
                this.func_238652_a_(poseStack, EntryFilter.values()[this.buttonData[1]].getMessage(), mouseX, mouseY);
            }
        }));
        this.searchFilterButton = (Button)this.func_230480_a_((Widget)new IconButton(this.field_230708_k_ / 2 + 126, 22, 20, 20, EntryFilter.values()[this.buttonData[2]].getTextureX(), 0, ICONS_LOCATION, button -> {
            this.buttonData[2] = EntryFilter.cycle(this.buttonData[2], true, Screen.func_231173_s_());
            this.updateList(true);
            ((IconButton)button).setTexture(EntryFilter.values()[this.buttonData[2]].getTextureX(), 0);
        }, (button, poseStack, mouseX, mouseY) -> {
            if (button.field_230693_o_) {
                this.func_238652_a_(poseStack, EntryFilter.values()[this.buttonData[2]].getMessage(), mouseX, mouseY);
            }
        }));
    }

    public void updateList(boolean resetScroll) {
        this.updateList(this.searchTextField.func_146179_b(), resetScroll);
    }

    private void updateList(String query, boolean resetScroll) {
        this.list.replaceEntries(this.getConfigListEntries(query), resetScroll);
        this.onSearchFieldChanged(query.trim().isEmpty());
    }

    private List<Entry> getConfigListEntries(String query) {
        return this.getConfigListEntries(!(query = query.toLowerCase(Locale.ROOT).trim()).isEmpty() ? this.searchEntries : this.screenEntries, query);
    }

    List<Entry> getConfigListEntries(List<IEntryData> entries, String searchHighlight) {
        boolean empty = searchHighlight.isEmpty();
        return entries.stream().filter(data -> data.mayInclude(searchHighlight) && EntryFilter.values()[empty ? this.buttonData[1] : this.buttonData[2]].test((IEntryData)data, empty)).sorted(IEntryData.getSearchComparator(searchHighlight, this.buttonData[0] == 1)).map(entryData -> this.makeEntry((IEntryData)entryData, searchHighlight)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    void onSearchFieldChanged(boolean isEmpty) {
        this.reverseButton.field_230693_o_ = isEmpty;
        this.filterButton.field_230694_p_ = isEmpty;
        this.searchFilterButton.field_230694_p_ = !isEmpty;
    }

    public void func_231023_e_() {
        this.searchTextField.func_146178_a();
        if (this.activeTextField != null) {
            this.activeTextField.func_146178_a();
        }
        if (this.tooltipTicks < 10) {
            ++this.tooltipTicks;
        }
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        List<? extends IReorderingProcessor> lastTooltip = this.activeTooltip;
        this.activeTooltip = null;
        ScreenUtil.renderCustomBackground(this, this.background, 0);
        this.list.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.searchTextField.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.drawBaseTitle(poseStack);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != lastTooltip) {
            this.tooltipTicks = 0;
        }
        if (this.activeTooltip != null && this.tooltipTicks >= 10) {
            this.func_238654_b_(poseStack, this.activeTooltip, mouseX, mouseY);
        }
        this.func_231039_at__().forEach(o -> {
            if (o instanceof Button.ITooltip) {
                ((Button.ITooltip)o).onTooltip((Button)o, poseStack, mouseX, mouseY);
            }
        });
    }

    void drawBaseTitle(MatrixStack poseStack) {
        ConfigScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)(this.field_230708_k_ / 2), (int)7, (int)0xFFFFFF);
    }

    public abstract void func_231175_as__();

    void setActiveTooltip(@Nullable List<? extends IReorderingProcessor> activeTooltip) {
        this.activeTooltip = activeTooltip;
    }

    Entry makeEntry(IEntryData entryData, String searchHighlight) {
        if (entryData instanceof EntryData.CategoryEntryData) {
            return new CategoryEntry((EntryData.CategoryEntryData)entryData, searchHighlight);
        }
        if (entryData instanceof EntryData.ConfigEntryData) {
            Object currentValue = ((EntryData.ConfigEntryData)entryData).getCurrentValue();
            if (currentValue instanceof Boolean) {
                return new BooleanEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof Integer) {
                return new NumberEntry<Integer>((EntryData.ConfigEntryData)entryData, searchHighlight, Integer::parseInt);
            }
            if (currentValue instanceof Double) {
                return new NumberEntry<Double>((EntryData.ConfigEntryData)entryData, searchHighlight, Double::parseDouble);
            }
            if (currentValue instanceof Long) {
                return new NumberEntry<Long>((EntryData.ConfigEntryData)entryData, searchHighlight, Long::parseLong);
            }
            if (currentValue instanceof Enum) {
                return new EnumEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof String) {
                return new StringEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof List) {
                Object value = this.getListValue((List)((EntryData.ConfigEntryData)entryData).getDefaultValue(), (List)currentValue);
                try {
                    return this.makeListEntry(entryData, searchHighlight, value);
                }
                catch (RuntimeException e) {
                    ConfigMenusForge.LOGGER.warn("Unable to add list entry containing class type {}", (Object)(value != null ? value.getClass().getSimpleName() : "null"), (Object)e);
                    return null;
                }
            }
            ConfigMenusForge.LOGGER.warn("Unsupported config value of class type {}", (Object)currentValue.getClass().getSimpleName());
        }
        return null;
    }

    private ListEntry<?> makeListEntry(IEntryData entryData, String searchHighlight, Object value) throws RuntimeException {
        if (value instanceof Boolean) {
            return new ListEntry<Boolean>((EntryData.ConfigEntryData)entryData, searchHighlight, "Boolean", v -> {
                switch (v.toLowerCase(Locale.ROOT)) {
                    case "true": {
                        return true;
                    }
                    case "false": {
                        return false;
                    }
                }
                throw new IllegalArgumentException("unable to convert boolean value");
            });
        }
        if (value instanceof Integer) {
            return new ListEntry<Integer>((EntryData.ConfigEntryData)entryData, searchHighlight, "Integer", Integer::parseInt);
        }
        if (value instanceof Double) {
            return new ListEntry<Double>((EntryData.ConfigEntryData)entryData, searchHighlight, "Double", Double::parseDouble);
        }
        if (value instanceof Long) {
            return new ListEntry<Long>((EntryData.ConfigEntryData)entryData, searchHighlight, "Long", Long::parseLong);
        }
        if (value instanceof Enum) {
            return new EnumListEntry((EntryData.ConfigEntryData)entryData, searchHighlight, value.getClass());
        }
        if (value instanceof String) {
            return new ListEntry<String>((EntryData.ConfigEntryData)entryData, searchHighlight, "String", s -> {
                if (s.isEmpty()) {
                    throw new IllegalArgumentException("string must not be empty");
                }
                return s;
            });
        }
        return new DangerousListEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
    }

    @Nullable
    private Object getListValue(List<?> defaultValue, List<?> currentValue) {
        if (!defaultValue.isEmpty()) {
            return defaultValue.get(0);
        }
        if (!currentValue.isEmpty()) {
            return currentValue.get(0);
        }
        return null;
    }

    private class DangerousListEntry
    extends ListEntry<String> {
        public DangerousListEntry(EntryData.ConfigEntryData<List<String>> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "String", s -> {
                if (s.isEmpty()) {
                    throw new IllegalArgumentException("string must not be empty");
                }
                return s;
            });
        }

        @Override
        Screen makeEditScreen(String type, List<String> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<List<String>> onSave) {
            return ScreenUtil.makeConfirmationScreen(result -> {
                if (result) {
                    ConfigScreen.this.field_230706_i_.func_147108_a(super.makeEditScreen(type, currentValue, valueSpec, onSave));
                } else {
                    ConfigScreen.this.field_230706_i_.func_147108_a((Screen)ConfigScreen.this);
                }
            }, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.message.dangerous.title").func_240699_a_(TextFormatting.RED), (ITextComponent)new TranslationTextComponent("configmenusforge.gui.message.dangerous.text"), DialogTexts.field_240636_g_, DialogTexts.field_240637_h_, ConfigScreen.this.background);
        }
    }

    private class EnumListEntry
    extends ListEntry<Enum<?>> {
        public <T extends Enum<T>> EnumListEntry(EntryData.ConfigEntryData<List<Enum<?>>> configEntryData, String searchHighlight, Class<Enum<?>> clazz) {
            super(configEntryData, searchHighlight, "Enum", v -> Enum.valueOf(clazz, v));
        }

        @Override
        String listValueToString(Object value) {
            return value instanceof Enum ? ((Enum)value).name() : super.listValueToString(value);
        }
    }

    private class ListEntry<T>
    extends EditScreenEntry<List<T>> {
        private final Function<String, T> fromString;

        public ListEntry(EntryData.ConfigEntryData<List<T>> configEntryData, String searchHighlight, String type, Function<String, T> fromString) {
            super(configEntryData, searchHighlight, type);
            this.fromString = fromString;
        }

        @Override
        final String valueToString(List<T> value) {
            return "[" + value.stream().map(this::listValueToString).collect(Collectors.joining(", ")) + "]";
        }

        String listValueToString(Object value) {
            return value.toString();
        }

        @Override
        Screen makeEditScreen(String type, List<T> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<List<T>> onSave) {
            return new EditListScreen(ConfigScreen.this, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.list.edit", new Object[]{type}), ConfigScreen.this.background, currentValue.stream().map(this::listValueToString).collect(Collectors.toList()), input -> {
                try {
                    this.fromString.apply((String)input);
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }, list -> {
                List values = list.stream().map(this.fromString).collect(Collectors.toList());
                valueSpec.correct((Object)valueSpec);
                onSave.accept(values);
            });
        }
    }

    private class StringEntry
    extends EditScreenEntry<String> {
        public StringEntry(EntryData.ConfigEntryData<String> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "String");
        }

        @Override
        String valueToString(String value) {
            return value;
        }

        @Override
        Screen makeEditScreen(String type, String currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<String> onSave) {
            return new EditStringScreen(ConfigScreen.this, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.value.edit", new Object[]{type}), ConfigScreen.this.background, currentValue, arg_0 -> ((ForgeConfigSpec.ValueSpec)valueSpec).test(arg_0), onSave);
        }
    }

    private class EnumEntry
    extends EditScreenEntry<Enum<?>> {
        public EnumEntry(EntryData.ConfigEntryData<Enum<?>> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "Enum");
        }

        @Override
        String valueToString(Enum<?> value) {
            return ScreenUtil.formatText(value.name().toLowerCase(Locale.ROOT));
        }

        @Override
        Screen makeEditScreen(String type, Enum<?> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<Enum<?>> onSave) {
            return new EditEnumScreen(ConfigScreen.this, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.value.select", new Object[]{type}), ConfigScreen.this.background, currentValue, (Enum[])currentValue.getDeclaringClass().getEnumConstants(), arg_0 -> ((ForgeConfigSpec.ValueSpec)valueSpec).test(arg_0), onSave);
        }
    }

    private abstract class EditScreenEntry<T>
    extends ConfigEntry<T> {
        private final Button button;

        public EditScreenEntry(EntryData.ConfigEntryData<T> configEntryData, String searchHighlight, String type) {
            super(configEntryData, searchHighlight);
            this.button = new Button(10, 5, 44, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.edit"), button -> {
                try {
                    ConfigScreen.this.field_230706_i_.func_147108_a(this.makeEditScreen(type, configEntryData.getCurrentValue(), configEntryData.getValueSpec(), currentValue -> {
                        configEntryData.setCurrentValue(currentValue);
                        this.onConfigValueChanged(currentValue, false);
                    }));
                }
                catch (RuntimeException e) {
                    ConfigMenusForge.LOGGER.warn("Unable to handle list entry containing class type {}", (Object)type, (Object)e);
                    button.field_230693_o_ = false;
                }
            });
            this.func_231039_at__().add((Widget)this.button);
        }

        @Override
        abstract String valueToString(T var1);

        abstract Screen makeEditScreen(String var1, T var2, ForgeConfigSpec.ValueSpec var3, Consumer<T> var4);

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = entryLeft + rowWidth - 67;
            this.button.field_230691_m_ = entryTop;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    private class BooleanEntry
    extends ConfigEntry<Boolean> {
        private final Button button;

        public BooleanEntry(EntryData.ConfigEntryData<Boolean> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight);
            this.button = new Button(10, 5, 44, 20, DialogTexts.func_240638_a_((boolean)configEntryData.getCurrentValue()), button -> {
                boolean newValue = (Boolean)configEntryData.getCurrentValue() == false;
                configEntryData.setCurrentValue(newValue);
                this.onConfigValueChanged(newValue, false);
            });
            this.func_231039_at__().add((Widget)this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = entryLeft + rowWidth - 67;
            this.button.field_230691_m_ = entryTop;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onConfigValueChanged(Boolean newValue, boolean reset) {
            super.onConfigValueChanged(newValue, reset);
            this.button.func_238482_a_(DialogTexts.func_240638_a_((boolean)newValue));
        }
    }

    private class NumberEntry<T>
    extends ConfigEntry<T> {
        private final ConfigEditBox textField;

        public NumberEntry(EntryData.ConfigEntryData<T> configEntryData, String searchHighlight, Function<String, T> parser) {
            super(configEntryData, searchHighlight);
            this.textField = new ConfigEditBox(ConfigScreen.this.field_230712_o_, 0, 0, 42, 18, () -> ConfigScreen.this.activeTextField, activeTextField -> ConfigScreen.this.activeTextField = activeTextField);
            this.textField.func_212954_a(input -> {
                T number = null;
                try {
                    Object parsed = parser.apply((String)input);
                    if (configEntryData.getValueSpec().test(parsed)) {
                        number = (T)parsed;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (number != null) {
                    this.textField.markInvalid(false);
                    configEntryData.setCurrentValue(number);
                    this.onConfigValueChanged(number, false);
                } else {
                    this.textField.markInvalid(true);
                    configEntryData.resetCurrentValue();
                    this.resetButton.field_230693_o_ = true;
                }
            });
            this.textField.func_146180_a(configEntryData.getCurrentValue().toString());
            this.func_231039_at__().add((Widget)this.textField);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.textField.field_230690_l_ = entryLeft + rowWidth - 66;
            this.textField.field_230691_m_ = entryTop + 1;
            this.textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onConfigValueChanged(T newValue, boolean reset) {
            super.onConfigValueChanged(newValue, reset);
            if (reset) {
                this.textField.func_146180_a(newValue.toString());
            }
        }
    }

    private abstract class ConfigEntry<T>
    extends Entry {
        private final List<Widget> children;
        private final EntryData.ConfigEntryData<T> configEntryData;
        private final IReorderingProcessor visualTitle;
        final Button resetButton;

        public ConfigEntry(EntryData.ConfigEntryData<T> data, String searchHighlight) {
            super(data, searchHighlight);
            this.children = Lists.newArrayList();
            this.configEntryData = data;
            ITextProperties truncatedTitle = ScreenUtil.getTruncatedText(ConfigScreen.this.field_230712_o_, this.getTitle(), 190, Style.field_240709_b_);
            this.visualTitle = LanguageMap.func_74808_a().func_241870_a(truncatedTitle);
            List tooltip = ConfigScreen.this.field_230712_o_.func_238425_b_((ITextProperties)RESET_TOOLTIP, 200);
            this.resetButton = new IconButton(0, 0, 20, 20, 140, 0, ICONS_LOCATION, button -> {
                data.resetCurrentValue();
                this.onConfigValueChanged(data.getCurrentValue(), true);
                ConfigScreen.this.updateList(false);
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (button.field_230693_o_) {
                    ConfigScreen.this.setActiveTooltip(tooltip);
                }
            });
            this.resetButton.field_230693_o_ = data.mayResetValue();
            this.children.add((Widget)this.resetButton);
        }

        @Override
        void addLines(FontRenderer font, IEntryData data, String searchHighlight, List<ITextProperties> lines) {
            IFormattableTextComponent component = new StringTextComponent(data.getPath()).func_240699_a_(TextFormatting.YELLOW);
            lines.addAll(font.func_238420_b_().func_238362_b_((ITextProperties)component, 200, Style.field_240709_b_));
            String comment = data.getComment();
            if (comment != null && !comment.isEmpty()) {
                int i;
                List splitLines = font.func_238420_b_().func_238365_g_(comment, 200, Style.field_240709_b_);
                int rangeIndex = -1;
                for (i = 0; i < splitLines.size(); ++i) {
                    String text = ((ITextProperties)splitLines.get(i)).getString();
                    if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                    rangeIndex = i;
                    break;
                }
                if (rangeIndex != -1) {
                    for (i = rangeIndex; i < splitLines.size(); ++i) {
                        splitLines.set(i, new StringTextComponent(((ITextProperties)splitLines.get(i)).getString()).func_240699_a_(TextFormatting.GRAY));
                    }
                }
                lines.addAll(splitLines);
            }
            EntryData.ConfigEntryData configData = (EntryData.ConfigEntryData)data;
            lines.addAll(font.func_238420_b_().func_238362_b_((ITextProperties)new TranslationTextComponent("configmenusforge.gui.tooltip.default", new Object[]{this.valueToString(configData.getDefaultValue())}).func_240699_a_(TextFormatting.GRAY), 200, Style.field_240709_b_));
            if (searchHighlight != null && !searchHighlight.isEmpty()) {
                ITextComponent pathComponent = configData.getFullPath().stream().map(ScreenUtil::formatLabel).reduce((o1, o2) -> new StringTextComponent("").func_230529_a_(o1).func_240702_b_(" > ").func_230529_a_(o2)).orElse(StringTextComponent.field_240750_d_);
                lines.addAll(font.func_238420_b_().func_238362_b_((ITextProperties)new TranslationTextComponent("configmenusforge.gui.tooltip.path", new Object[]{pathComponent}).func_240699_a_(TextFormatting.GRAY), 200, Style.field_240709_b_));
            }
        }

        String valueToString(T value) {
            return value.toString();
        }

        public void onConfigValueChanged(T newValue, boolean reset) {
            this.resetButton.field_230693_o_ = this.configEntryData.mayResetValue();
        }

        public List<Widget> func_231039_at__() {
            return this.children;
        }

        @Override
        boolean isHovered(int mouseX, int mouseY) {
            return ConfigScreen.this.list != null && this.func_231047_b_(mouseX, mouseY) && mouseX < ConfigScreen.this.list.func_230968_n_() + ConfigScreen.this.list.func_230949_c_() - 67;
        }

        @Override
        public void func_230432_a_(MatrixStack poseStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int color = this.isHovered(mouseX, mouseY) ? 0xFFFF55 : 0xFFFFFF;
            ConfigScreen.this.field_230712_o_.func_238407_a_(poseStack, this.visualTitle, (float)entryLeft, (float)(entryTop + 6), color);
            this.resetButton.field_230690_l_ = entryLeft + rowWidth - 21;
            this.resetButton.field_230691_m_ = entryTop;
            this.resetButton.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
            super.func_230432_a_(poseStack, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        }
    }

    private class CategoryEntry
    extends Entry {
        private final Button button;

        public CategoryEntry(EntryData.CategoryEntryData data, String searchHighlight) {
            super(data, searchHighlight);
            this.button = new Button(10, 5, 260, 20, this.getTitle(), button -> {
                ConfigScreen.this.searchTextField.func_146180_a("");
                ConfigScreen.this.searchTextField.func_146195_b(false);
                ConfigScreen.this.field_230706_i_.func_147108_a((Screen)data.getScreen());
            });
        }

        @Override
        void addLines(FontRenderer font, IEntryData data, String searchHighlight, List<ITextProperties> lines) {
            String comment = data.getComment();
            if (comment != null && !comment.isEmpty()) {
                lines.addAll(font.func_238420_b_().func_238365_g_(comment, 200, Style.field_240709_b_));
            }
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.button);
        }

        @Override
        boolean isHovered(int mouseX, int mouseY) {
            return this.button.func_230449_g_();
        }

        @Override
        public void func_230432_a_(MatrixStack poseStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.field_230690_l_ = entryLeft - 1;
            this.button.field_230691_m_ = entryTop;
            this.button.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
            super.func_230432_a_(poseStack, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, selected, partialTicks);
        }
    }

    public abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
        private final ITextComponent title;
        @Nullable
        private final List<? extends IReorderingProcessor> tooltip;

        protected Entry(IEntryData data, String searchHighlight) {
            this.title = data.getDisplayTitle(searchHighlight);
            ArrayList lines = Lists.newArrayList();
            this.addLines(ConfigScreen.this.field_230712_o_, data, searchHighlight, lines);
            this.tooltip = lines.isEmpty() ? null : LanguageMap.func_74808_a().func_244260_a((List)lines);
        }

        public final ITextComponent getTitle() {
            return this.title;
        }

        abstract void addLines(FontRenderer var1, IEntryData var2, String var3, List<ITextProperties> var4);

        @Nullable
        public final List<? extends IReorderingProcessor> getTooltip() {
            return this.tooltip;
        }

        abstract boolean isHovered(int var1, int var2);

        public void func_230432_a_(MatrixStack poseStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            if (this.isHovered(mouseX, mouseY)) {
                ConfigScreen.this.setActiveTooltip(this.tooltip);
            }
        }
    }

    public class ConfigList
    extends CustomBackgroundContainerObjectSelectionList<Entry> {
        public ConfigList(List<Entry> entries) {
            super(ConfigScreen.this.field_230706_i_, ConfigScreen.this.background, ConfigScreen.this.field_230708_k_, ConfigScreen.this.field_230709_l_, 50, ConfigScreen.this.field_230709_l_ - 36, 24);
            entries.forEach(arg_0 -> ((ConfigList)this).func_230513_b_(arg_0));
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 144;
        }

        public int func_230949_c_() {
            return 260;
        }

        protected void replaceEntries(Collection<Entry> entries, boolean resetScroll) {
            super.func_230942_a_(entries);
            if (resetScroll) {
                this.func_230932_a_(0.0);
            }
        }

        @Override
        public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
            Entry entry;
            super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
            if (this.func_231047_b_(mouseX, mouseY) && mouseX < ConfigScreen.this.list.func_230968_n_() + ConfigScreen.this.list.func_230949_c_() - 67 && (entry = (Entry)((Object)this.getHovered())) != null) {
                ConfigScreen.this.setActiveTooltip(entry.getTooltip());
            }
        }
    }

    private static enum EntryFilter {
        ALL(6, "configmenusforge.gui.tooltip.showing.all", data -> true),
        ENTRIES(2, "configmenusforge.gui.tooltip.showing.entries", iEntryData -> !iEntryData.category(), true),
        CATEGORIES(8, "configmenusforge.gui.tooltip.showing.categories", IEntryData::category, true),
        EDITED(3, "configmenusforge.gui.tooltip.showing.edited", iEntryData -> !iEntryData.mayDiscardChanges()),
        RESETTABLE(7, "configmenusforge.gui.tooltip.showing.resettable", IEntryData::mayResetValue);

        private static final String SHOWING_TRANSLATION_KEY = "configmenusforge.gui.tooltip.showing";
        private static final int[] DEFAULT_FILTERS_INDICES;
        private final int textureX;
        private final ITextComponent message;
        private final Predicate<IEntryData> predicate;
        private final boolean searchOnly;

        private EntryFilter(int textureIndex, String translationKey, Predicate<IEntryData> predicate) {
            this(textureIndex, translationKey, predicate, false);
        }

        private EntryFilter(int textureIndex, String translationKey, Predicate<IEntryData> predicate, boolean searchOnly) {
            this.textureX = textureIndex * 20;
            this.message = new TranslationTextComponent(SHOWING_TRANSLATION_KEY, new Object[]{new TranslationTextComponent(translationKey)});
            this.predicate = predicate;
            this.searchOnly = searchOnly;
        }

        public int getTextureX() {
            return this.textureX;
        }

        public ITextComponent getMessage() {
            return this.message;
        }

        public boolean test(IEntryData data, boolean empty) {
            return this.predicate.test(data) || empty && data.category();
        }

        private boolean searchOnly() {
            return this.searchOnly;
        }

        public static int cycle(int index, boolean search, boolean reversed) {
            if (!search) {
                for (int i = 0; i < DEFAULT_FILTERS_INDICES.length; ++i) {
                    if (DEFAULT_FILTERS_INDICES[i] != index) continue;
                    index = i;
                    break;
                }
            }
            int length = search ? EntryFilter.values().length : DEFAULT_FILTERS_INDICES.length;
            int amount = reversed ? -1 : 1;
            index = (index + amount + length) % length;
            return search ? index : DEFAULT_FILTERS_INDICES[index];
        }

        static {
            DEFAULT_FILTERS_INDICES = Stream.of(EntryFilter.values()).filter(entryFilter -> !entryFilter.searchOnly()).mapToInt(Enum::ordinal).toArray();
        }
    }

    private static class Sub
    extends ConfigScreen {
        private Sub(ConfigScreen lastScreen, ITextComponent title, UnmodifiableConfig config) {
            super(lastScreen, title, lastScreen.background, config, lastScreen.valueToData, lastScreen.buttonData);
        }

        @Override
        protected void func_231160_c_() {
            super.func_231160_c_();
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 28, 200, 20, DialogTexts.field_240637_h_, button -> this.func_231175_as__()));
            this.makeNavigationButtons().forEach(arg_0 -> ((Sub)this).func_230480_a_(arg_0));
            this.onSearchFieldChanged(this.searchTextField.func_146179_b().trim().isEmpty());
        }

        private List<Button> makeNavigationButtons() {
            List<Screen> lastScreens = this.getLastScreens();
            int maxSize = 5;
            LinkedList buttons = Lists.newLinkedList();
            int size = Math.min(5, lastScreens.size());
            for (int i = 0; i < size; ++i) {
                Screen screen = lastScreens.get(size - 1 - i);
                final boolean otherScreen = screen != this;
                ITextComponent title = i == 0 && lastScreens.size() > 5 ? new StringTextComponent(". . .") : screen.func_231171_q_();
                buttons.add(new Button(0, 1, this.field_230712_o_.func_238414_a_((ITextProperties)title) + 4, 20, title, button -> {
                    if (otherScreen) {
                        this.field_230706_i_.func_147108_a(screen);
                    }
                }, (button, poseStack, mouseX, mouseY) -> {
                    if (otherScreen && button.field_230693_o_) {
                        this.func_238652_a_(poseStack, DialogTexts.field_240637_h_, mouseX, mouseY + 24);
                    }
                }){

                    public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
                        int color = otherScreen && this.func_230449_g_() ? 0xFFFF55 : 0xFFFFFF;
                        1.func_238472_a_((MatrixStack)poseStack, (FontRenderer)field_230712_o_, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)color);
                        if (this.func_230449_g_()) {
                            this.func_230443_a_(poseStack, mouseX, mouseY);
                        }
                    }

                    public void func_230988_a_(SoundHandler soundManager) {
                        if (otherScreen) {
                            super.func_230988_a_(soundManager);
                        }
                    }
                });
                if (i >= size - 1) continue;
                buttons.add(new Button(0, 1, this.field_230712_o_.func_78256_a(">") + 4, 20, (ITextComponent)new StringTextComponent(">"), button -> {}){

                    public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
                        2.func_238472_a_((MatrixStack)poseStack, (FontRenderer)field_230712_o_, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)0xFFFFFF);
                    }

                    public void func_230988_a_(SoundHandler soundManager) {
                    }
                });
            }
            this.setButtonPosX(buttons);
            return buttons;
        }

        private List<Screen> getLastScreens() {
            Sub lastScreen = this;
            LinkedList lastScreens = Lists.newLinkedList();
            while (lastScreen instanceof ConfigScreen) {
                lastScreens.add(lastScreen);
                lastScreen = ((ConfigScreen)lastScreen).lastScreen;
            }
            return lastScreens;
        }

        private void setButtonPosX(List<Button> buttons) {
            int posX = (this.field_230708_k_ - buttons.stream().mapToInt(Widget::func_230998_h_).sum()) / 2;
            for (Button navigationButton : buttons) {
                navigationButton.field_230690_l_ = posX;
                posX += navigationButton.func_230998_h_();
            }
        }

        @Override
        void drawBaseTitle(MatrixStack poseStack) {
        }

        @Override
        public void func_231175_as__() {
            if (!this.searchTextField.func_146179_b().isEmpty()) {
                this.searchTextField.func_146180_a("");
            } else {
                this.field_230706_i_.func_147108_a(this.lastScreen);
            }
        }
    }

    private static class Main
    extends ConfigScreen {
        private final Runnable onSave;
        private Button doneButton;
        private Button cancelButton;
        private Button backButton;

        private Main(Screen lastScreen, ITextComponent title, ResourceLocation background, UnmodifiableConfig config, Map<Object, IEntryData> valueToData, Runnable onSave) {
            super(lastScreen, title, background, config, valueToData, new int[3]);
            this.onSave = onSave;
        }

        @Override
        protected void func_231160_c_() {
            super.func_231160_c_();
            this.doneButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240632_c_, button -> {
                this.valueToData.values().forEach(IEntryData::saveConfigValue);
                this.onSave.run();
                this.field_230706_i_.func_147108_a(this.lastScreen);
            }));
            this.cancelButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, button -> this.func_231175_as__()));
            this.backButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 28, 200, 20, DialogTexts.field_240637_h_, button -> this.searchTextField.func_146180_a("")));
            this.onSearchFieldChanged(this.searchTextField.func_146179_b().trim().isEmpty());
        }

        @Override
        void onSearchFieldChanged(boolean empty) {
            super.onSearchFieldChanged(empty);
            this.doneButton.field_230694_p_ = empty;
            this.cancelButton.field_230694_p_ = empty;
            this.backButton.field_230694_p_ = !empty;
        }

        @Override
        public void func_231175_as__() {
            if (!this.searchTextField.func_146179_b().isEmpty()) {
                this.searchTextField.func_146180_a("");
            } else {
                Object confirmScreen = this.valueToData.values().stream().allMatch(IEntryData::mayDiscardChanges) ? this.lastScreen : ScreenUtil.makeConfirmationScreen(result -> {
                    if (result) {
                        this.valueToData.values().forEach(IEntryData::discardCurrentValue);
                        this.field_230706_i_.func_147108_a(this.lastScreen);
                    } else {
                        this.field_230706_i_.func_147108_a((Screen)this);
                    }
                }, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.message.discard"), StringTextComponent.field_240750_d_, this.background);
                this.field_230706_i_.func_147108_a(confirmScreen);
            }
        }
    }
}

