/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import fuzs.configmenusforge.client.gui.components.CustomBackgroundContainerObjectSelectionList;
import fuzs.configmenusforge.client.gui.screens.ConfigScreen;
import fuzs.configmenusforge.client.gui.util.ScreenUtil;
import fuzs.configmenusforge.client.gui.widget.ConfigEditBox;
import fuzs.configmenusforge.client.gui.widget.IconButton;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.mutable.MutableObject;

public class EditListScreen
extends Screen {
    private final Screen lastScreen;
    private final ResourceLocation background;
    private final List<MutableObject<String>> values;
    private final Predicate<String> validator;
    private final Consumer<List<String>> onSave;
    private final Set<EditEntry> invalidEntries = Sets.newHashSet();
    private EditList list;
    private Button doneButton;
    @Nullable
    private ConfigEditBox activeTextField;
    @Nullable
    private List<? extends IReorderingProcessor> activeTooltip;
    private int tooltipTicks;

    public EditListScreen(Screen lastScreen, ITextComponent title, ResourceLocation background, List<String> listValue, Predicate<String> validator, Consumer<List<String>> onSave) {
        super(title);
        this.lastScreen = lastScreen;
        this.background = background;
        this.values = listValue.stream().map(MutableObject::new).collect(Collectors.toList());
        this.validator = validator;
        this.onSave = onSave;
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.lastScreen);
    }

    protected void func_231160_c_() {
        this.list = new EditList(this.values);
        this.func_230481_d_((IGuiEventListener)this.list);
        this.doneButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240632_c_, button -> {
            this.onSave.accept(this.values.stream().map(MutableObject::getValue).collect(Collectors.toList()));
            this.field_230706_i_.func_147108_a(this.lastScreen);
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, button -> this.field_230706_i_.func_147108_a(this.lastScreen)));
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        List<? extends IReorderingProcessor> lastTooltip = this.activeTooltip;
        this.activeTooltip = null;
        ScreenUtil.renderCustomBackground(this, this.background, 0);
        this.list.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        EditListScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)14, (int)0xFFFFFF);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != lastTooltip) {
            this.tooltipTicks = 0;
        }
        if (this.activeTooltip != null && this.tooltipTicks >= 10) {
            this.func_238654_b_(poseStack, this.activeTooltip, mouseX, mouseY);
        }
    }

    public void func_231023_e_() {
        if (this.activeTextField != null) {
            this.activeTextField.func_146178_a();
        }
        if (this.tooltipTicks < 10) {
            ++this.tooltipTicks;
        }
    }

    private void updateDoneButton() {
        if (this.doneButton != null) {
            this.doneButton.field_230693_o_ = this.invalidEntries.isEmpty();
        }
    }

    void markInvalid(EditEntry entry) {
        this.invalidEntries.add(entry);
        this.updateDoneButton();
    }

    void clearInvalid(EditEntry entry) {
        this.invalidEntries.remove((Object)entry);
        this.updateDoneButton();
    }

    private class EditEntry
    extends EditListEntry {
        private final MutableObject<String> holder;
        private final ConfigEditBox textField;
        private final Button deleteButton;

        public EditEntry(EditList list, MutableObject<String> holder) {
            this(list, holder, false);
        }

        public EditEntry(EditList list, MutableObject<String> holder, boolean withFocus) {
            this.holder = holder;
            this.textField = new ConfigEditBox(EditListScreen.this.field_230712_o_, 0, 0, 236, 18, () -> EditListScreen.this.activeTextField, activeTextField -> EditListScreen.this.activeTextField = activeTextField){

                @Override
                public void func_146195_b(boolean focused) {
                    super.func_146195_b(focused);
                    EditListScreen.this.activeTextField = focused ? this : null;
                }
            };
            this.textField.func_212954_a(input -> {
                if (EditListScreen.this.validator.test(input)) {
                    this.textField.markInvalid(false);
                    this.holder.setValue(input);
                    EditListScreen.this.clearInvalid(this);
                } else {
                    this.textField.markInvalid(true);
                    EditListScreen.this.markInvalid(this);
                }
            });
            this.textField.func_146180_a((String)holder.getValue());
            this.textField.func_146195_b(withFocus);
            List tooltip = ((EditListScreen)EditListScreen.this).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configmenusforge.gui.tooltip.remove"), 200);
            this.deleteButton = new IconButton(0, 0, 20, 20, 100, 0, ConfigScreen.ICONS_LOCATION, button -> {
                EditListScreen.this.values.remove(holder);
                list.removeEntry(this);
                EditListScreen.this.clearInvalid(this);
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (button.field_230693_o_) {
                    EditListScreen.this.activeTooltip = tooltip;
                }
            });
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.textField.field_230690_l_ = entryLeft;
            this.textField.field_230691_m_ = entryTop + 1;
            this.textField.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
            this.deleteButton.field_230690_l_ = entryLeft + rowWidth - 21;
            this.deleteButton.field_230691_m_ = entryTop;
            this.deleteButton.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)((Object)this.textField), (Object)this.deleteButton);
        }
    }

    private class AddEntry
    extends EditListEntry {
        private final Button addButton;

        public AddEntry(EditList list, List<MutableObject<String>> values) {
            List tooltip = ((EditListScreen)EditListScreen.this).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configmenusforge.gui.tooltip.add"), 200);
            this.addButton = new IconButton(0, 0, 20, 20, 80, 0, ConfigScreen.ICONS_LOCATION, button -> {
                MutableObject holder = new MutableObject((Object)"");
                values.add(holder);
                list.addEntry(list.func_231039_at__().size() - 1, new EditEntry(list, (MutableObject<String>)holder, true));
            }, (button, matrixStack, mouseX, mouseY) -> {
                if (button.field_230693_o_) {
                    EditListScreen.this.activeTooltip = tooltip;
                }
            });
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.addButton.field_230690_l_ = entryLeft + rowWidth - 21;
            this.addButton.field_230691_m_ = entryTop;
            this.addButton.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.addButton);
        }
    }

    public static abstract class EditListEntry
    extends AbstractOptionList.Entry<EditListEntry> {
    }

    public class EditList
    extends CustomBackgroundContainerObjectSelectionList<EditListEntry> {
        public EditList(List<MutableObject<String>> values) {
            super(EditListScreen.this.field_230706_i_, EditListScreen.this.background, EditListScreen.this.field_230708_k_, EditListScreen.this.field_230709_l_, 36, EditListScreen.this.field_230709_l_ - 36, 24);
            values.forEach(value -> this.func_230513_b_((AbstractList.AbstractListEntry)new EditEntry(this, (MutableObject<String>)value)));
            this.func_230513_b_((AbstractList.AbstractListEntry)new AddEntry(this, values));
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 144;
        }

        public int func_230949_c_() {
            return 260;
        }

        protected int addEntry(int index, EditListEntry entry) {
            this.func_231039_at__().add(index, entry);
            return this.func_231039_at__().size() - 1;
        }

        protected boolean removeEntry(EditListEntry entry) {
            return super.func_230956_e_((AbstractList.AbstractListEntry)entry);
        }
    }
}

