/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import fuzs.configmenusforge.ConfigMenusForge;
import fuzs.configmenusforge.client.gui.components.ConfigSelectionList;
import fuzs.configmenusforge.client.gui.util.ScreenUtil;
import fuzs.configmenusforge.client.gui.widget.AnimatedIconButton;
import fuzs.configmenusforge.client.util.ServerConfigUploader;
import fuzs.configmenusforge.config.data.IEntryData;
import fuzs.configmenusforge.lib.core.ModLoaderEnvironment;
import fuzs.configmenusforge.lib.network.NetworkHandler;
import fuzs.configmenusforge.network.client.message.C2SAskPermissionsMessage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FileUtils;

public class SelectConfigScreen
extends Screen {
    private final Screen lastScreen;
    private final ResourceLocation background;
    private final ITextComponent displayName;
    private final Map<ModConfig, Map<Object, IEntryData>> configs;
    private List<IReorderingProcessor> activeTooltip;
    private TextFieldWidget searchBox;
    private ConfigSelectionList list;
    private Button openButton;
    private Button restoreButton;
    private Button copyButton;
    private Button fileButton;
    private AnimatedIconButton tinyJumperButton;
    private boolean serverPermissions;

    public SelectConfigScreen(Screen lastScreen, ITextComponent displayName, ResourceLocation optionsBackground, Set<ModConfig> configs) {
        super((ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.title", new Object[]{displayName}));
        this.lastScreen = lastScreen;
        this.displayName = displayName;
        this.background = optionsBackground;
        this.configs = (Map)configs.stream().collect(Collectors.collectingAndThen(Collectors.toMap(Function.identity(), IEntryData::makeValueToDataMap), ImmutableMap::copyOf));
        this.initServerPermissions();
    }

    public void func_231023_e_() {
        this.searchBox.func_146178_a();
        this.tinyJumperButton.func_231023_e_();
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.searchBox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 121, 22, 242, 20, this.searchBox, StringTextComponent.field_240750_d_){

            public boolean func_231044_a_(double mouseX, double mouseY, int button) {
                if (this.func_146176_q() && button == 1) {
                    this.func_146180_a("");
                }
                return super.func_231044_a_(mouseX, mouseY, button);
            }
        };
        this.searchBox.func_212954_a(query -> this.list.refreshList((String)query));
        this.func_230481_d_((IGuiEventListener)this.searchBox);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240632_c_, button -> this.func_231175_as__()));
        this.openButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50 - 104, this.field_230709_l_ - 52, 100, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.edit"), button1 -> {
            ConfigSelectionList.ConfigListEntry selected1 = (ConfigSelectionList.ConfigListEntry)this.list.func_230958_g_();
            if (selected1 != null) {
                selected1.openConfig();
            }
        }));
        this.restoreButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, this.field_230709_l_ - 52, 100, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.restore"), button1 -> {
            ConfigSelectionList.ConfigListEntry selected1 = (ConfigSelectionList.ConfigListEntry)this.list.func_230958_g_();
            if (selected1 != null) {
                ConfirmScreen confirmScreen = ScreenUtil.makeConfirmationScreen(result1 -> {
                    if (result1) {
                        ModConfig config = selected1.getConfig();
                        this.getValueToDataMap(config).values().forEach(data -> {
                            data.resetCurrentValue();
                            data.saveConfigValue();
                        });
                        ServerConfigUploader.saveAndUpload(config);
                    }
                    this.field_230706_i_.func_147108_a((Screen)this);
                }, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.message.restore"), StringTextComponent.field_240750_d_, this.background);
                this.field_230706_i_.func_147108_a((Screen)confirmScreen);
            }
        }));
        this.copyButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50 + 104, this.field_230709_l_ - 52, 100, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.copy"), button -> {
            ConfigSelectionList.ConfigListEntry selected = (ConfigSelectionList.ConfigListEntry)this.list.func_230958_g_();
            if (selected != null) {
                ModConfig config = selected.getConfig();
                Path destination = ModLoaderEnvironment.getGameDir().resolve(FMLConfig.defaultConfigPath()).resolve(config.getFileName());
                this.field_230706_i_.func_147108_a((Screen)ScreenUtil.makeConfirmationScreen(result -> {
                    if (result) {
                        try {
                            if (!Files.exists(destination, new LinkOption[0])) {
                                FileUtils.getOrCreateDirectory((Path)destination.getParent(), (String)String.format("%s default config", config.getFileName()));
                                Files.createFile(destination, new FileAttribute[0]);
                            }
                            TomlFormat.instance().createWriter().write((UnmodifiableConfig)config.getConfigData(), destination, WritingMode.REPLACE);
                            ConfigMenusForge.LOGGER.info("successfully copied {} to default config folder", (Object)config.getFileName());
                        }
                        catch (Exception e) {
                            ConfigMenusForge.LOGGER.error("failed to copy {} to default config folder", (Object)config.getFileName(), (Object)e);
                        }
                    }
                    this.field_230706_i_.func_147108_a((Screen)this);
                }, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.message.copy.title"), (ITextComponent)(Files.exists(destination, new LinkOption[0]) ? new TranslationTextComponent("configmenusforge.gui.message.copy.warning").func_240699_a_(TextFormatting.RED) : StringTextComponent.field_240750_d_), this.background));
            }
        }));
        this.fileButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 28, 150, 20, (ITextComponent)new TranslationTextComponent("configmenusforge.gui.select.open"), button -> {
            ConfigSelectionList.ConfigListEntry selected = (ConfigSelectionList.ConfigListEntry)this.list.func_230958_g_();
            if (selected != null) {
                Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, selected.getConfig().getFullPath().toAbsolutePath().toString()));
                this.func_230455_a_(style);
            }
        }));
        this.updateButtonStatus(false);
        this.list = new ConfigSelectionList(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 50, this.field_230709_l_ - 60, 36, this.searchBox.func_146179_b());
        this.func_230481_d_((IGuiEventListener)this.list);
        this.tinyJumperButton = (AnimatedIconButton)this.func_230480_a_((Widget)ScreenUtil.makeModPageButton(this.field_230708_k_ / 2 + 126, 22, this.field_230712_o_, arg_0 -> ((SelectConfigScreen)this).func_230455_a_(arg_0), (arg_0, arg_1, arg_2, arg_3) -> ((SelectConfigScreen)this).func_238654_b_(arg_0, arg_1, arg_2, arg_3)));
        this.func_212928_a((IGuiEventListener)this.searchBox);
    }

    public boolean func_231046_a_(int i, int j, int k) {
        return super.func_231046_a_(i, j, k) || this.searchBox.func_231046_a_(i, j, k);
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.lastScreen);
    }

    public boolean func_231042_a_(char c, int i) {
        return this.searchBox.func_231042_a_(c, i);
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        ScreenUtil.renderCustomBackground(this, this.background, 0);
        this.list.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.searchBox.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        SelectConfigScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)7, (int)0xFFFFFF);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != null) {
            this.func_238654_b_(poseStack, this.activeTooltip, mouseX, mouseY);
        }
    }

    public void updateButtonStatus(boolean active) {
        if (this.list != null && active) {
            ConfigSelectionList.ConfigListEntry selected = (ConfigSelectionList.ConfigListEntry)this.list.func_230958_g_();
            this.openButton.field_230693_o_ = true;
            this.restoreButton.field_230693_o_ = selected.mayResetValue();
            this.fileButton.field_230693_o_ = !selected.onMultiplayerServer();
            this.copyButton.field_230693_o_ = true;
        } else {
            this.openButton.field_230693_o_ = false;
            this.restoreButton.field_230693_o_ = false;
            this.fileButton.field_230693_o_ = false;
            this.copyButton.field_230693_o_ = false;
        }
    }

    public void setActiveTooltip(List<IReorderingProcessor> list) {
        this.activeTooltip = list;
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public Set<ModConfig> getConfigs() {
        return this.configs.keySet();
    }

    public Map<Object, IEntryData> getValueToDataMap(ModConfig config) {
        return this.configs.get(config);
    }

    private void initServerPermissions() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.func_147114_u() != null) {
            if (minecraft.func_71387_A()) {
                this.serverPermissions = true;
            } else {
                NetworkHandler.INSTANCE.sendToServer(new C2SAskPermissionsMessage());
            }
        }
    }

    public boolean getServerPermissions() {
        return this.serverPermissions;
    }

    public void setServerPermissions() {
        this.serverPermissions = true;
    }
}

