/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.handler;

import fuzs.configmenusforge.client.handler.ConfigScreenFactory;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class ConfigFactoryHandler {
    public static void registerConfigFactories() {
        ModList.get().getMods().stream().map(ModInfo::getModId).map(arg_0 -> ((ModList)ModList.get()).getModContainerById(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(container -> {
            if (container.getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).isPresent()) {
                return;
            }
            ResourceLocation background = Optional.ofNullable(container.getModInfo() instanceof ModInfo ? (ModInfo)container.getModInfo() : null).flatMap(ConfigFactoryHandler::getCustomBackground).orElse(Screen.field_230663_f_);
            ConfigScreenFactory.createConfigScreen(container.getModId(), container.getModInfo().getDisplayName(), background).ifPresent(configScreen -> container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> (Screen)configScreen.apply(screen)));
        });
    }

    public static void registerMinecraftConfig() {
        ModList.get().getModContainerById("minecraft").ifPresent(container -> container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new OptionsScreen(screen, Minecraft.func_71410_x().field_71474_y)));
    }

    private static Optional<ResourceLocation> getCustomBackground(ModInfo modInfo) {
        Optional<ResourceLocation> configuredBackground = Optional.ofNullable((String)modInfo.getModProperties().get("configuredBackground")).map(ResourceLocation::new);
        if (configuredBackground.isPresent()) {
            return configuredBackground;
        }
        return modInfo.getConfigElement(new String[]{"configBackground"}).map(ResourceLocation::new);
    }
}

