/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.client.util;

import com.electronwill.nightconfig.core.CommentedConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class ReflectionHelper {
    public static final Field FILE_MAP_FIELD = ReflectionHelper.getDeclaredField(ConfigTracker.class, "fileMap");
    public static final Field CONFIG_SETS_FIELD = ReflectionHelper.getDeclaredField(ConfigTracker.class, "configSets");
    public static final Method SET_CONFIG_DATA_METHOD = ReflectionHelper.getDeclaredMethod(ModConfig.class, "setConfigData", CommentedConfig.class);
    public static final Method FIRE_EVENT_METHOD = ReflectionHelper.getDeclaredMethod(ModConfig.class, "fireEvent", ModConfig.ModConfigEvent.class);
    public static final Constructor<ModConfig.Reloading> MOD_CONFIG_RELOADING_CONSTRUCTOR = ReflectionHelper.getDeclaredConstructor(ModConfig.Reloading.class, ModConfig.class);

    private static Field getDeclaredField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static <T> Constructor<T> getDeclaredConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Optional<T> get(@Nullable Field field, Object instance) {
        if (field != null) {
            try {
                return Optional.of(field.get(instance));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static <T> Optional<T> invoke(@Nullable Method method, Object instance, Object ... args) {
        if (method != null) {
            try {
                return Optional.ofNullable(method.invoke(instance, args));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static <T> Optional<T> newInstance(@Nullable Constructor<T> constructor, Object ... args) {
        if (constructor != null) {
            try {
                return Optional.of(constructor.newInstance(args));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

