/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.config.data;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.configmenusforge.client.gui.data.EntryData;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public interface IEntryData {
    public String getPath();

    @Nullable
    public String getComment();

    public ITextComponent getTitle();

    default public ITextComponent getDisplayTitle(String searchHighlight) {
        List<Integer> indices;
        if (searchHighlight != null && !searchHighlight.isEmpty() && !(indices = this.getSearchIndices(this.getSearchableTitle(), searchHighlight)).isEmpty()) {
            return this.getColoredTitle(this.getTitle().getString(), searchHighlight.length(), indices);
        }
        return this.getTitle();
    }

    default public ITextComponent getColoredTitle(String title, int length, List<Integer> indices) {
        IFormattableTextComponent component = new StringTextComponent(title.substring(0, indices.get(0))).func_240699_a_(TextFormatting.GRAY);
        int indicesSize = indices.size();
        for (int i = 0; i < indicesSize; ++i) {
            int start = indices.get(i);
            int end = start + length;
            component.func_230529_a_((ITextComponent)new StringTextComponent(title.substring(start, end)).func_240699_a_(TextFormatting.WHITE));
            int j = i;
            int nextStart = ++j < indicesSize ? indices.get(j).intValue() : title.length();
            component.func_230529_a_((ITextComponent)new StringTextComponent(title.substring(end, nextStart)).func_240699_a_(TextFormatting.GRAY));
        }
        return component;
    }

    default public List<Integer> getSearchIndices(String title, String query) {
        LinkedList indices = Lists.newLinkedList();
        if (!query.isEmpty()) {
            int index = title.indexOf(query);
            while (index >= 0) {
                indices.add(index);
                index = title.indexOf(query, index + 1);
            }
        }
        return indices;
    }

    default public String getSearchableTitle() {
        return this.getTitle().getString().toLowerCase(Locale.ROOT);
    }

    default public boolean mayInclude(String searchHighlight) {
        return searchHighlight == null || searchHighlight.isEmpty() || this.getSearchableTitle().contains(searchHighlight);
    }

    public boolean mayResetValue();

    public boolean mayDiscardChanges();

    public void resetCurrentValue();

    public void discardCurrentValue();

    public void saveConfigValue();

    public boolean category();

    public static Comparator<IEntryData> getDefaultComparator(boolean reversed) {
        Comparator<IEntryData> defaultComparator = Comparator.comparing(o -> o.getTitle().getString());
        return Comparator.comparing(IEntryData::category).reversed().thenComparing(reversed ? defaultComparator.reversed() : defaultComparator);
    }

    public static Comparator<IEntryData> getSearchComparator(String searchHighlight, boolean reversed) {
        if (searchHighlight != null && !searchHighlight.isEmpty()) {
            return Comparator.comparingInt(o -> o.getSearchableTitle().indexOf(searchHighlight)).thenComparing(IEntryData.getDefaultComparator(false));
        }
        return IEntryData.getDefaultComparator(reversed);
    }

    public static Map<Object, IEntryData> makeValueToDataMap(ModConfig config) {
        if (IEntryData.checkInvalid(config)) {
            return ImmutableMap.of();
        }
        HashMap allData = Maps.newHashMap();
        ForgeConfigSpec spec = config.getSpec();
        IEntryData.makeValueToDataMap(spec, spec.getValues(), config.getConfigData(), allData);
        return ImmutableMap.copyOf((Map)allData);
    }

    public static boolean checkInvalid(ModConfig config) {
        return config.getConfigData() == null || config.getSpec() == null || !config.getSpec().isLoaded();
    }

    public static void makeValueToDataMap(ForgeConfigSpec spec, UnmodifiableConfig values, CommentedConfig comments, Map<Object, IEntryData> allData) {
        values.valueMap().forEach((path, value) -> {
            if (value instanceof UnmodifiableConfig) {
                UnmodifiableConfig category = (UnmodifiableConfig)value;
                EntryData.CategoryEntryData data = new EntryData.CategoryEntryData((String)path, category, comments.getComment(path));
                allData.put(category, data);
                IEntryData.makeValueToDataMap(spec, category, (CommentedConfig)comments.valueMap().get(path), allData);
            } else if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                EntryData.ConfigEntryData data = new EntryData.ConfigEntryData((String)path, configValue, (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath()));
                allData.put(configValue, data);
            }
        });
    }
}

