/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.lib.core;

import fuzs.configmenusforge.lib.core.ModLoaderEnvironment;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;

public class EnvTypeExecutor {
    @Nullable
    public static <T> T callWhenOn(Dist envType, Supplier<Callable<T>> toRun) {
        if (ModLoaderEnvironment.isEnvironmentType(envType)) {
            try {
                return toRun.get().call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void runWhenOn(Dist envType, Supplier<Runnable> toRun) {
        if (ModLoaderEnvironment.isEnvironmentType(envType)) {
            toRun.get().run();
        }
    }

    public static <T> T runForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        switch (ModLoaderEnvironment.getEnvironmentType()) {
            case CLIENT: {
                return clientTarget.get().get();
            }
            case DEDICATED_SERVER: {
                return serverTarget.get().get();
            }
        }
        throw new IllegalArgumentException();
    }
}

