/*
 * Decompiled with CFR 0.152.
 */
package fuzs.configmenusforge.lib.network;

import fuzs.configmenusforge.ConfigMenusForge;
import fuzs.configmenusforge.lib.network.message.Message;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public enum NetworkHandler {
    INSTANCE;

    private static final String PROTOCOL_VERSION;
    public static final SimpleChannel CHANNEL;
    private static final AtomicInteger DISCRIMINATOR;

    public <T extends Message> void register(Class<T> clazz, Supplier<T> supplier, NetworkDirection direction) {
        BiConsumer<Message, PacketBuffer> encode = Message::write;
        Function<PacketBuffer, Message> decode = buf -> {
            Message message = (Message)supplier.get();
            message.read((PacketBuffer)buf);
            return message;
        };
        BiConsumer<Message, Supplier> handle = (msg, ctxSup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSup.get();
            LogicalSide receptionSide = direction.getReceptionSide();
            if (ctx.getDirection().getReceptionSide() != receptionSide) {
                throw new IllegalStateException(String.format("Received message on wrong side, expected %s, was %s", receptionSide, ctx.getDirection().getReceptionSide()));
            }
            Object player = receptionSide.isClient() ? ConfigMenusForge.PROXY.getClientPlayer() : ctx.getSender();
            ctx.enqueueWork(() -> NetworkHandler.lambda$null$2(msg, (PlayerEntity)player, receptionSide));
            ctx.setPacketHandled(true);
        };
        CHANNEL.registerMessage(DISCRIMINATOR.getAndIncrement(), clazz, encode, decode, handle);
    }

    public void sendToServer(Message message) {
        Objects.requireNonNull(Minecraft.func_71410_x().func_147114_u(), "Cannot send packets when not in game!");
        Minecraft.func_71410_x().func_147114_u().func_147297_a(NetworkHandler.toServerboundPacket(message));
    }

    public void sendTo(Message message, ServerPlayerEntity player) {
        player.field_71135_a.func_147359_a(NetworkHandler.toClientboundPacket(message));
    }

    public void sendToAll(Message message) {
        ConfigMenusForge.PROXY.getGameServer().func_184103_al().func_148540_a(NetworkHandler.toClientboundPacket(message));
    }

    public void sendToAllExcept(Message message, ServerPlayerEntity exclude) {
        IPacket<?> packet = NetworkHandler.toClientboundPacket(message);
        for (ServerPlayerEntity player : ConfigMenusForge.PROXY.getGameServer().func_184103_al().func_181057_v()) {
            if (player == exclude) continue;
            player.field_71135_a.func_147359_a(packet);
        }
    }

    public void sendToAllNear(Message message, BlockPos pos, World level) {
        this.sendToAllNearExcept(message, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 64.0, level);
    }

    public void sendToAllNearExcept(Message message, @Nullable ServerPlayerEntity exclude, double posX, double posY, double posZ, double distance, World level) {
        ConfigMenusForge.PROXY.getGameServer().func_184103_al().func_148543_a((PlayerEntity)exclude, posX, posY, posZ, distance, level.func_234923_W_(), NetworkHandler.toClientboundPacket(message));
    }

    public void sendToDimension(Message message, World level) {
        this.sendToDimension(message, (RegistryKey<World>)level.func_234923_W_());
    }

    public void sendToDimension(Message message, RegistryKey<World> dimension) {
        ConfigMenusForge.PROXY.getGameServer().func_184103_al().func_232642_a_(NetworkHandler.toClientboundPacket(message), dimension);
    }

    private static IPacket<?> toServerboundPacket(Message message) {
        return CHANNEL.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_SERVER);
    }

    private static IPacket<?> toClientboundPacket(Message message) {
        return CHANNEL.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static /* synthetic */ void lambda$null$2(Message msg, PlayerEntity player, LogicalSide receptionSide) {
        msg.handle(player, LogicalSidedProvider.INSTANCE.get(receptionSide));
    }

    static {
        PROTOCOL_VERSION = Integer.toString(1);
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("configmenusforge", "main")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        DISCRIMINATOR = new AtomicInteger();
    }
}

