/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditStringListScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    public static final ResourceLocation LOGO_TEXTURE = new ResourceLocation("configured", "textures/gui/logo.png");
    public static final Comparator<Entry> COMPARATOR = (o1, o2) -> {
        if (o1 instanceof SubMenu && o2 instanceof SubMenu) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
        if (!(o1 instanceof SubMenu) && o2 instanceof SubMenu) {
            return 1;
        }
        if (o1 instanceof SubMenu) {
            return -1;
        }
        return o1.getLabel().compareTo(o2.getLabel());
    };
    private final Screen parent;
    private final String displayName;
    private final List<ConfigFileEntry> clientConfigFileEntries;
    private final List<ConfigFileEntry> commonConfigFileEntries;
    private final ResourceLocation background;
    private ConfigList list;
    private List<Entry> entries;
    private ConfigTextFieldWidget activeTextField;
    private ConfigTextFieldWidget searchTextField;
    private Button restoreDefaultsButton;
    private boolean subMenu = false;
    private List<IReorderingProcessor> activeTooltip;
    private final List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> allConfigValues;

    public ConfigScreen(Screen parent, String displayName, ConfigFileEntry entry, ResourceLocation background) {
        super((ITextComponent)new StringTextComponent(displayName));
        this.parent = parent;
        this.displayName = displayName;
        this.clientConfigFileEntries = Collections.singletonList(entry);
        this.commonConfigFileEntries = null;
        this.subMenu = true;
        this.allConfigValues = null;
        this.background = background;
    }

    public ConfigScreen(Screen parent, String displayName, @Nullable List<ConfigFileEntry> clientConfigFileEntries, @Nullable List<ConfigFileEntry> commonConfigFileEntries, ResourceLocation background) {
        super((ITextComponent)new StringTextComponent(displayName));
        this.parent = parent;
        this.displayName = displayName;
        this.clientConfigFileEntries = clientConfigFileEntries;
        this.commonConfigFileEntries = commonConfigFileEntries;
        this.allConfigValues = this.gatherAllConfigValues();
        this.background = background;
    }

    private List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllConfigValues() {
        ArrayList values = new ArrayList();
        if (this.clientConfigFileEntries != null) {
            this.clientConfigFileEntries.forEach(entry -> this.gatherValuesFromConfig(((ConfigFileEntry)entry).config, ((ConfigFileEntry)entry).spec, values));
        }
        if (this.commonConfigFileEntries != null) {
            this.commonConfigFileEntries.forEach(entry -> this.gatherValuesFromConfig(((ConfigFileEntry)entry).config, ((ConfigFileEntry)entry).spec, values));
        }
        return ImmutableList.copyOf(values);
    }

    private void gatherValuesFromConfig(UnmodifiableConfig config, ForgeConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                this.gatherValuesFromConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    private void constructEntries() {
        ArrayList<TitleEntry> entries = new ArrayList<TitleEntry>();
        if (this.clientConfigFileEntries != null) {
            if (!this.subMenu) {
                entries.add(new TitleEntry("Client Configuration"));
            }
            ArrayList<Entry> clientEntries = new ArrayList<Entry>();
            this.clientConfigFileEntries.forEach(entry -> this.createEntriesFromConfig(((ConfigFileEntry)entry).config, ((ConfigFileEntry)entry).spec, clientEntries));
            clientEntries.sort(COMPARATOR);
            entries.addAll(clientEntries);
        }
        if (this.commonConfigFileEntries != null) {
            entries.add(new TitleEntry("Common Configuration"));
            ArrayList<Entry> commonEntries = new ArrayList<Entry>();
            this.commonConfigFileEntries.forEach(entry -> this.createEntriesFromConfig(((ConfigFileEntry)entry).config, ((ConfigFileEntry)entry).spec, commonEntries));
            commonEntries.sort(COMPARATOR);
            entries.addAll(commonEntries);
        }
        this.entries = ImmutableList.copyOf(entries);
    }

    private void createEntriesFromConfig(UnmodifiableConfig values, ForgeConfigSpec spec, List<Entry> entries) {
        values.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                entries.add(new SubMenu((String)s, spec, (AbstractConfig)o));
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                Object value = configValue.get();
                if (value instanceof Boolean) {
                    entries.add(new BooleanEntry((ForgeConfigSpec.ConfigValue<Boolean>)configValue, valueSpec));
                } else if (value instanceof Integer) {
                    entries.add(new IntegerEntry((ForgeConfigSpec.ConfigValue<Integer>)configValue, valueSpec));
                } else if (value instanceof Double) {
                    entries.add(new DoubleEntry((ForgeConfigSpec.ConfigValue<Double>)configValue, valueSpec));
                } else if (value instanceof Long) {
                    entries.add(new LongEntry((ForgeConfigSpec.ConfigValue<Long>)configValue, valueSpec));
                } else if (value instanceof Enum) {
                    entries.add(new EnumEntry((ForgeConfigSpec.ConfigValue<Enum>)configValue, valueSpec));
                } else if (value instanceof String) {
                    entries.add(new StringEntry((ForgeConfigSpec.ConfigValue<String>)configValue, valueSpec));
                } else if (value instanceof List) {
                    entries.add(new ListStringEntry(configValue, valueSpec));
                } else {
                    Configured.LOGGER.info("Unsupported config value: " + configValue.getPath());
                }
            }
        });
    }

    protected void func_231160_c_() {
        this.constructEntries();
        this.list = new ConfigList(this.entries);
        this.field_230705_e_.add(this.list);
        this.searchTextField = new ConfigTextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 110, 22, 220, 20, (ITextComponent)new StringTextComponent("Search"));
        this.searchTextField.func_212954_a(s -> {
            if (!s.isEmpty()) {
                this.list.func_230942_a_(this.entries.stream().filter(entry -> (entry instanceof SubMenu || entry instanceof ConfigEntry) && entry.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            } else {
                this.list.func_230942_a_(this.entries);
            }
        });
        this.field_230705_e_.add(this.searchTextField);
        if (this.subMenu) {
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 75, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240637_h_, button -> this.field_230706_i_.func_147108_a(this.parent)));
        } else {
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155 + 160, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240632_c_, button -> {
                if (this.clientConfigFileEntries != null) {
                    this.clientConfigFileEntries.forEach(entry -> ((ConfigFileEntry)entry).spec.save());
                }
                if (this.commonConfigFileEntries != null) {
                    this.commonConfigFileEntries.forEach(entry -> ((ConfigFileEntry)entry).spec.save());
                }
                this.field_230706_i_.func_147108_a(this.parent);
            }));
            this.restoreDefaultsButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 29, 150, 20, (ITextComponent)new TranslationTextComponent("configured.gui.restore_defaults"), button -> {
                ConfirmationScreen confirmScreen = new ConfirmationScreen(this, (ITextComponent)new TranslationTextComponent("configured.gui.restore_message"), result -> {
                    if (!result.booleanValue() || this.allConfigValues == null) {
                        return;
                    }
                    this.allConfigValues.forEach(pair -> {
                        ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)pair.getLeft();
                        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)pair.getRight();
                        configValue.set(valueSpec.getDefault());
                    });
                    this.entries.stream().filter(entry -> entry instanceof ConfigEntry).forEach(entry -> ((ConfigEntry)((Object)((Object)((Object)entry)))).onResetValue());
                });
                confirmScreen.setBackground(this.background);
                this.field_230706_i_.func_147108_a((Screen)confirmScreen);
            }));
            this.updateRestoreDefaultButton();
        }
    }

    public void func_231023_e_() {
        this.updateRestoreDefaultButton();
    }

    private void updateRestoreDefaultButton() {
        if (this.allConfigValues != null && this.restoreDefaultsButton != null) {
            this.restoreDefaultsButton.field_230693_o_ = this.allConfigValues.stream().anyMatch(pair -> !((ForgeConfigSpec.ConfigValue)pair.getLeft()).get().equals(((ForgeConfigSpec.ValueSpec)pair.getRight()).getDefault()));
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.func_230446_a_(matrixStack);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ConfigScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)7, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230706_i_.func_110434_K().func_110577_a(LOGO_TEXTURE);
        ConfigScreen.func_238464_a_((MatrixStack)matrixStack, (int)10, (int)13, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)23, (int)23, (int)32, (int)32);
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip(this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.info"), 200));
        }
        if (this.activeTooltip != null) {
            this.func_238654_b_(matrixStack, this.activeTooltip, mouseX, mouseY);
        }
        this.func_231039_at__().forEach(o -> {
            if (o instanceof Button.ITooltip) {
                ((Button.ITooltip)o).onTooltip((Button)o, matrixStack, mouseX, mouseY);
            }
        });
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.func_230455_a_(style);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void setActiveTooltip(List<IReorderingProcessor> activeTooltip) {
        this.activeTooltip = activeTooltip;
    }

    private static <V> V lastValue(List<V> list, V defaultValue) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }

    private static String createLabelFromConfig(ForgeConfigSpec.ConfigValue<?> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
        if (valueSpec.getTranslationKey() != null && I18n.func_188566_a((String)valueSpec.getTranslationKey())) {
            return new TranslationTextComponent(valueSpec.getTranslationKey()).getString();
        }
        return ConfigScreen.createLabel(ConfigScreen.lastValue(configValue.getPath(), ""));
    }

    private static String createLabel(String input) {
        int i;
        String valueName = input;
        String[] words = valueName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("_");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ").replaceAll("\\s++", " ");
    }

    public void func_231165_f_(int vOffset) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.field_230706_i_.func_110434_K().func_110577_a(this.background);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float size = 32.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_225582_a_(0.0, (double)this.field_230709_l_, 0.0).func_225583_a_(0.0f, (float)this.field_230709_l_ / size + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230708_k_, (double)this.field_230709_l_, 0.0).func_225583_a_((float)this.field_230708_k_ / size, (float)this.field_230709_l_ / size + (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_((double)this.field_230708_k_, 0.0, 0.0).func_225583_a_((float)this.field_230708_k_ / size, (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, 0.0).func_225583_a_(0.0f, (float)vOffset).func_225586_a_(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, new MatrixStack()));
    }

    public static class ConfigFileEntry {
        private ForgeConfigSpec spec;
        private UnmodifiableConfig config;

        public ConfigFileEntry(ForgeConfigSpec spec, UnmodifiableConfig config) {
            this.spec = spec;
            this.config = config;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ConfigTextFieldWidget
    extends TextFieldWidget {
        public ConfigTextFieldWidget(FontRenderer fontRenderer, int x, int y, int width, int height, ITextComponent label) {
            super(fontRenderer, x, y, width, height, label);
        }

        public void func_146195_b(boolean focused) {
            super.func_146195_b(focused);
            if (focused) {
                if (ConfigScreen.this.activeTextField != null && ConfigScreen.this.activeTextField != this) {
                    ConfigScreen.this.activeTextField.func_146195_b(false);
                    ConfigScreen.this.activeTextField = this;
                } else {
                    ConfigScreen.this.activeTextField = this;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EnumEntry
    extends ConfigEntry<ForgeConfigSpec.ConfigValue<Enum>> {
        private final Button button;

        public EnumEntry(ForgeConfigSpec.ConfigValue<Enum> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec);
            this.button = new Button(10, 5, 44, 20, (ITextComponent)new StringTextComponent(((Enum)configValue.get()).name()), button -> {
                Object o = configValue.get();
                if (o instanceof Enum) {
                    Enum e = (Enum)o;
                    E[] values = e.getDeclaringClass().getEnumConstants();
                    e = (Enum)values[(e.ordinal() + 1) % values.length];
                    configValue.set((Object)e);
                    button.func_238482_a_((ITextComponent)new StringTextComponent(e.name()));
                }
            });
            this.eventListeners.add(this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = left + width - 67;
            this.button.field_230691_m_ = top;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.func_238482_a_((ITextComponent)new StringTextComponent(((Enum)this.configValue.get()).name()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ListStringEntry
    extends ConfigEntry<ForgeConfigSpec.ConfigValue<List<?>>> {
        private final Button button;

        public ListStringEntry(ForgeConfigSpec.ConfigValue<List<?>> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec);
            String title = ConfigScreen.createLabelFromConfig(configValue, valueSpec);
            this.button = new Button(10, 5, 44, 20, (ITextComponent)new TranslationTextComponent("configured.gui.edit"), button -> ConfigScreen.this.field_230706_i_.func_147108_a((Screen)new EditStringListScreen(ConfigScreen.this, (ITextComponent)new StringTextComponent(title), configValue, valueSpec)));
            this.eventListeners.add(this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = left + width - 67;
            this.button.field_230691_m_ = top;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class StringEntry
    extends ConfigEntry<ForgeConfigSpec.ConfigValue<String>> {
        private final Button button;

        public StringEntry(ForgeConfigSpec.ConfigValue<String> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec);
            String title = ConfigScreen.createLabelFromConfig(configValue, valueSpec);
            this.button = new Button(10, 5, 44, 20, (ITextComponent)new TranslationTextComponent("configured.gui.edit"), button -> ConfigScreen.this.field_230706_i_.func_147108_a((Screen)new EditStringScreen(ConfigScreen.this, (ITextComponent)new StringTextComponent(title), (String)configValue.get(), arg_0 -> ((ForgeConfigSpec.ValueSpec)valueSpec).test(arg_0), arg_0 -> ((ForgeConfigSpec.ConfigValue)configValue).set(arg_0))));
            this.eventListeners.add(this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = left + width - 67;
            this.button.field_230691_m_ = top;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BooleanEntry
    extends ConfigEntry<ForgeConfigSpec.ConfigValue<Boolean>> {
        private final Button button;

        public BooleanEntry(ForgeConfigSpec.ConfigValue<Boolean> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec);
            this.button = new Button(10, 5, 44, 20, DialogTexts.func_240638_a_((boolean)((Boolean)configValue.get())), button -> {
                boolean flag = (Boolean)configValue.get() == false;
                configValue.set((Object)flag);
                button.func_238482_a_(DialogTexts.func_240638_a_((boolean)((Boolean)configValue.get())));
            });
            this.eventListeners.add(this.button);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.button.field_230690_l_ = left + width - 67;
            this.button.field_230691_m_ = top;
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.button.func_238482_a_(DialogTexts.func_240638_a_((boolean)((Boolean)this.configValue.get())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class LongEntry
    extends NumberEntry<ForgeConfigSpec.ConfigValue<Long>> {
        public LongEntry(ForgeConfigSpec.ConfigValue<Long> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec, Long::parseLong);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class DoubleEntry
    extends NumberEntry<ForgeConfigSpec.ConfigValue<Double>> {
        public DoubleEntry(ForgeConfigSpec.ConfigValue<Double> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec, Double::parseDouble);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class IntegerEntry
    extends NumberEntry<ForgeConfigSpec.ConfigValue<Integer>> {
        public IntegerEntry(ForgeConfigSpec.ConfigValue<Integer> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            super(ConfigScreen.this, configValue, valueSpec, Integer::parseInt);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class NumberEntry<T extends ForgeConfigSpec.ConfigValue>
    extends ConfigEntry<T> {
        private ConfigTextFieldWidget textField;
        final /* synthetic */ ConfigScreen this$0;

        public NumberEntry(T configValue, ForgeConfigSpec.ValueSpec valueSpec, Function<String, Number> parser) {
            this.this$0 = this$0;
            super((ConfigScreen)this$0, configValue, valueSpec);
            this.textField = this$0.new ConfigTextFieldWidget(((ConfigScreen)this$0).field_230712_o_, 0, 0, 42, 18, (ITextComponent)new StringTextComponent("YEP"));
            this.textField.func_146180_a(configValue.get().toString());
            this.textField.func_212954_a(s -> {
                try {
                    Number n = (Number)parser.apply((String)s);
                    if (valueSpec.test((Object)n)) {
                        this.textField.func_146193_g(0xE0E0E0);
                        configValue.set((Object)n);
                    } else {
                        this.textField.func_146193_g(0xFF0000);
                    }
                }
                catch (Exception ignored) {
                    this.textField.func_146193_g(0xFF0000);
                }
            });
            this.eventListeners.add(this.textField);
        }

        @Override
        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.func_230432_a_(matrixStack, index, top, left, width, p_230432_6_, mouseX, mouseY, hovered, partialTicks);
            this.textField.field_230690_l_ = left + width - 66;
            this.textField.field_230691_m_ = top + 1;
            this.textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onResetValue() {
            this.textField.func_146180_a(this.configValue.get().toString());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ConfigList
    extends AbstractOptionList<Entry> {
        public ConfigList(List<Entry> entries) {
            super(ConfigScreen.this.field_230706_i_, ConfigScreen.this.field_230708_k_, ConfigScreen.this.field_230709_l_, 50, ConfigScreen.this.field_230709_l_ - 36, 24);
            entries.forEach(arg_0 -> ((ConfigList)this).func_230513_b_(arg_0));
        }

        public int func_230968_n_() {
            return super.func_230968_n_();
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 144;
        }

        public int func_230949_c_() {
            return 260;
        }

        public void func_230942_a_(Collection<Entry> entries) {
            super.func_230942_a_(entries);
        }

        private void renderToolTips(MatrixStack matrixStack, int mouseX, int mouseY) {
            Entry entry2;
            if (this.func_231047_b_(mouseX, mouseY) && mouseX < ConfigScreen.this.list.func_230968_n_() + ConfigScreen.this.list.func_230949_c_() - 67 && (entry2 = (Entry)this.func_230933_a_(mouseX, mouseY)) != null) {
                ConfigScreen.this.setActiveTooltip(entry2.tooltip);
            }
            this.func_231039_at__().forEach(entry -> entry.func_231039_at__().forEach(o -> {
                if (o instanceof Button) {
                    ((Button)o).func_230443_a_(matrixStack, mouseX, mouseY);
                }
            }));
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.func_230433_a_(matrixStack);
            int scrollBarStart = this.func_230952_d_();
            int scrollBarEnd = scrollBarStart + 6;
            this.field_230668_b_.func_110434_K().func_110577_a(ConfigScreen.this.background);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225583_a_((float)this.field_230675_l_ / 32.0f, (float)(this.field_230673_j_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225583_a_((float)this.field_230674_k_ / 32.0f, (float)(this.field_230673_j_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225583_a_((float)this.field_230674_k_ / 32.0f, (float)(this.field_230672_i_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225583_a_((float)this.field_230675_l_ / 32.0f, (float)(this.field_230672_i_ + (int)this.func_230966_l_()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            tessellator.func_78381_a();
            int rowLeft = this.func_230968_n_();
            int scrollOffset = this.field_230672_i_ + 4 - (int)this.func_230966_l_();
            this.func_238478_a_(matrixStack, rowLeft, scrollOffset, mouseX, mouseY, partialTicks);
            this.field_230668_b_.func_110434_K().func_110577_a(ConfigScreen.this.background);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)519);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, -100.0).func_225583_a_(0.0f, (float)this.field_230672_i_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230672_i_, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.field_230672_i_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), 0.0, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, 0.0, -100.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230671_e_, -100.0).func_225583_a_(0.0f, (float)this.field_230671_e_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230671_e_, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.field_230671_e_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)(this.field_230675_l_ + this.field_230670_d_), (double)this.field_230673_j_, -100.0).func_225583_a_((float)this.field_230670_d_ / 32.0f, (float)this.field_230673_j_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, -100.0).func_225583_a_(0.0f, (float)this.field_230673_j_ / 32.0f).func_225586_a_(64, 64, 64, 255).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_((double)this.field_230675_l_, (double)(this.field_230672_i_ + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)(this.field_230672_i_ + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)this.field_230672_i_, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230672_i_, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)this.field_230673_j_, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)this.field_230673_j_, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_225582_a_((double)this.field_230674_k_, (double)(this.field_230673_j_ - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            buffer.func_225582_a_((double)this.field_230675_l_, (double)(this.field_230673_j_ - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            int maxScroll = Math.max(0, this.func_230945_b_() - (this.field_230673_j_ - this.field_230672_i_ - 4));
            if (maxScroll > 0) {
                int scrollBarStartY = (int)((float)((this.field_230673_j_ - this.field_230672_i_) * (this.field_230673_j_ - this.field_230672_i_)) / (float)this.func_230945_b_());
                scrollBarStartY = MathHelper.func_76125_a((int)scrollBarStartY, (int)32, (int)(this.field_230673_j_ - this.field_230672_i_ - 8));
                int scrollBarEndY = (int)this.func_230966_l_() * (this.field_230673_j_ - this.field_230672_i_ - scrollBarStartY) / maxScroll + this.field_230672_i_;
                if (scrollBarEndY < this.field_230672_i_) {
                    scrollBarEndY = this.field_230672_i_;
                }
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_225582_a_((double)scrollBarStart, (double)this.field_230673_j_, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarEnd, (double)this.field_230673_j_, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarEnd, (double)this.field_230672_i_, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)this.field_230672_i_, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)(scrollBarEndY + scrollBarStartY), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarEnd, (double)(scrollBarEndY + scrollBarStartY), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarEnd, (double)scrollBarEndY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)scrollBarEndY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)(scrollBarEndY + scrollBarStartY - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                buffer.func_225582_a_((double)(scrollBarEnd - 1), (double)(scrollBarEndY + scrollBarStartY - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                buffer.func_225582_a_((double)(scrollBarEnd - 1), (double)scrollBarEndY, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                buffer.func_225582_a_((double)scrollBarStart, (double)scrollBarEndY, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.func_230447_a_(matrixStack, mouseX, mouseY);
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            this.renderToolTips(matrixStack, mouseX, mouseY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ConfigEntry<T extends ForgeConfigSpec.ConfigValue>
    extends Entry {
        protected T configValue;
        protected ForgeConfigSpec.ValueSpec valueSpec;
        protected final List<IGuiEventListener> eventListeners;
        protected Button resetButton;
        final /* synthetic */ ConfigScreen this$0;

        public ConfigEntry(T configValue, ForgeConfigSpec.ValueSpec valueSpec) {
            this.this$0 = this$0;
            super(ConfigScreen.createLabelFromConfig(configValue, valueSpec));
            this.eventListeners = Lists.newArrayList();
            this.configValue = configValue;
            this.valueSpec = valueSpec;
            if (valueSpec.getComment() != null) {
                this.tooltip = this.createToolTip((ForgeConfigSpec.ConfigValue<?>)configValue, valueSpec);
            }
            Button.ITooltip tooltip = (button, matrixStack, mouseX, mouseY) -> {
                if (button.field_230693_o_ && button.func_230449_g_()) {
                    this.this$0.func_238654_b_(matrixStack, ((ConfigScreen)this.this$0).field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.reset"), Math.max(this.this$0.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
                }
            };
            this.resetButton = new IconButton(0, 0, 20, 20, 0, 0, tooltip, onPress -> {
                configValue.set(valueSpec.getDefault());
                this.onResetValue();
            });
            this.eventListeners.add((IGuiEventListener)this.resetButton);
        }

        public void onResetValue() {
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.eventListeners;
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.resetButton.field_230693_o_ = !this.configValue.get().equals(this.valueSpec.getDefault());
            StringTextComponent title = new StringTextComponent(this.label);
            if (((ConfigScreen)this.this$0).field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)title) > width - 75) {
                String trimmed = ((ConfigScreen)this.this$0).field_230706_i_.field_71466_p.func_238417_a_((ITextProperties)title, width - 75).getString() + "...";
                ((ConfigScreen)this.this$0).field_230706_i_.field_71466_p.func_243246_a(matrixStack, (ITextComponent)new StringTextComponent(trimmed), (float)left, (float)(top + 6), 0xFFFFFF);
            } else {
                ((ConfigScreen)this.this$0).field_230706_i_.field_71466_p.func_243246_a(matrixStack, (ITextComponent)title, (float)left, (float)(top + 6), 0xFFFFFF);
            }
            if (this.func_231047_b_(mouseX, mouseY) && mouseX < this.this$0.list.func_230968_n_() + this.this$0.list.func_230949_c_() - 67) {
                this.this$0.setActiveTooltip(this.tooltip);
            }
            this.resetButton.field_230690_l_ = left + width - 21;
            this.resetButton.field_230691_m_ = top;
            this.resetButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        private List<IReorderingProcessor> createToolTip(ForgeConfigSpec.ConfigValue<?> value, ForgeConfigSpec.ValueSpec spec) {
            int i;
            FontRenderer font = ((ConfigScreen)this.this$0).field_230706_i_.field_71466_p;
            List lines = font.func_238420_b_().func_238362_b_((ITextProperties)new StringTextComponent(spec.getComment()), 200, Style.field_240709_b_);
            String name = (String)ConfigScreen.lastValue(value.getPath(), "");
            lines.add(0, new StringTextComponent(name).func_240699_a_(TextFormatting.YELLOW));
            int rangeIndex = -1;
            for (i = 0; i < lines.size(); ++i) {
                String text = ((ITextProperties)lines.get(i)).getString();
                if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                rangeIndex = i;
                break;
            }
            if (rangeIndex != -1) {
                for (i = rangeIndex; i < lines.size(); ++i) {
                    lines.set(i, new StringTextComponent(((ITextProperties)lines.get(i)).getString()).func_240699_a_(TextFormatting.GRAY));
                }
            }
            return LanguageMap.func_74808_a().func_244260_a(lines);
        }
    }

    public class SubMenu
    extends Entry {
        private final Button button;

        public SubMenu(String label, ForgeConfigSpec spec, AbstractConfig values) {
            super(ConfigScreen.createLabel(label));
            this.button = new Button(10, 5, 44, 20, (ITextComponent)new StringTextComponent(this.getLabel()).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.WHITE), onPress -> {
                String newTitle = ConfigScreen.this.displayName + " > " + this.getLabel();
                ConfigScreen.this.field_230706_i_.func_147108_a((Screen)new ConfigScreen(ConfigScreen.this, newTitle, new ConfigFileEntry(spec, (UnmodifiableConfig)values), ConfigScreen.this.background));
            });
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.button);
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.field_230690_l_ = left - 1;
            this.button.field_230691_m_ = top;
            this.button.func_230991_b_(width);
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public class TitleEntry
    extends Entry {
        public TitleEntry(String title) {
            super(title);
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }

        public void func_230432_a_(MatrixStack matrixStack, int x, int top, int left, int width, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            IFormattableTextComponent title = new StringTextComponent(this.label).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.YELLOW);
            AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)((ConfigScreen)ConfigScreen.this).field_230706_i_.field_71466_p, (ITextComponent)title, (int)(left + width / 2), (int)(top + 5), (int)0xFFFFFF);
        }
    }

    abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
        protected String label;
        protected List<IReorderingProcessor> tooltip;

        public Entry(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

