/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.net.TeleportFromMapPacket;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class WaypointButton
extends Widget {
    public final Waypoint waypoint;
    public Icon icon;

    public WaypointButton(Panel panel, Waypoint w) {
        super(panel);
        this.icon = Icon.getIcon((ResourceLocation)w.type.texture).withTint(Color4I.rgb((int)w.color).withAlpha(w.hidden ? 100 : 255));
        this.waypoint = w;
    }

    public void addMouseOverText(TooltipList list) {
        list.string(this.waypoint.name);
        long dist = (long)MathUtils.dist((double)Minecraft.func_71410_x().field_71439_g.func_226277_ct_(), (double)Minecraft.func_71410_x().field_71439_g.func_226281_cx_(), (double)this.waypoint.x, (double)this.waypoint.z);
        list.styledString(dist + " m", TextFormatting.GRAY);
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        this.icon.draw(matrixStack, x, y, w, h);
    }

    public boolean keyPressed(Key key) {
        if (this.isMouseOver() && key.is(84)) {
            new TeleportFromMapPacket(this.waypoint.x, this.waypoint.y, this.waypoint.z, this.waypoint.dimension.dimension).sendToServer();
            this.closeGui(false);
            return true;
        }
        return super.keyPressed(key);
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent(this.waypoint.name), this.icon, () -> {}));
            contextMenu.add(ContextMenuItem.SEPARATOR);
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.rename"), Icons.CHAT, () -> {
                StringConfig config = new StringConfig();
                config.defaultValue = "";
                config.value = this.waypoint.name;
                config.onClicked(MouseButton.LEFT, b -> {
                    if (b) {
                        this.waypoint.name = (String)config.value;
                        this.waypoint.dimension.saveData = true;
                    }
                    this.openGui();
                });
            }));
            if (this.waypoint.type == WaypointType.DEFAULT) {
                contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent("Change Color"), Icons.COLOR_RGB, () -> {
                    int r = this.waypoint.color >> 16 & 0xFF;
                    int g = this.waypoint.color >> 8 & 0xFF;
                    int b = this.waypoint.color >> 0 & 0xFF;
                    float[] hsb = Color.RGBtoHSB(r, g, b, new float[3]);
                    Color4I col = Color4I.hsb((float)(hsb[0] + 0.083333336f), (float)hsb[1], (float)hsb[2]);
                    this.waypoint.color = col.rgba();
                    this.waypoint.dimension.saveData = true;
                    ((ContextMenuItem)contextMenu.get((int)0)).icon = this.icon = Icon.getIcon((ResourceLocation)this.waypoint.type.texture).withTint(col.withAlpha(this.waypoint.hidden ? 100 : 255));
                }).setCloseMenu(false));
                contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent(this.waypoint.hidden ? "Show" : "Hide"), Icons.BEACON, () -> {
                    this.waypoint.hidden = !this.waypoint.hidden;
                    this.waypoint.dimension.saveData = true;
                    ((ContextMenuItem)contextMenu.get((int)0)).title = new StringTextComponent(this.waypoint.hidden ? "Show" : "Hide");
                    this.getGui().refreshWidgets();
                }));
            }
            contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.remove"), Icons.REMOVE, () -> {
                this.waypoint.dimension.getWaypoints().remove(this.waypoint);
                this.waypoint.dimension.saveData = true;
                this.parent.widgets.remove((Object)this);
            }));
            this.getGui().openContextMenu(contextMenu);
            return true;
        }
        return false;
    }
}

