/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.core.BlockStateFTBC;
import dev.ftb.mods.ftblibrary.math.XZ;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.IChunk;
import org.jetbrains.annotations.Nullable;

public class ChunkUpdateTask
implements MapTask,
BiomeManager.IBiomeReader {
    public static final int[] ALL_BLOCKS = (int[])Util.func_200696_a((Object)new int[256], array -> {
        for (int i = 0; i < 256; ++i) {
            array[i] = i;
        }
    });
    private static final ResourceLocation AIR = new ResourceLocation("minecraft:air");
    public static long debugLastTime = 0L;
    public MapManager manager;
    public final World level;
    public final IChunk chunkAccess;
    public final ChunkPos pos;
    public BiomeContainer biomeContainer;
    public final long biomeZoomSeed;
    public final int[] blocksToUpdate;
    private final long taskStartTime;
    private int currentWaterY = Integer.MAX_VALUE;

    public ChunkUpdateTask(@Nullable MapManager m, World w, IChunk ca, ChunkPos p, @Nullable BiomeContainer b, long zs, int[] s) {
        this.manager = m;
        this.level = w;
        this.chunkAccess = ca;
        this.pos = p;
        this.biomeContainer = b;
        this.biomeZoomSeed = zs;
        this.blocksToUpdate = s;
        this.taskStartTime = System.currentTimeMillis();
    }

    @Override
    public void runMapTask() throws Exception {
        boolean versionChange;
        while (this.manager == null) {
            this.manager = MapManager.inst;
            if (this.manager != null) continue;
            if (System.currentTimeMillis() - this.taskStartTime >= 30000L) {
                return;
            }
            Thread.sleep(1L);
        }
        if (this.manager.invalid) {
            return;
        }
        long startTime = System.nanoTime();
        RegistryKey dimId = this.level.func_234923_W_();
        MapChunk mapChunk = this.manager.getDimension((RegistryKey<World>)dimId).getRegion(XZ.regionFromChunk((ChunkPos)this.pos)).getDataBlocking().getChunk(XZ.of((ChunkPos)this.pos));
        MapRegionData data = mapChunk.region.getDataBlocking();
        MutableRegistry biomes = this.level.func_241828_r().func_243612_b(Registry.field_239720_u_);
        if (this.biomeContainer == null) {
            this.biomeContainer = this.chunkAccess.func_225549_i_();
        }
        if (this.biomeContainer == null) {
            return;
        }
        int topY = this.level.func_234938_ad_() + 1;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        int blockX = this.pos.func_180334_c();
        int blockZ = this.pos.func_180333_d();
        boolean changed = false;
        boolean bl = versionChange = mapChunk.version != 4;
        if (versionChange) {
            mapChunk.version = 4;
            changed = true;
        }
        for (int wi : this.blocksToUpdate) {
            int wx = wi % 16;
            int wz = wi / 16;
            blockPos.func_181079_c(blockX + wx, topY, blockZ + wz);
            int height = MathHelper.func_76125_a((int)this.getHeight(blockPos).func_177956_o(), (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
            blockPos.func_185336_p(height);
            BlockState state = this.chunkAccess.func_180495_p((BlockPos)blockPos);
            int ax = mapChunk.pos.x * 16 + wx;
            int az = mapChunk.pos.z * 16 + wz;
            int index = ax + az * 512;
            int waterLightAndBiome0 = data.waterLightAndBiome[index] & 0xFFFF;
            int blockIndex0 = data.getBlockIndex(index);
            int height0 = data.height[index] & 0xFFFF;
            blockPos.func_185336_p(this.currentWaterY == Integer.MAX_VALUE ? height : this.currentWaterY);
            int waterLightAndBiome = waterLightAndBiome0 & 0x7FF;
            waterLightAndBiome |= this.currentWaterY != Integer.MAX_VALUE ? 32768 : 0;
            waterLightAndBiome |= (this.level.func_226658_a_(LightType.BLOCK, (BlockPos)blockPos) & 0xF) << 11;
            ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.func_177230_c());
            int blockIndex = this.manager.getBlockColorIndex(id == null ? AIR : id);
            Biome biome = this.func_225526_b_(blockPos.func_177958_n() >> 2, blockPos.func_177956_o() >> 2, blockPos.func_177952_p() >> 2);
            waterLightAndBiome &= 0xF800;
            waterLightAndBiome |= this.manager.getBiomeColorIndex((MutableRegistry<Biome>)biomes, biome, biome) & 0x7FF;
            if (versionChange || height0 != height) {
                data.height[index] = (short)height;
                changed = true;
            }
            if (versionChange || waterLightAndBiome0 != waterLightAndBiome) {
                data.waterLightAndBiome[index] = (short)waterLightAndBiome;
                if (biome != null && (versionChange || (waterLightAndBiome0 & 0x7FF) != (waterLightAndBiome & 0x7FF))) {
                    double cx = blockPos.func_177958_n();
                    double cz = blockPos.func_177952_p();
                    data.foliage[index] = data.foliage[index] & 0xFF000000 | BiomeColors.field_180289_b.getColor(biome, cx, cz) & 0xFFFFFF;
                    data.grass[index] = data.grass[index] & 0xFF000000 | BiomeColors.field_180291_a.getColor(biome, cx, cz) & 0xFFFFFF;
                    data.water[index] = data.water[index] & 0xFF000000 | BiomeColors.field_180290_c.getColor(biome, cx, cz) & 0xFFFFFF;
                }
                changed = true;
            }
            if (versionChange || blockIndex0 != blockIndex) {
                data.setBlockIndex(index, blockIndex);
                changed = true;
            }
            this.currentWaterY = Integer.MAX_VALUE;
        }
        if (changed) {
            mapChunk.modified = System.currentTimeMillis();
            mapChunk.region.update(true);
        }
        debugLastTime = System.nanoTime() - startTime;
    }

    public String toString() {
        return "ChunkUpdateTask@" + this.pos;
    }

    private boolean isWater(BlockState state) {
        if (state.func_177230_c() == Blocks.field_150355_j) {
            return true;
        }
        return state instanceof BlockStateFTBC ? ((BlockStateFTBC)state).getFTBCIsWater() : state.func_204520_s().func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a);
    }

    private boolean skipBlock(BlockState state) {
        if (state.func_196958_f()) {
            return true;
        }
        ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.func_177230_c());
        return id == null || ColorMapLoader.getBlockColor(id).isIgnored();
    }

    private BlockPos.Mutable getHeight(BlockPos.Mutable pos) {
        int topY = pos.func_177956_o();
        if (topY == -1) {
            pos.func_185336_p(-1);
            return pos;
        }
        for (int by = topY; by > 0; --by) {
            boolean water;
            pos.func_185336_p(by);
            BlockState state = this.chunkAccess.func_180495_p((BlockPos)pos);
            if (by == topY || state.func_177230_c() == Blocks.field_150357_h) {
                while (by > 0) {
                    pos.func_185336_p(by);
                    state = this.chunkAccess.func_180495_p((BlockPos)pos);
                    if (state.func_196958_f()) break;
                    --by;
                }
            }
            if ((water = this.isWater(state)) && this.currentWaterY == Integer.MAX_VALUE) {
                this.currentWaterY = by;
            }
            if (water || this.skipBlock(state)) continue;
            pos.func_185336_p(by);
            return pos;
        }
        pos.func_185336_p(-1);
        return pos;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int cx = x >> 2;
        int cz = z >> 2;
        if (cx == this.pos.field_77276_a && cz == this.pos.field_77275_b) {
            return this.biomeContainer.func_225526_b_(x, y, z);
        }
        return this.level.func_225526_b_(x, y, z);
    }
}

