/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.compat.waystones;

import dev.ftb.mods.ftbchunks.client.MinimapRenderer;
import dev.ftb.mods.ftbchunks.client.RegionMapPanel;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.compat.waystones.WaystoneWidget;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WaystonesCompat {
    private static List<IWaystone> WAYSTONES = Collections.emptyList();
    private static final int GLOBAL_COLOR = 15431909;

    public static void init() {
        MinecraftForge.EVENT_BUS.register(WaystonesCompat.class);
    }

    public static int colorFor(IWaystone waystone) {
        return waystone.isGlobal() ? 15431909 : 0xFFFFFF;
    }

    @SubscribeEvent
    public static void onWaystonesReceived(KnownWaystonesEvent event) {
        WAYSTONES = event.getWaystones();
    }

    public static void addWidgets(RegionMapPanel panel) {
        for (IWaystone waystone : WAYSTONES) {
            if (waystone.getDimension() != panel.largeMap.dimension.dimension) continue;
            panel.add(new WaystoneWidget(panel, waystone));
        }
    }

    public static void renderMinimap(MapDimension dimension, MinimapRenderer renderer) {
        for (IWaystone waystone : WAYSTONES) {
            if (waystone.getDimension() != dimension.dimension) continue;
            renderer.render(waystone.getPos().func_177958_n(), waystone.getPos().func_177952_p(), WaystonesCompat.colorFor(waystone), 0);
        }
    }
}

