/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.AllyMode;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ClaimResults;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PrivacyMode;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.property.BooleanProperty;
import dev.ftb.mods.ftbteams.property.PrivacyProperty;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import me.shedaniel.architectury.hooks.PlayerHooks;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class FTBChunksTeamData {
    public static final BooleanProperty ALLOW_FAKE_PLAYERS = new BooleanProperty(new ResourceLocation("ftbchunks", "allow_fake_players"), Boolean.valueOf(true));
    public static final PrivacyProperty BLOCK_EDIT_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "block_edit_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty BLOCK_INTERACT_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "block_interact_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty MINIMAP_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "minimap_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty LOCATION_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "location_mode"), PrivacyMode.ALLIES);
    public final ClaimedChunkManager manager;
    private final Team team;
    public final Path file;
    private boolean shouldSave;
    public int maxClaimChunks;
    public int maxForceLoadChunks;
    public int extraClaimChunks;
    public int extraForceLoadChunks;
    public boolean chunkLoadOffline;
    public boolean hasMembersOnline;
    public int prevChunkX = Integer.MAX_VALUE;
    public int prevChunkZ = Integer.MAX_VALUE;
    public String lastChunkID = "";

    public FTBChunksTeamData(ClaimedChunkManager m, Path f, Team t) {
        this.manager = m;
        this.team = t;
        this.file = f;
        this.shouldSave = false;
        this.maxClaimChunks = -1;
        this.maxForceLoadChunks = -1;
        this.extraClaimChunks = 0;
        this.extraForceLoadChunks = 0;
        this.chunkLoadOffline = true;
        this.hasMembersOnline = false;
    }

    public String toString() {
        return this.team.getStringID();
    }

    public ClaimedChunkManager getManager() {
        return this.manager;
    }

    public Team getTeam() {
        return this.team;
    }

    public UUID getTeamId() {
        return this.team.getId();
    }

    public Collection<ClaimedChunk> getClaimedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunk chunk : this.manager.claimedChunks.values()) {
            if (chunk.teamData != this) continue;
            list.add(chunk);
        }
        return list;
    }

    public Collection<ClaimedChunk> getForceLoadedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunk chunk : this.manager.claimedChunks.values()) {
            if (chunk.teamData != this || !chunk.isForceLoaded()) continue;
            list.add(chunk);
        }
        return list;
    }

    public void updateLimits(ServerPlayerEntity ownerPlayer) {
        if (this.maxClaimChunks != -1 && this.team.getType().isParty() && !ownerPlayer.func_110124_au().equals(this.team.getOwner())) {
            return;
        }
        int c = FTBChunksWorldConfig.getMaxClaimedChunks(this, ownerPlayer);
        int f = FTBChunksWorldConfig.getMaxForceLoadedChunks(this, ownerPlayer);
        if (this.maxClaimChunks != c || this.maxForceLoadChunks != f) {
            this.maxClaimChunks = c;
            this.maxForceLoadChunks = f;
            for (ServerPlayerEntity p : this.team.getOnlineMembers()) {
                SendGeneralDataPacket.send(this, p);
            }
            this.save();
        }
    }

    public ClaimResult claim(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk != null) {
            return ClaimResults.ALREADY_CLAIMED;
        }
        if (FTBChunksWorldConfig.CLAIM_DIMENSION_BLACKLIST_SET.contains(pos.dimension)) {
            return ClaimResults.DIMENSION_FORBIDDEN;
        }
        if (!this.team.getType().isServer() && this.getClaimedChunks().size() >= FTBChunksWorldConfig.getMaxClaimedChunks(this, FTBChunksTeamData.playerOrNull(source))) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        chunk = new ClaimedChunk(this, pos);
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_CLAIM.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        this.manager.claimedChunks.put(pos, chunk);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_CLAIM.invoker()).after(source, chunk);
        this.save();
        return chunk;
    }

    public ClaimResult unclaim(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.teamData != this && !source.func_197034_c(2) && !source.func_197028_i().func_71264_H()) {
            return ClaimResults.NOT_OWNER;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNCLAIM.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.unclaim(source, true);
        return chunk;
    }

    public ClaimResult load(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.teamData != this && !source.func_197034_c(2) && !source.func_197028_i().func_71264_H()) {
            return ClaimResults.NOT_OWNER;
        }
        if (chunk.isForceLoaded()) {
            return ClaimResults.ALREADY_LOADED;
        }
        if (!this.team.getType().isServer() && this.getForceLoadedChunks().size() >= FTBChunksWorldConfig.getMaxForceLoadedChunks(this, FTBChunksTeamData.playerOrNull(source))) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_LOAD.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setForceLoadedTime(System.currentTimeMillis());
        chunk.postSetForceLoaded(true);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_LOAD.invoker()).after(source, chunk);
        chunk.teamData.save();
        return chunk;
    }

    public ClaimResult unload(CommandSource source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.claimedChunks.get(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (!(chunk.teamData == this || source.func_197034_c(2) || source.func_197028_i().func_71264_H() || source.func_197022_f() instanceof ServerPlayerEntity && this.isTeamMember(source.func_197022_f().func_110124_au()))) {
            return ClaimResults.NOT_OWNER;
        }
        if (!chunk.isForceLoaded()) {
            return ClaimResults.NOT_LOADED;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNLOAD.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.unload(source);
        return chunk;
    }

    public void save() {
        this.shouldSave = true;
        this.team.save();
    }

    public boolean isTeamMember(UUID p) {
        if (p.equals(this.getTeamId())) {
            return true;
        }
        return this.team.equals((Object)FTBTeamsAPI.getManager().getPlayerTeam(p));
    }

    public boolean isAlly(UUID p) {
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_ALL || this.team.isMember(p)) {
            return true;
        }
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_NONE) {
            return false;
        }
        return this.team.isAlly(p);
    }

    public boolean canUse(ServerPlayerEntity p, PrivacyProperty property) {
        PrivacyMode mode = (PrivacyMode)this.team.getProperty((TeamProperty)property);
        if (mode == PrivacyMode.PUBLIC) {
            return true;
        }
        if (mode == PrivacyMode.ALLIES) {
            if (PlayerHooks.isFake((PlayerEntity)p)) {
                return (Boolean)this.team.getProperty((TeamProperty)ALLOW_FAKE_PLAYERS);
            }
            return this.isAlly(p.func_110124_au());
        }
        return this.team.isMember(p.func_110124_au());
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.func_74768_a("max_claim_chunks", this.maxClaimChunks);
        tag.func_74768_a("max_force_load_chunks", this.maxForceLoadChunks);
        tag.func_74768_a("extra_claim_chunks", this.extraClaimChunks);
        tag.func_74768_a("extra_force_load_chunks", this.extraForceLoadChunks);
        tag.func_74757_a("chunk_load_offline", this.chunkLoadOffline);
        CompoundNBT chunksTag = new CompoundNBT();
        for (ClaimedChunk chunk : this.getClaimedChunks()) {
            String key = chunk.getPos().dimension.func_240901_a_().toString();
            ListNBT chunksListTag = chunksTag.func_150295_c(key, 10);
            if (chunksListTag.isEmpty()) {
                chunksTag.func_218657_a(key, (INBT)chunksListTag);
            }
            SNBTCompoundTag o = new SNBTCompoundTag();
            o.singleLine();
            o.func_74768_a("x", chunk.getPos().x);
            o.func_74768_a("z", chunk.getPos().z);
            o.func_74772_a("time", chunk.getTimeClaimed());
            if (chunk.isForceLoaded()) {
                o.func_74772_a("force_loaded", chunk.getForceLoadedTime());
            }
            chunksListTag.add((Object)o);
        }
        tag.func_218657_a("chunks", (INBT)chunksTag);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.maxClaimChunks = tag.func_74762_e("max_claim_chunks");
        this.maxForceLoadChunks = tag.func_74762_e("max_force_load_chunks");
        this.extraClaimChunks = tag.func_74762_e("extra_claim_chunks");
        this.extraForceLoadChunks = tag.func_74762_e("extra_force_load_chunks");
        this.chunkLoadOffline = tag.func_74767_n("chunk_load_offline");
        CompoundNBT chunksTag = tag.func_74775_l("chunks");
        for (String key : chunksTag.func_150296_c()) {
            RegistryKey dimKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(key));
            ListNBT chunksListTag = chunksTag.func_150295_c(key, 10);
            for (int i = 0; i < chunksListTag.size(); ++i) {
                CompoundNBT o = chunksListTag.func_150305_b(i);
                ClaimedChunk chunk = new ClaimedChunk(this, new ChunkDimPos(dimKey, o.func_74762_e("x"), o.func_74762_e("z")));
                chunk.time = o.func_74763_f("time");
                chunk.forceLoaded = o.func_74763_f("force_loaded");
                this.manager.claimedChunks.put(chunk.pos, chunk);
            }
        }
    }

    public int getExtraClaimChunks() {
        return this.extraClaimChunks;
    }

    public int getExtraForceLoadChunks() {
        return this.extraForceLoadChunks;
    }

    public boolean getChunkLoadOffline() {
        return this.chunkLoadOffline;
    }

    public void setChunkLoadOffline(boolean val) {
        this.chunkLoadOffline = val;
        this.save();
    }

    public void saveNow() {
        if (this.shouldSave && SNBT.write((Path)this.file, (CompoundNBT)this.serializeNBT())) {
            this.shouldSave = false;
        }
    }

    public static ServerPlayerEntity playerOrNull(CommandSource source) {
        Entity entity = source.func_197022_f();
        return entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null;
    }
}

