/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks;

import java.util.stream.Collectors;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import stormedpanda.simplyjetpacks.CreativeTabSimplyJetpacks;
import stormedpanda.simplyjetpacks.client.ClientJetpackHandler;
import stormedpanda.simplyjetpacks.client.hud.HUDHandler;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.crafting.EnergyTransferHandler;
import stormedpanda.simplyjetpacks.crafting.ModIntegrationCondition;
import stormedpanda.simplyjetpacks.crafting.PlatingReturnHandler;
import stormedpanda.simplyjetpacks.handlers.KeybindHandler;
import stormedpanda.simplyjetpacks.handlers.RegistryHandler;
import stormedpanda.simplyjetpacks.handlers.SyncHandler;
import stormedpanda.simplyjetpacks.integration.CuriosIntegration;
import stormedpanda.simplyjetpacks.integration.IntegrationList;
import stormedpanda.simplyjetpacks.items.JetpackItem;
import stormedpanda.simplyjetpacks.items.JetpackType;
import stormedpanda.simplyjetpacks.items.PilotGogglesItem;
import stormedpanda.simplyjetpacks.network.NetworkHandler;
import stormedpanda.simplyjetpacks.sound.ModSounds;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="simplyjetpacks")
public class SimplyJetpacks {
    public static SimplyJetpacks INSTANCE;
    public static final String MODID = "simplyjetpacks";
    public static final String MODNAME = "Simply Jetpacks 2";
    public static final String VERSION = "${version}";
    public static final Logger LOGGER;
    public static final CreativeTabSimplyJetpacks tabSimplyJetpacks;
    public static final ResourceLocation JETPACK_SLOT;

    public SimplyJetpacks() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTextureStitch));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlatingReturnHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EnergyTransferHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModSounds());
        MinecraftForge.EVENT_BUS.register(SimplyJetpacksConfig.class);
        if (ModList.get().isLoaded("curios")) {
            MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, SimplyJetpacksConfig.CLIENT_SPEC, "simplyjetpacks-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, SimplyJetpacksConfig.COMMON_SPEC, "simplyjetpacks-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SimplyJetpacksConfig.SERVER_SPEC, "simplyjetpacks-server.toml");
        CraftingHelper.register((IConditionSerializer)ModIntegrationCondition.Serializer.INSTANCE);
        IntegrationList.init();
        JetpackType.loadAllConfigs();
        RegistryHandler.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common Setup Method registered.");
        NetworkHandler.registerMessages();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Client Setup Method registered.");
        MinecraftForge.EVENT_BUS.register((Object)new KeybindHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientJetpackHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HUDHandler());
        KeybindHandler.setup();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("curios")) {
            InterModComms.sendTo((String)MODID, (String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
            InterModComms.sendTo((String)MODID, (String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("jetpack").size(1).icon(JETPACK_SLOT).build());
        }
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("Server starting...");
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        LOGGER.info("Server stopping...");
        SyncHandler.clear();
    }

    @SubscribeEvent
    public void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        LOGGER.info("Recipe Serializers Registered.");
        CraftingHelper.register((IConditionSerializer)ModIntegrationCondition.Serializer.INSTANCE);
    }

    private void onTextureStitch(TextureStitchEvent.Pre event) {
        if (ModList.get().isLoaded("curios") && event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            event.addSprite(JETPACK_SLOT);
        }
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (!ModList.get().isLoaded("curios")) {
            return;
        }
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_77973_b() instanceof JetpackItem) {
            event.addCapability(CuriosCapability.ID_ITEM, CuriosIntegration.initJetpackCapabilities(stack));
        }
        if (stack.func_77973_b() instanceof PilotGogglesItem) {
            event.addCapability(CuriosCapability.ID_ITEM, CuriosIntegration.initGogglesCapabilities(stack));
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        tabSimplyJetpacks = new CreativeTabSimplyJetpacks();
        JETPACK_SLOT = new ResourceLocation(MODID, "item/empty_jetpack_slot");
    }
}

