/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.integration;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import stormedpanda.simplyjetpacks.client.model.JetpackModel;
import stormedpanda.simplyjetpacks.items.JetpackItem;
import stormedpanda.simplyjetpacks.items.PilotGogglesItem;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosIntegration {
    public static ICapabilityProvider initGogglesCapabilities(final ItemStack itemStack) {
        return CuriosIntegration.getProvider(new ICurio(){

            public void playRightClickEquipSound(LivingEntity livingEntity) {
                livingEntity.field_70170_p.func_184148_a(null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), ((ArmorItem)itemStack.func_77973_b()).func_200880_d().func_200899_b(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }

            public boolean canRightClickEquip() {
                return true;
            }

            public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                BipedModel gogglesModel = new BipedModel(1.0f);
                ICurio.RenderHelper.followHeadRotations((LivingEntity)livingEntity, (ModelRenderer[])new ModelRenderer[]{gogglesModel.field_78116_c});
                IVertexBuilder vertexBuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)gogglesModel.func_228282_a_(new ResourceLocation("simplyjetpacks", "textures/models/armor/pilot_goggles_" + ((PilotGogglesItem)itemStack.func_77973_b()).getType() + "_layer_1.png")), (boolean)false, (boolean)itemStack.func_77973_b().func_77636_d(itemStack));
                gogglesModel.field_78116_c.func_228309_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
    }

    public static ICapabilityProvider initJetpackCapabilities(final ItemStack itemStack) {
        return CuriosIntegration.getProvider(new ICurio(){

            public void playRightClickEquipSound(LivingEntity livingEntity) {
                livingEntity.field_70170_p.func_184148_a(null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), ((ArmorItem)itemStack.func_77973_b()).func_200880_d().func_200899_b(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }

            public boolean canRightClickEquip() {
                return true;
            }

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof PlayerEntity) {
                    itemStack.onArmorTick(livingEntity.field_70170_p, (PlayerEntity)livingEntity);
                }
            }

            public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                JetpackModel jetpackModel = new JetpackModel();
                ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{jetpackModel});
                IVertexBuilder vertexBuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)jetpackModel.func_228282_a_(new ResourceLocation("simplyjetpacks", "textures/models/armor/" + ((JetpackItem)itemStack.func_77973_b()).getBaseName() + ".png")), (boolean)false, (boolean)itemStack.func_77973_b().func_77636_d(itemStack));
                jetpackModel.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
    }

    private static ICapabilityProvider getProvider(final ICurio curio) {
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOptional = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOptional);
            }
        };
    }
}

