/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.util;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.items.JetpackItem;
import stormedpanda.simplyjetpacks.util.SJStylesUtil;

public abstract class SJTextUtil {
    private static final ITextComponent on = SJTextUtil.translate("misc", "enabled", SJStylesUtil.GREEN, new Object[0]);
    private static final ITextComponent off = SJTextUtil.translate("misc", "disabled", SJStylesUtil.RED, new Object[0]);
    private static final ITextComponent notAvailable = SJTextUtil.translate("misc", "notAvailable", SJStylesUtil.DARK_GRAY, new Object[0]);
    private static final String ENERGY_FORMAT = "%,d";

    public static ITextComponent translate(String prefix, String suffix, Style style, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "simplyjetpacks", suffix);
        return new TranslationTextComponent(key, params).func_230530_a_(style);
    }

    public static ITextComponent translate(String prefix, String suffix, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "simplyjetpacks", suffix);
        return new TranslationTextComponent(key, params);
    }

    public static ITextComponent energy(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return SJTextUtil.translate("misc", "energy", s1);
    }

    public static ITextComponent energyPerTick(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return SJTextUtil.translate("misc", "energyPerTick", s1);
    }

    public static ITextComponent energyWithMax(int amount, int max) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        String s2 = String.format(ENERGY_FORMAT, max);
        return SJTextUtil.translate("misc", "energyWithMax", s1, s2);
    }

    public static ITextComponent getShiftText() {
        return SJTextUtil.translate("tooltip", "showDetails", new StringTextComponent("Shift").func_230530_a_(SJStylesUtil.GOLD));
    }

    public static void addBaseInfo(ItemStack stack, List<ITextComponent> list) {
        JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
        list.add(SJTextUtil.translate("tooltip", "tier", jetpack.tier));
        if (jetpack.isCreative()) {
            list.add(SJTextUtil.translate("tooltip", "infiniteEnergy", new Object[0]));
        } else {
            list.add(SJTextUtil.energyWithMax(jetpack.getEnergyStored(stack), jetpack.getMaxEnergyStored(stack)));
        }
    }

    public static void addShiftInfo(ItemStack stack, List<ITextComponent> list) {
        JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.engine", SJStylesUtil.GOLD, new Object[]{jetpack.isEngineOn(stack) ? on : off}));
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.hover", SJStylesUtil.GOLD, new Object[]{jetpack.isHoverOn(stack) ? on : off}));
        if (jetpack.getType().canCharge()) {
            list.add(SJTextUtil.translate("tooltip", "itemJetpack.charger", SJStylesUtil.GOLD, new Object[]{jetpack.isChargerOn(stack) ? on : off}));
        }
        if (!jetpack.isCreative()) {
            list.add(SJTextUtil.translate("tooltip", "itemJetpack.energyUsage", SJStylesUtil.GOLD, new Object[]{SJTextUtil.energyPerTick(jetpack.getEnergyUsage(stack))}));
        }
        ITextComponent particle = SJTextUtil.translate("tooltip", "particle." + jetpack.getType().getParticleType(stack).ordinal(), SJStylesUtil.WHITE, new Object[0]);
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.particleType", SJStylesUtil.GOLD, new Object[]{particle}));
    }

    public static void addHUDInfoText(ItemStack stack, List<ITextComponent> list) {
        list.add(SJTextUtil.getEnergyText(stack));
        list.add(SJTextUtil.getHUDStates(stack));
    }

    public static ITextComponent getEnergyText(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
        if (jetpack.isCreative()) {
            return SJTextUtil.translate("hud", "energyDisplay", SJTextUtil.translate("hud", "infiniteEnergy", SJStylesUtil.WHITE, new Object[0]));
        }
        int percent = (int)Math.ceil((double)jetpack.getEnergyStored(stack) / (double)jetpack.getCapacity() * 100.0);
        ITextComponent percentageText = SJTextUtil.getColoredPercent(percent);
        ITextComponent exactText = SJTextUtil.energy(jetpack.getEnergyStored(stack));
        if (((Boolean)SimplyJetpacksConfig.CLIENT.showExactEnergy.get()).booleanValue()) {
            return SJTextUtil.translate("hud", "energyDisplayExtra", percentageText, exactText);
        }
        return SJTextUtil.translate("hud", "energyDisplay", percentageText);
    }

    public static ITextComponent getColoredPercent(int percent) {
        if (percent > 70) {
            return new StringTextComponent(String.format("%s%%", percent)).func_230530_a_(SJStylesUtil.GREEN);
        }
        if (percent > 40) {
            return new StringTextComponent(String.format("%s%%", percent)).func_230530_a_(SJStylesUtil.YELLOW);
        }
        if (percent > 10) {
            return new StringTextComponent(String.format("%s%%", percent)).func_230530_a_(SJStylesUtil.GOLD);
        }
        if (percent > 0) {
            return new StringTextComponent(String.format("%s%%", percent)).func_230530_a_(SJStylesUtil.RED);
        }
        return SJTextUtil.translate("hud", "energyDepleted", SJStylesUtil.RED, new Object[0]);
    }

    public static ITextComponent getHUDStates(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
        Style on = SJStylesUtil.GREEN;
        Style off = SJStylesUtil.RED;
        Style notAvailable = SJStylesUtil.DARK_GRAY;
        ITextComponent engineState = SJTextUtil.translate("hud", "engine", jetpack.isEngineOn(stack) ? on : off, new Object[0]);
        ITextComponent hoverState = SJTextUtil.translate("hud", "hover", jetpack.isHoverOn(stack) ? on : off, new Object[0]);
        ITextComponent eHoverState = SJTextUtil.translate("hud", "eHover", jetpack.getType().canEHover() ? (jetpack.isEHoverOn(stack) ? on : off) : notAvailable, new Object[0]);
        ITextComponent chargerState = SJTextUtil.translate("hud", "charger", jetpack.getType().canCharge() ? (jetpack.isChargerOn(stack) ? on : off) : notAvailable, new Object[0]);
        return SJTextUtil.translate("hud", "jetpackStates", engineState, hoverState, eHoverState, chargerState);
    }

    public static ITextComponent getStateToggle(String state, boolean value) {
        return SJTextUtil.translate("chat", "itemJetpack." + state, value ? on : off);
    }

    public static ITextComponent getEmergencyText() {
        return SJTextUtil.translate("chat", "itemJetpack.emergencyHoverModeActivated", SJStylesUtil.RED, new Object[0]);
    }
}

