/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.item.FluidContainerItemAugmentable;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FluidReservoirItem
extends FluidContainerItemAugmentable
implements IMultiModeItem {
    protected static final int FILL = 0;
    protected static final int EMPTY = 1;

    public FluidReservoirItem(Item.Properties builder, int fluidCapacity) {
        super(builder, fluidCapacity);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("filled"), (stack, world, entity) -> this.getFluidAmount(stack) > 0 ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("active"), (stack, world, entity) -> this.getFluidAmount(stack) > 0 && this.getMode(stack) > 0 ? 1.0f : 0.0f);
        this.numSlots = () -> ThermalConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.FLUID_VALIDATOR;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)(this.isActive(stack) ? new TranslationTextComponent("info.cofh_use_sneak_deactivate").func_240699_a_(TextFormatting.DARK_GRAY) : new TranslationTextComponent("info.cofh.use_sneak_activate").func_240699_a_(TextFormatting.DARK_GRAY)));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.reservoir.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.4f, 0.6f + 0.2f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.reservoir.mode." + this.getMode(stack)));
    }
}

