/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.item.EnergyContainerItemAugmentable;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.capability.CapabilityAreaEffect;
import cofh.lib.capability.IAreaEffect;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.helpers.AreaEffectHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class RFPumpItem
extends EnergyContainerItemAugmentable
implements IMultiModeItem {
    public static final int ENERGY_PER_USE = 200;

    public RFPumpItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("active"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 && this.hasActiveTag(stack) ? 1.0f : 0.0f);
        this.numSlots = () -> ThermalConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "RF", "Area", "Filter"});
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.single_block").func_240699_a_(TextFormatting.ITALIC));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.area").func_240702_b_(": " + radius + "x" + radius).func_240699_a_(TextFormatting.ITALIC));
        }
        if (this.getNumModes(stack) > 1) {
            this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
        }
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.hasActiveTag(stack)) {
            return;
        }
        long activeTime = stack.func_196082_o().func_74763_f("Active");
        if (entityIn.field_70170_p.func_82737_E() > activeTime) {
            stack.func_196082_o().func_82580_o("Active");
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"Radius");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected int getEnergyPerUse(ItemStack stack) {
        return 200;
    }

    protected int getRadius(ItemStack stack) {
        return (int)AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"Radius", (float)0.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new RFPumpItemWrapper(stack, (IEnergyContainerItem)this);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        if (this.getMode(container) >= this.getNumModes(container)) {
            this.setMode(container, this.getNumModes(container) - 1);
        }
    }

    public int getNumModes(ItemStack stack) {
        return 1 + this.getRadius(stack);
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.4f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.cofh.single_block"));
        } else {
            ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.cofh.area").func_240702_b_(": " + radius + "x" + radius));
        }
    }

    protected class RFPumpItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffect {
        private final LazyOptional<IAreaEffect> holder;

        RFPumpItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn);
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, PlayerEntity player) {
            return AreaEffectHelper.getBucketableBlocksRadius((ItemStack)this.container, (BlockPos)pos, (PlayerEntity)player, (int)RFPumpItem.this.getMode(this.container));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

