/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemItemHandler
implements IItemHandlerModifiable {
    private final ItemStack itemStack;

    public ItemItemHandler(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    protected abstract NonNullList<ItemStack> getItemList();

    protected abstract void setItemList(NonNullList<ItemStack> var1);

    public void setStackInSlot(int slot, ItemStack stack) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.getItemList().get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existingStack = (ItemStack)itemStacks.get(slot);
        if (!existingStack.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack)) {
                return stack;
            }
            int maxStackSize = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - existingStack.func_190916_E();
            if (stack.func_190916_E() <= maxStackSize) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(existingStack.func_190916_E());
                    this.setStackInSlot(slot, copy);
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(maxStackSize);
                copy.func_190917_f(existingStack.func_190916_E());
                this.setStackInSlot(slot, copy);
                return stack;
            }
            stack.func_190918_g(maxStackSize);
            return stack;
        }
        int maxStackSize = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (maxStackSize < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.setStackInSlot(slot, stack.func_77979_a(maxStackSize));
                return stack;
            }
            stack.func_190918_g(maxStackSize);
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existingStack = this.getStackInSlot(slot);
        if (existingStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = existingStack.func_77979_a(amount);
        if (!simulate) {
            this.setStackInSlot(slot, existingStack);
        }
        return extracted;
    }
}

