/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import mcjty.rftoolsstorage.modules.modularstorage.items.StorageModuleItem;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageHolder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CommandRestore
implements Command<CommandSource> {
    private static final CommandRestore CMD = new CommandRestore();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"restore").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"uuid", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String uuidString = (String)context.getArgument("uuid", String.class);
        ItemStack stack = ((CommandSource)context.getSource()).func_197035_h().func_184614_ca();
        if (!(stack.func_77973_b() instanceof StorageModuleItem)) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Keep a storage module in your main hand!").func_240700_a_(style -> style.func_240721_b_(TextFormatting.RED)), true);
            return 0;
        }
        int maxSize = StorageModuleItem.getSize(stack);
        StorageHolder holder = StorageHolder.get((World)((CommandSource)context.getSource()).func_197023_e());
        StorageEntry foundEntry = null;
        for (StorageEntry storage : holder.getStorages()) {
            if (!storage.getUuid().toString().startsWith(uuidString)) continue;
            if (foundEntry != null) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Multiple storage entries match this UUID part!").func_240700_a_(style -> style.func_240721_b_(TextFormatting.RED)), true);
                return 0;
            }
            foundEntry = storage;
        }
        if (foundEntry != null) {
            if (foundEntry.getStacks().size() != maxSize) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Wrong foundEntry module tier! " + foundEntry.getStacks().size() + " stacks are required!").func_240700_a_(style -> style.func_240721_b_(TextFormatting.RED)), true);
            } else {
                stack.func_196082_o().func_186854_a("uuid", foundEntry.getUuid());
                ((CommandSource)context.getSource()).func_197035_h().field_71069_bz.func_75142_b();
            }
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("No storage found with UUID " + uuidString).func_240700_a_(style -> style.func_240721_b_(TextFormatting.RED)), true);
        }
        return 0;
    }
}

